// -[KeepHeading]-


// -[Copyright]-

/**
 * (c) Copyright 1993-1994. Step Ahead Software Pty Limited. All rights
 * reserved.
 */
import java.lang.*;


// -[KeepBeforeClass]-
import java.awt.*;


// -[Class]-

/**
 * @jTitle           Circle
 * @jOverridability  can be overridden
 * @jDescription
 * Describe here
 * 
 * @see              Shape
 */
public 
class Circle extends Shape
{
// -[KeepWithinClass]-


// -[Fields]-



/**
 * The radius of the circle
 */
protected int radius;


// -[Methods]-

/**
 * Constructs a circle object with given position and radius.
 */
public Circle(int initX, int initY, int initRadius) {
        super(initX, initY);
        radius = initRadius;
}

/**
 * Abstract method overridden in derived classes to paint objects.
 */
public void show(Graphics g)
{
	// Get current color
	Color oldColor = g.getColor();

	// Change to red
	g.setColor(Color.red);

	// Draws a circle within the rectangle specified with
	// top, left point and width and height
	g.fillOval(x, y, radius * 2, radius * 2);

	// Restore old color - it's always good practice to leave things the
	// way we found them - think of your kid's future!
	g.setColor(oldColor);
}

}


