// -[KeepHeading]-


// -[Copyright]-

/**
 * (c) Copyright 1993-1994. Step Ahead Software Pty Limited. All rights
 * reserved.
 */
import java.lang.*;


// -[KeepBeforeClass]-
import java.awt.*;


// -[Class]-

/**
 * @jTitle           Box
 * @jOverridability  can be overridden
 * @jDescription
 * Represents boxes in the application.
 * 
 * @see              Shape
 */
public 
class Box extends Shape
{
// -[KeepWithinClass]-


// -[Fields]-



/**
 * Init height.
 */
protected int h;



/**
 * Init width.
 */
protected int w;


// -[Methods]-

/**
 * Abstract method overridden in derived classes to paint objects.
 */
public void show(Graphics g)
{
	// Get current color
	Color oldColor = g.getColor();

	// Change to yellow
	g.setColor(Color.yellow);

	// Draws a circle within the rectangle specified with
	// top, left point and width and height
	g.fillRect(x, y, w, h);

	// Restore old color - it's always good practice to leave things the
	// way we found them - think of your kid's future!
	g.setColor(oldColor);	
}

/**
 * Constructs a box with the given position and height.
 */
public Box(int initX, int initY, int initWidth, int initHeight)
{
	super(initX, initY);
	w = initWidth;
	h = initHeight;
}

}


