// -[KeepHeading]-


// -[Copyright]-

/**
 * (c) Step Ahead Software Pty Ltd 1996. All rights reserved. Registered
 * of JAVelin may use this applet in their web pages.
 */
import java.lang.*;


// -[KeepBeforeClass]-
import	java.awt.*;


// -[Class]-

/**
 * @jTitle           BounceAnimation
 * @jAuthor          Chris Colman
 * @jOverridability  can be overridden
 * @jDescription
 * Class for objects that can bounce off the left and right boundaries.
 * 
 * @see              
 */
public 
class BounceAnimation
{
// -[KeepWithinClass]-


// -[Fields]-



/**
 * Color of the object.
 */
protected Color color;



/**
 * Current direction of object: -1 is to the left, 1 is to the right.
 */
protected int direction;



/**
 * The text displayed by the object as it moves.
 */
protected String s;



/**
 * Current speed of object.
 */
protected int speed;



/**
 * x coorinate of current position.
 */
protected int x;



/**
 * y coordinate of current position.
 */
protected int y;


// -[Methods]-


/**
 * Constructs a bouncing object with the given text (string), direction
 * (-1 left, 1 right), color, initial position and speed.
 */
public BounceAnimation(String s, int direction, Color color, int x, int y, int speed) {
        this.s = s;
        this.direction = direction;
        this.color = color;
        this.x = x;
        this.y = y;
        this.speed = speed;
 }

public void advance(int dispWidth) {

        if ( x > dispWidth )
                direction = -1;
        else if ( x < 0 )
                direction = 1;

        // Adjust horizontals
        switch ( direction )
        {
                case 1:
                        x += speed;
                        break;
                case -1:
                        x -= speed;
        }
 }

public void paint(Graphics g) {
        Color oldColor = g.getColor();
        g.setColor(color);
        g.drawString(s, x, y);
        g.setColor(oldColor);
 }
}