{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; pointer list based on an array with links to elements

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBBAS, EFLIBDAT, EFLIBTXT;


const CapacityOfElements = 10; { Will be doubled }
      NumberOfElements   = 20;

var MyList: PointerListObjectType; Text : string; Index : word;
    Memory : longint; Timer : TimerObjectType;


begin
     Randomize; Timer.Initialize; Memory := MemAvail;

     WriteLn ('* Pointer list with dynamic element allocation *');

     { Build link database (CapacityOfElements number of links) }

     with MyList do begin
          { Initialize a pointer list with a specified maximum number
            of elements (element capacity), ie. the a specific number
            of links. The growth factor is set to zero to disable
            automatic growth when the list is full. If growth size
            is not zero, the list will adjust it's size in segments of
            specified number of elements. }
          Initialize (CapacityOfElements, 0, SizeOf(Text));
                     { Links / elements }    { Element size }
                                { Optional growth size }

          { Double the storage capacity of the pointer list. Any elements
            that is inside the list and is outside the new size will
            be truncated. All other elements are kept, but pulled
            to the leftmost position inside the list. }

          Resize (CapacityOfElements * 2);

          { The pointer list is an array list based on pointers to
            elements. When an element is added (updated) memory is
            allocated for the element an the pointer inside the array
            list is changed. The pointer list has the flexibility
            of an array list but the effiency of a linked list. }

          WriteLn (Memory - MemAvail,' bytes needed for initial link database.');

          { Update some elements }
          for Index := 1 to NumberOfElements do begin
              Text := StringGeneratedRandomly (35);
              Add (Text);
          end;

          { Move entries randomly }
          for Index := 1 to Capacity do Swap (Succ(Random(Capacity)), Succ(Random(Capacity)));

          { Display entries }
          for Index := Capacity downto 1 do { Display used elements only }
              if IsUsed(Index) then Write (String(ElementPointer(Index)^):40);

          WriteLn;
          WriteLn (Memory - MemAvail,' bytes needed when ', (Elements / Capacity)*100:0:0 ,
                   '% of structure capacity is used (', Elements, ' elements of ', Capacity, ').');

          Intercept; { Pointer list }
     end;

     with Timer do begin WriteLn (StringMS); Intercept; end;
     if GlobalDataError then WriteLn ('Error(s) reported!');
end.