{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; hash table clustering test (tests algorithm effeciency)

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBDAT, EFLIBBAS, EFLIBTXT;

const CapacityOfElements = 400; { Maximum capacity }
      NumberOfElements   = CapacityOfElements div 4; { Number of elements to add }

var Table : HashTableObjectType; SomeData : string[30]; Index : word;


begin
     Randomize;

     with Table do begin
          { Initializes hash table }
          Initialize (CapacityOfElements, SizeOf(SomeData));

          { Add some random elements (the random elements will
            all be of the same size and will result in ineffecient
            use of the hashing algorithm, even though it has been
            optimized for text elements). }

          for Index := 1 to NumberOfElements do begin
              SomeData := StringGeneratedRandomly(Pred(SizeOf(SomeData)));
              Add (SomeData); { Add some random strings }
          end;

          { Show used elements }
          for Index := 1 to Capacity do
              if IsUsed(Index) then Write ('[x] ') else Write ('[ ] ');

          if Elements <> NumberOfElements then WriteLn ('Error - duplicate?');

          if (Search(ElementPointer(1)^) <> 1) then
             WriteLn ('Test; first element doesn''t exist.');

          { EFLIB provides a very efficient hash code algorithm for
            text strings that works bitwise. }

          WriteLn;

          Intercept;
     end;
     if GlobalDataError then WriteLn ('Error(s) reported!');
end.