unit Optmain1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Mask, ExtCtrls, Buttons, OvcPF, OvcBase, OvcEF,
  OvcPB, OvcNF, Option;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Panel2: TPanel;
    SpeedButton1: TSpeedButton;
    Label7: TLabel;
    Label8: TLabel;
    RadioGroup1: TRadioGroup;
    Panel3: TPanel;
    OvcController1: TOvcController;
    StockPrice: TOvcNumericField;
    DDate: TOvcPictureField;
    ExercizeDate: TOvcPictureField;
    IntrestRate: TOvcNumericField;
    StrikePrice: TOvcNumericField;
    Dividende: TOvcNumericField;
    CallPrice: TOvcNumericField;
    Volatility: TOvcNumericField;
    Header1: THeader;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Delta: TOvcNumericField;
    Gamma: TOvcNumericField;
    Vega: TOvcNumericField;
    Rho: TOvcNumericField;
    Theta: TOvcNumericField;
    Omega: TOvcNumericField;
    CallOption1: TCallOption;
    procedure RadioGroup1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
     if RadioGroup1.ItemIndex=0 then
        begin
        Label7.Visible:=False;
        CallPrice.Visible:=False;
        Label8.Visible:=True;
        Volatility.visible:=True;
        end
     else
        begin
        Label7.Visible:=True;
        CallPrice.Visible:=True;
        Label8.Visible:=False;
        Volatility.visible:=False;
        end;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
Var
   TimeToMat:double;
begin
     TimeToMat:=(ExercizeDate.AsOvcDate-DDate.AsOvcDate)/365.0;
     if TimeToMat<(1.0/365.0) then
         MessageDlg('Exersize Date must be greater then current date', mtWarning,
         [mbOk], 0)
     else if ((RadioGroup1.ItemIndex=0) and (Volatility.AsFloat<0.001)) then
          MessageDlg('Volatility must be greater then Zero', mtWarning, [mbOk], 0)
       else if ((RadioGroup1.ItemIndex=1) and (CallPrice.AsFloat<0.001)) then
          MessageDlg('Call Price must be greater then Zero', mtWarning, [mbOk], 0)
        else 
         begin
         CallOption1.StockPrice:=StockPrice.AsFloat;
         CallOption1.Intrest:=IntrestRate.Asfloat/100.0;
         CallOption1.ExPrice:=StrikePrice.AsFloat;
         CallOption1.DDate:=DDate.AsDateTime;
         CallOption1.ExDate:=ExercizeDate.AsDateTime;
         CallOption1.Dividends:=Dividende.AsFloat/100.0;
         if (RadioGroup1.ItemIndex=0) then
            begin
            CallOption1.ImpVol:=Volatility.AsFloat/100.0;
{******************************************}
{ Full B&S calculation in one line of code.}
{******************************************}

            CallPrice.AsFloat:=CallOption1.Price;

{******************************************}
{******************************************}

            CallPrice.Visible:=True;
            Label7.Visible:=True;
            end
         else
            begin
            CallOption1.Price:=CallPrice.AsFloat;
{*********************************************************}
{ Full Implied volatility calculation in one line of code.}
{*********************************************************}
            Volatility.AsFloat:=CallOption1.ImpVol*100.0;
            Volatility.Visible:=True;
            Label8.Visible:=True;
            end;

         Delta.AsFloat:=CallOption1.Delta;
         Theta.AsFloat:=CallOption1.Theta;
         Gamma.AsFloat:=CallOption1.Gamma;
         Rho.AsFloat:=CallOption1.Rho;
         Vega.AsFloat:=CallOption1.Vega;
         Omega.Asfloat:=CallOption1.Omega;
         end; { if }
end;

end.
