/********************  PRINTAPP.H  ---  Listing 4  *******************
 * Author: Victor Volkman
 * Purpose: Header file for PRINTCLI.C and PRINTSRV.C
 * May be freely used if authorship is acknowledged
 *********************************************************************/

#define SERVER_RTO 30   /* Client should not pause more than 15 secs. */
#define SERVER_STO  0   /* Server doesn't SEND in this application    */
#define CLIENT_RTO  0   /* Client doesn't RECEIVE in this application */
#define CLIENT_STO 30   /* Server should not pause more than 15 secs. */

/* return values from printsrv.exe: */
#define SRV_OK              0
#define SRV_NO_NETBIOS      1
#define SRV_NO_ARGS         2
#define SRV_BAD_FILE        3
#define SRV_BAD_SERVER_NAME 4
#define SRV_CANT_LISTEN     5

/* return values from printcli.exe: */
#define CLI_OK              0
#define CLI_NO_NETBIOS      1
#define CLI_NO_ARGS         2
#define CLI_BAD_FILE        3
#define CLI_BAD_CLIENT_NAME 4
#define CLI_CANT_CALL       5
#define CLI_SEND_FAILED     6

#define MAX_MSG_LEN 4096  /* arbitrary largest msg we will send */

#define PRINTER_INT    0x17  /* BIOS printer interface       */
#define PRINTER_STATUS 0x02  /* INT 17h sub-function         */
#define STATUS_MASK    0xF9  /* masks off unused status bits */

#define RD_FLAGS (O_BINARY|O_RDONLY)
#define WR_FLAGS (O_BINARY|O_WRONLY|O_TRUNC|O_CREAT)

typedef struct print_msg {
   char filename[80];
   int length;
   char buffer[MAX_MSG_LEN];
   } PRINT_MSG;

char *default_server_name = "PRINTSRV";
char *default_client_name = "PRINTCLI";

int nb_debug;