// DROPMENU.CPP : methods for drop-menus
// by Bruce Eckel. (c) The C Gazette

#include <string.h>
#include <conio.h>
#include "dropmenu.hpp"
#include "scrnbox.hpp"

// The activation letter is preceded by a '^' :
void dm_item::find_activation_letter() {
  char * al = strchr(name, '^');
  if(al)  // strchr returns NULL if not found
    if(*++al)  // must not be end of string
      activation_letter = *al;
}

dm_item::dm_item(char * nm, int (*fp)(void)) :
  name(nm), fptr(fp), mptr(NULL) {
  find_activation_letter();
}

dm_item::dm_item(char * nm, drop_menu * submenu) :
  name(nm), mptr(submenu), fptr(NULL) {
  find_activation_letter();
}

// Print an individual item, emphasizing the activation letter:
void dm_item::print(int line, screen_box & box) {
  actual_line = line;
  box.move(actual_line);
  char * cp = name;
  while(*cp) {
    if(*cp == '^') { // next char in standout mode
      if(*++cp)
        box.emphasize(*cp++);
    } else
      box.put_c(*cp++);
  }
}

// Check to see if the keypress is this dm_item's activation letter.
// If so, call the function or activate the submenu.
void dm_item::test_and_execute(unsigned keypress, drop_menu & menu) {
  if(keypress == activation_letter)
    if(fptr != NULL) // means it's a function
      (*fptr)();
    else
      mptr->activate(menu.y() + actual_line, menu.x() + menu.width());
}

drop_menu::drop_menu(dm_item ** dm, unsigned xpos, unsigned ypos)
  : items(dm) {
  default_x = actual_x = xpos;
  default_y = actual_y = ypos;
  mheight = mwidth = 0;
  // Determine the width and height of the menu:
  while(*(items[mheight]->nm())) {
    unsigned width = strlen(items[mheight]->nm());
    // Check for a hotkey, which adds an unprinted char to the string:
    if(strchr(items[mheight]->nm(), '^'))
      width--;
    if (width > mwidth) mwidth = width;
    mheight++;
  }
}

// Bring up the menu in its default location if no arguments are
// given, or the location specified by the arguments.  Note that
// "location" is given in terms of text-mode x-y coords, even though
// graphics mode may in fact be used.
void drop_menu::activate(unsigned y, unsigned x) {
  if (x == 0 && y == 0) {
    actual_x = default_x;
    actual_y = default_y;
  } else {
    actual_x = x;
    actual_y = y;
  }
  // Create a menubox and print all the items to it:
  screen_box menubox(actual_y, actual_x, mheight, mwidth);
  for(int i = 0; i < mheight; i++) {
    items[i]->print(i, menubox);
  }
  // get input and do the user's command:
  test_keypress(getch());
}

void drop_menu::test_keypress(unsigned keypress) {
  for(int i = 0; i < mheight; i++)
    items[i]->test_and_execute(keypress, *this);
}