/******************  PRINTSRV.C  ---  Listing 8  *********************
 * Author: Victor Volkman
 * Purpose: Sample print server--receives and prints file from client
 *          routine defined in printcli.c
 *
 * Compiler: Microsoft C 5.1, Turbo C 2.0
 *
 * Source code may be freely used if the authorship is acknowledged.
 * Object code may be freely used.
 *********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <sys\types.h>
#include <sys\stat.h>

#include "netbios.h"
#include "printapp.h"
#include "netbios.fd"

#ifndef MAKEFD  /* fd = compiler generated function declaration file */
#include "printsrv.fd"
#endif


PRINT_MSG server_msg;
char print_buffer[512];
extern NCB listen;

int main(argc,argv)
int argc;
char **argv;
{
   int err;
   int  prn_file;
   int  port_no;
   char server_name[NAME_LEN];

   printf("Demonstration Server Process\n\n");
   nb_debug = getenv("NB_DEBUG") != NULL;

   if (err=StartupServer(argc,argv,&prn_file,&port_no,server_name) )
      return err;
   if (err=ServiceClients(prn_file,port_no,server_name) )
      return err;
   err = ShutdownServer(server_name);
   return err;
}


int StartupServer(argc,argv,prn_file,port_no,server_name)
int argc;
char **argv;
int *prn_file;
int *port_no;
char *server_name;
{
   char print_file[80];
   char *name_ptr;
   int err;

   if (!IsNetbiosLoaded()) {
      fprintf(stderr, "NetBIOS not loaded... aborting\n");
      return SRV_NO_NETBIOS;
      }

   if (argc < 2 || (argc == 2 && strnicmp(argv[1],"LPT",3) != 0) )  {
      fprintf(stderr, "%s: printer name missing!\n\n",argv[0]);
      fprintf(stderr, "Usage:  PRINTSRV [LPT1 | LPT2 | LPT3]\n");
      return SRV_NO_ARGS;
      }

   strcpy(print_file,argv[1]);
   *port_no = atoi(print_file+3) - 1;  /* LPT1 = 0, LPT2 = 1, LPT3 = 2 */

   if ((*prn_file=open(print_file,WR_FLAGS,S_IWRITE)) < 0) {
      fprintf(stderr,"Unable to open print file <%s>... aborting\n",
              print_file);
      return SRV_BAD_FILE;
      }

   if ((name_ptr=getenv(default_server_name)) == NULL)
      strcpy(server_name, default_server_name);
   else
      strcpy(server_name, name_ptr);

   NetbiosReset();
   if (err=NetbiosAddName(server_name)) {
      fprintf(stderr,"(%02X):  unable to add server name <%s>... aborting\n",
              err, server_name);
      return SRV_BAD_SERVER_NAME;
      }

   return SRV_OK;
}


int ServiceClients(prn_file,port_no,server_name)
int prn_file;
int port_no;
char *server_name;
{
   int err;
   int files_printed=0;
   int files_received=0;

   int listening=FALSE;    /* Server state variables */
   int receiving=FALSE;
   int printing=FALSE;
   int finishing=FALSE;
   int done=FALSE;

   int tmp_prn_file;       /* File currently being printed   */
   int tmp_rcv_file;       /* File currently being received  */
   int status_ok;
   long total_bytes;
   char temp_filename[80];
   unsigned bytes_read;
   SESSION lsn;

   printf("%s is up... press 'S' for status, 'X' to exit\n",server_name);
   status_ok = PrinterStatus(port_no);  /* Assume printer is ok to start */

   while (!done) {

      if (kbhit() ) {
         switch (toupper(getch())) {
            case 'X':
               printf("Exit key hit:  finishing up...\n");
               finishing = TRUE;
               break;
            case 'S':
               printf("Files printed %5d, files received %5d\n",
                       files_printed, files_received);
               break;
            }
         }

      if (!listening && !receiving && !finishing) {
         if ((err=NetbiosListen(server_name, SERVER_RTO, SERVER_STO)) !=
                 CMD_PENDING) {
            fprintf(stderr,"(%02X):  unable to issue listen... aborting\n",
                    err);
            return SRV_CANT_LISTEN;
            }
         listening = TRUE;
         }

      if (listening && (listen.cmd_cplt != CMD_PENDING)) {
         listening = FALSE;
         receiving = TRUE;
         total_bytes = 0L;
         lsn = listen.lsn;
         MakeFilename(server_name, files_received, temp_filename);
         tmp_rcv_file = open(temp_filename, WR_FLAGS, S_IWRITE);
         }

      if (receiving) {
         NetbiosReceive(lsn, (char *)&server_msg, sizeof(PRINT_MSG));
         if (total_bytes == 0)
            printf("Receiving %s ...\n",server_msg.filename);
         total_bytes += server_msg.length;
         if (server_msg.length == 0) {
            write(tmp_rcv_file, "\014", sizeof(char));  /* Form Feed */
            close(tmp_rcv_file);
            files_received++;
            NetbiosHangup(lsn);
            receiving = FALSE;
            listening = FALSE;
            }
         else
            write(tmp_rcv_file, server_msg.buffer, server_msg.length);
         }

      if (printing) {
         if (PrinterStatus(port_no) == status_ok ) {
            if ((bytes_read = read(tmp_prn_file, print_buffer,
                                  sizeof(print_buffer))) > 0)
               write(prn_file, print_buffer, bytes_read);
            else {
               close(tmp_prn_file);
               MakeFilename(server_name, files_printed, temp_filename);
               remove(temp_filename);
               printing = FALSE;
               files_printed++;
               }
            }
         }
      else {     /* !printing */
         if (files_printed < files_received) {
            MakeFilename(server_name, files_printed, temp_filename);
            tmp_prn_file = open(temp_filename, RD_FLAGS);
            printing = TRUE;
            }
         else
            done = finishing;
         }
      }
   return SRV_OK;
}



int ShutdownServer(server_name)
char *server_name;
{
   NetbiosDeleteName(server_name);  /* must drop before exiting */
   return SRV_OK;
}



void MakeFilename(server_name, file_no, new_name)
char *server_name;
int file_no;
char *new_name;
{
   sprintf(new_name,"%.8s.%03d",server_name,file_no);
}


int PrinterStatus(port_no)
int port_no;
{
   union REGS InRegs, OutRegs;
   int status;

   memset(&InRegs, 0, sizeof(union REGS));
   InRegs.h.ah = PRINTER_STATUS;
   InRegs.x.dx = port_no;
   int86(PRINTER_INT, &InRegs, &OutRegs);
   status = OutRegs.h.ah & STATUS_MASK;
   return status;
}