/*********************  NETBIOS.H  --  Listing 1 *********************
 * Purpose: Header file for NETBIOS.C
 * Author: Victor Volkman
 *********************************************************************/

#define NAME_LEN 16
typedef unsigned char SESSION;

/* The NCB structure must be exactly 64 bytes for NETBIOS to work */

typedef struct ncb {          /* NCB = Network Control Block           */
   unsigned char command;     /* Command code                          */
   unsigned char ret_code;    /* Error return value                    */
   SESSION lsn;               /* LSN = Local Session Number            */
   unsigned char num;         /* Index assigned by ADD NAME            */
   char far *buffer;          /* Points to send or receive buffer      */
   unsigned int length;       /* # of bytes to send or receive         */
   char call_name[NAME_LEN];  /* Name of who you want to call          */
   char name[NAME_LEN];       /* Name belonging to you                 */
   unsigned char rto;         /* RTO = Receive Time-Out (in 1/2 secs)  */
   unsigned char sto;         /* STO = Send Time-Out (in 1/2 secs)     */
   void (interrupt far *post_rtn) ();  /* Service routine for no-waits */
   unsigned char lana_num;    /* LAN adapter card number (0 or 1)      */
   unsigned char cmd_cplt;    /* FF = pending, 00 = complete           */
   char reserve[14];          /* NetBIOS use only; do not touch!       */
   } NCB;

#define NETBIOS_INT          0x5C

/* NCB commands */
#define NETBIOS_ADD_NAME     0x30
#define NETBIOS_CALL         0x10
#define NETBIOS_DELETE_NAME  0x31
#define NETBIOS_HANGUP       0x12
#define NETBIOS_LISTEN       0x11
#define NETBIOS_RECEIVE      0x15
#define NETBIOS_RESET        0x32
#define NETBIOS_SEND         0x14

#define NO_WAIT              0x80  /* These flags are ORed into the    */
#define WAIT_FOR             0x00  /* NCB commands as desired.         */

/* NCB error codes */
#define CMD_PENDING          0xFF  /* normal return for a NO_WAIT cmd  */

/* Misc. values */
#define FALSE                   0
#define TRUE                    1