/****************  EMSDEMO.C  ---  Listing 2  ******************
*
*    This program demonstrates the use of the expanded memory functions
*    defined in Listing 1 (EMS.C).  Validated for Microsoft and Turbo C
*
*    Copyright (C) Michael J. Young, 1989.  All rights reserved.
*    May be used freely for non-commercial purposes.
***************************************************************/

#include <CONIO.H>
#include <DOS.H>
#include <MALLOC.H>
#include <PROCESS.H>
#include <STDIO.H>
#include <STRING.H>

#include "EMS.H"

void ScrClear (unsigned char StartRow,unsigned char StartCol,
               unsigned char StopRow,unsigned char StopCol);

void main (void)
{
     char far *Buffer;
     unsigned char far *PtrVideoMode = (unsigned char far *)0x00400049;
     unsigned int VideoSeg;

     if (EmsInstalled () && EmsPagesAvail () >= 1)
     {
          Buffer = EmsAlloc (1);
          EmsMap (0,-1,-1,-1);
          printf ("Using expanded memory to save the screen.\n");
     } /* end if EMS is installed */

     else   /* EMS not installed */
     {
          Buffer = (char far *) malloc (4000);
          if (FP_OFF (Buffer) == NULL)
          {
               fprintf (stderr,"Sorry, no memory free for saving screen.\n");
               exit (1);
          }
          printf ("Using heap memory to save the screen.\n");
     } /* end if EMS not installed */

     VideoSeg = (*PtrVideoMode == 7) ? 0xB000 : 0xB800;
     printf ("Press any key to save the screen data and clear the screen.\n");
     getch ();
     movedata (VideoSeg,0,FP_SEG (Buffer),FP_OFF (Buffer),4000);
     ScrClear (0,0,24,79);
     printf ("Press any key to restore the screen data...");
     getch ();
     movedata (FP_SEG (Buffer),FP_OFF (Buffer),VideoSeg,0,4000);
     EmsFree ();

} /* end main */


void ScrClear (unsigned char StartRow,unsigned char StartCol,
               unsigned char StopRow,unsigned char StopCol)
/*
     This function clears the rectangular section of the screen specified
     by the four parameters.
*/
{
     union REGS Reg;

     Reg.h.bh = 0x07;         /* Use normal, white on black video attribute.*/
     Reg.h.ch = StartRow;     /* CH specifies start row.                    */
     Reg.h.cl = StartCol;     /* CL specifies start column.                 */
     Reg.h.dh = StopRow;      /* DH specifies stop row.                     */
     Reg.h.dl = StopCol;      /* DL specifies stop column.                  */
     Reg.x.ax = 0x0600;       /* BIOS scroll page up function.              */
     int86 (0x10,&Reg,&Reg);  /* Invoke BIOS video services.                */

} /* end ScrClear */