/*******************  PRINTCLI.C  ---  Listing 6  ********************
 * Author: Victor Volkman
 * Purpose: Sample client routine--transfers a file to the print
 *          server defined in PRINTSRV.C
 *
 * Compiler: Microsoft C 5.1, Turbo C 2.0
 *
 * Source code may be freely used if the authorship is acknowledged.
 * Object code may be freely used.
 *********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>

#include "netbios.h"
#include "printapp.h"
#include "netbios.fd"

#ifndef MAKEFD  /* fd = compiler generated function declaration file */
#include "printcli.fd"
#endif

PRINT_MSG client_msg;

int main(argc,argv)
int argc;
char **argv;
{
   SESSION lsn;
   int err;
   int send_file;
   char client_name[NAME_LEN];

   printf("Demonstration Client Process\n\n");
   nb_debug = getenv("NB_DEBUG") != NULL;
   if (err=StartupClient(argc, argv, &send_file) )
      return err;

   if (err=ConnectToServer(&lsn, client_name) )
      return err;

   if (err=SendPrintFile(lsn, send_file) )
      return err;

   close(send_file);
   err = DisconnectFromServer(lsn, client_name);

   printf("sizeof %d\n",sizeof(NCB));
   return err;
}


int StartupClient(argc,argv,send_file)
int argc;
char **argv;
int *send_file;
{
   if (!IsNetbiosLoaded()) {
      fprintf(stderr, "NetBIOS not loaded... aborting\n");
      return CLI_NO_NETBIOS;
      }

   if (argc < 2) {
      fprintf(stderr, "%s: filename missing!\n\n",argv[0]);
      fprintf(stderr, "Usage:  PRINTCLI filename\n");
      return CLI_NO_ARGS;
      }

   strcpy(client_msg.filename,argv[1]);
   if ((*send_file=open(client_msg.filename,RD_FLAGS)) < 0) {
      fprintf(stderr,"Unable to open send file <%s>... aborting\n",
              client_msg.filename);
      return CLI_BAD_FILE;
      }

   return CLI_OK;
}


int ConnectToServer(lsn_p, client_name)
SESSION *lsn_p;
char *client_name;
{
   char *server_name;
   char *name_ptr;
   int err;

   if ((name_ptr=getenv(default_client_name)) == NULL)
      strcpy(client_name, default_client_name);
   else
      strcpy(client_name, name_ptr);

   if ((server_name=getenv(default_server_name)) == NULL)
      server_name = default_server_name;

   NetbiosReset();
   if (err=NetbiosAddName(client_name)) {
      fprintf(stderr,"(%02X):  unable to add client name <%s>... aborting\n",
              err, client_name);
      return CLI_BAD_CLIENT_NAME;
      }

   if (err=NetbiosCall(lsn_p,server_name,client_name,CLIENT_RTO,CLIENT_STO)) {
      fprintf(stderr,"(%02X):  unable to find server name <%s>... aborting\n",
              err, server_name);
      NetbiosDeleteName(client_name);  /* must drop before exiting */
      return CLI_CANT_CALL;
      }

   return CLI_OK;
}


int SendPrintFile(lsn, send_file)
SESSION lsn;
int send_file;
{
   int bytes_read;
   int err;

   while ((bytes_read=read(send_file, client_msg.buffer, MAX_MSG_LEN)) > 0 ) {
      client_msg.length = bytes_read;
      if (NetbiosSend(lsn, (char *)&client_msg, sizeof(PRINT_MSG)) )
         return CLI_SEND_FAILED;
      }

   client_msg.length = 0;    /* End-of-transfer marker */
   err = NetbiosSend(lsn, (char *)&client_msg, sizeof(PRINT_MSG));
   return err ? CLI_SEND_FAILED : CLI_OK;
}


int DisconnectFromServer(lsn,client_name)
SESSION lsn;
char *client_name;
{
   NetbiosHangup(lsn);
   NetbiosDeleteName(client_name);  /* must drop before exiting */
   return CLI_OK;
}