/*******************  NETBIOS.C --- Listing 3  ***********************
 * Author: Victor Volkman
 * Purpose: Low-level Netbios functions
 *
 * Compiler: Microsoft C 5.1, Turbo C 2.0
 *
 * Source code may be freely used if authorship is acknowledged.
 * Object code may be freely used.
 *********************************************************************/

#include <dos.h>
#include <stdio.h>
#include <string.h>
#include "netbios.h"

#if defined __TURBOC__
#define _dos_getvect getvect
#endif

#ifndef MAKEFD  /* fd = compiler generated function declaration file */
#include "netbios.fd"
#endif

extern int nb_debug;

int NetbiosCommand(use_block)
NCB *use_block;
{
   struct SREGS SegRegs;
   union REGS InRegs, OutRegs;
   NCB far *temp = (NCB far *) use_block;  /* fetch full 32-bit address */

   segread(&SegRegs);
   SegRegs.es = FP_SEG(temp);
   InRegs.x.bx = FP_OFF(temp);
   int86x(NETBIOS_INT, &InRegs, &OutRegs, &SegRegs);
   return use_block->ret_code;
}


int IsNetbiosLoaded()
{
   void (interrupt far *NetbiosVector)();

   NetbiosVector = _dos_getvect(NETBIOS_INT);
   /* printf("netbios vector %08lx\n",NetbiosVector); */
   return !(FP_SEG(NetbiosVector) == 0x0000 ||  /* no value  */
            FP_SEG(NetbiosVector) == 0xF000);   /* F0 = IRET */
}


int NetbiosAddName(new_name)
char *new_name;
{
   NCB add_name;

   if (nb_debug) printf("NetbiosAddName(%s)\n",new_name);
   memset(&add_name, 0, sizeof(NCB));
   add_name.command = NETBIOS_ADD_NAME;
   strcpy(add_name.name, new_name);
   return NetbiosCommand(&add_name);
}


int NetbiosDeleteName(old_name)
char *old_name;
{
   NCB delete_name;

   if (nb_debug) printf("NetbiosDeleteName(%s)\n",old_name);
   memset(&delete_name, 0, sizeof(NCB));
   delete_name.command = NETBIOS_DELETE_NAME;
   strcpy(delete_name.name, old_name);
   return NetbiosCommand(&delete_name);
}


int NetbiosHangup(lsn)
SESSION lsn;
{
   NCB hangup;

   if (nb_debug) printf("NetbiosHangup(%d)\n",lsn);
   memset(&hangup, 0, sizeof(NCB));
   hangup.command = NETBIOS_HANGUP;
   hangup.lsn = lsn;
   return NetbiosCommand(&hangup);
}


int NetbiosReset()
{
   NCB reset;

   if (nb_debug) printf("NetbiosReset()\n");
   memset(&reset, 0, sizeof(NCB));
   reset.command = NETBIOS_RESET;
   return NetbiosCommand(&reset);
}


int NetbiosSend(lsn,buffer,length)
SESSION lsn;
char *buffer;
unsigned int length;
{
   NCB send;

   if (nb_debug) printf("NetbiosSend(%d,buffer,%d)\n",lsn,length);
   memset(&send, 0, sizeof(NCB));
   send.command = NETBIOS_SEND;
   send.lsn = lsn;
   send.buffer = (char far *)buffer;
   send.length = length;
   return NetbiosCommand(&send);
}


int NetbiosReceive(lsn,buffer,length)
SESSION lsn;
char *buffer;
unsigned int length;
{
   NCB receive;

   if (nb_debug) printf("NetbiosReceive(%d,buffer,%d)\n",lsn,length);
   memset(&receive, 0, sizeof(NCB));
   receive.command = NETBIOS_RECEIVE;
   receive.lsn = lsn;
   receive.buffer = (char far *)buffer;
   receive.length = length;
   return NetbiosCommand(&receive);
}


int NetbiosCall(lsn_p, server_name, client_name, rto, sto)
SESSION *lsn_p;
char *server_name;
char *client_name;
unsigned char rto;   /* rto = Receive Time-Out */
unsigned char sto;   /* sto = Send Time-Out    */
{
   NCB call;
   int err;

   if (nb_debug)
      printf("NetbiosCall(lsn_p,%s,%s,%d,%d)\n",server_name,client_name,
              rto,sto);
   memset(&call, 0, sizeof(NCB));
   call.command = NETBIOS_CALL;
   strcpy(call.call_name, server_name);
   strcpy(call.name, client_name);
   call.rto = rto;
   call.sto = sto;
   err = NetbiosCommand(&call);
   *lsn_p = call.lsn;   /* save local session number */
   return err;
}



NCB listen;

int NetbiosListen(server_name, rto, sto)
char *server_name;
unsigned char rto;   /* rto = Receive Time-Out */
unsigned char sto;   /* sto = Send Time-Out    */
{
   if (nb_debug)
      printf("NetbiosListen(lsn_p,%s,%d,%d)\n",server_name,rto,sto);
   memset(&listen, 0, sizeof(NCB));
   listen.command = NETBIOS_LISTEN | NO_WAIT;
   strcpy(listen.call_name, "*");      /* Listen for "anybody" */
   strcpy(listen.name, server_name);
   listen.rto = rto;
   listen.sto = sto;
   return NetbiosCommand(&listen);
}