// FILELIST.HXX
#ifndef _FILELIST_HXX
#define _FILELIST_HXX

#include <string.h>
#include <stdio.h>
#include <dos.h>
#include "llist.hxx"

// This enumeration shows how to display directory_items.
// You can specify the values in enumerations.  These values 
// are chosen so they each occupy a separate bit position.  That
// way they can just be added together if you want to combine
// several format specifications:
enum display_format { sizes = 0x1, times = 0x2, dates = 0x4, 
                      attributes = 0x8, subdirs = 0x10 };
// (in release 2.0, enumerations can be local to classes.  This
// would have been convenient here).

class directory_item {
protected:  // so derived classes have access to this data
  char name[13];
  unsigned long size;
  unsigned time, date;
  char attribute;
public:
  directory_item(FIND * p) {
    strcpy(name, p->name);
    strlwr(name);  // change to lower case
    attribute = p->attribute;
    size = p->size;
    time = p->time;
    date = p->date;
  }
  // The expand() function is only used by subdir.  It is easier
  // to go through the list and tell each element to expand than
  // it is to check to see if each one is a subdir.  Subdir is
  // the only subclass which has a non-empty function body:
  virtual void expand() {}
  // The display() function can take any of the options ORed 
  // (or simply added) together:
  virtual void display(display_format);
  virtual unsigned long bytes() { return size; }
};

class file : public directory_item {
public:
  file(FIND * p) : (p) {}
  void display(display_format format);
};

class file_list; // name declaration (so it can be used in subdir)

class subdir : public directory_item {
  file_list * subdir_list;
  int expanded;  // whether this subdirectory has been expanded
  char pattern[13]; // contains * and ? for matching files
  char * path;  // path name
public:
  subdir(FIND * p, char * afn);
  ~subdir();
  // To find all files in a directory, you must call
  // findnext() until it returns null.  This means that
  // none of the subdirectories can be expanded until the
  // parent directory is complete, so expand() is not part
  // of the constructor.
  void expand();
  void display(display_format format);
  unsigned long bytes();
};

class file_list : public llist {
protected:
  void delete_data(void * dn) {
    delete (directory_item *)dn;
  }
public:
  file_list() : () {}  // not necessary; happens automatically
  // Notice how specifying the argument types and return values
  // (instead of using llist's void types) forces the compiler
  // to do strong type checking, but doesn't add any run-time overhead:
  void append(directory_item * el) { llist::append(el); }
  void insert(directory_item * el) { llist::insert(el); }
  directory_item * value() { return (directory_item *)llist::value(); }
  // constructor to create a list of files from an ambiguous
  // file name (afn):
  file_list(char * afn);
  void expand_list();  // expand all subdirectories
  // calculate disk space used by all files:
  unsigned long disk_space(char * msg = "");
  void display_all(display_format format);
};

#endif // _FILELIST_HXX
