// DU.CXX
#include "filelist.hxx"
// Notice the same framework is used here as with ldir.cxx

char * errmsg =
"du in C++ by Bruce Eckel.  Calculates space occupied by directory(s)\n"
"Usage: du [filespec] [flags]\n"
"optional filespec must be second argument, but flags can be\n"
"in any order.  Available options are:\n"
"   -r    calculates subdirectory sizes\n";

main(int argc, char ** argv) {
  display_format format = 0;
  char * arg = "*.*";  // file spec defaults to all files

  if (argc > 1 && argv[1][0] != '-')
    arg = argv[1];
  // Process the command-line switches
  for(int a = argc -1;  a > 0; a--) {
    if(argv[a][0] == '-') {
      switch ( argv[a][1] ) {
        case 'r' : case 'R' : format |= subdirs; break;
        default :
            fprintf(stderr, "unknown switch: %s\n", argv[a]);
            fprintf(stderr, "%s\n", errmsg);
            exit(1);
      }
    }
  }
  file_list files(arg);
  if(format & subdirs) files.expand_list();
  printf("total used in this subdirectory = %lu\n", files.disk_space());
}
  
