; ************************************************************
;
; getsp.asm - returns current value of SP in AX.  Note that
;             this value is *not* adjusted for the bytes that
;             were pushed onto the stack by the call to getsp.
;             This introduces such a small error that it's
;             not worth the extra code.
;
; Author: John Rex
; Assembler: MASM
; Memory models: any may be used.  Tell the assembler which is
;    needed by defining mem_s, mem_c, mem_m, mem_l, or mem_h
;
; Usage: unsigned getsp();
;
; ************************************************************

tell1 MACRO message
if1
%out message
endif
endm

ifdef mem_s     ;small model?
  mem_Small equ 1
  .model small
  tell1 <Assembling Small Model>
else
  mem_Small equ 0
endif

ifdef mem_c     ;compact model?
  mem_Compact equ 1
  .model compact
  tell1 <Assembling Compact Model>
else
  mem_Compact equ 0
endif

ifdef mem_m     ;medium model?
  mem_Medium equ 1
  .model medium
  tell1 <Assembling Medium Model>
else
  mem_Medium equ 0
endif

ifdef mem_h     ;Huge model?
  mem_l equ 1   ;looks like large model
endif

ifdef mem_l     ;Large model?
  mem_Large equ 1
  .model large
  ifndef mem_h
    tell1 <Assembling Large Model>
  else
    tell1 <Assembling Large/Huge Model>
  endif
else
  mem_Large equ 0
endif

; now check model
mem_Model = mem_Small + mem_Compact + mem_Medium + mem_Large

if mem_Model ne 1
  .err                  ; no good!
  tell1 <Must define one of mem_s, mem_c, mem_m, or mem_l to pick a memory model>
endif

; After all of the above, the code is rather anti-climactic

        .code

        public  _getsp

_getsp  proc
        mov     ax,sp
	ret
_getsp  endp

        end




