// LLIST.CXX : Generic Linked-List Container class

#include "llist.hxx"

llist::llist() {
  // make an empty tail element:
  previous = cursor = head = tail = new llist_el;
}

void llist::append(void * el) {
  tail->next = new llist_el;  // make a new empty tail element
  tail->data = el;  // put data in the current element
  tail = tail->next; // move the tail forward to the empty element
}

void llist::insert(void * el) {
  llist_el * new_element = new llist_el;  // make a new one
  new_element->data = el;  // store the data in the new element
  if ( head == cursor)  // at beginning of list
    head = previous = new_element;
  else {
    previous->next = new_element;
    previous = new_element;  // bump forward one
  }
  new_element->next = cursor;
}

void llist::push_to_end() {
  tail->next = new llist_el;  // make a new empty tail element
  tail->data = cursor->data;  // current cursor data to old tail
  tail = tail->next; // move tail pointer forward to new tail
  previous->next = cursor->next; // unlink current element
  delete cursor;  // free the storage (no destructor called)
  cursor = previous->next; // reposition the cursor
}

int llist::remove() {
  // If you are at the tail (includes empty list):
  if ( cursor == tail ) return 1;  // can't delete tail
  delete_data(cursor->data);  // virtual function deletes properly
  if ( cursor == head ) {
    head = previous = cursor->next;  // move to the next element
    delete cursor;
    cursor = head;
    return 0;
  }
  previous->next = cursor->next;  // bypass the current element
  delete cursor;
  cursor = previous->next;
  return 0;
}

void llist::reset() {
  previous = cursor = head;
}

int llist::next() {
  if ( cursor == tail ) return 0;  // end of list
  // if you just reset the cursor, don't move "previous"
  if ( previous != cursor )
    previous = previous->next;  
  cursor = cursor->next;
  return 1;
}

int llist::end() {
  if (cursor == tail) return 1;
  else return 0;
}

void * llist::value() {
  if ( cursor == tail ) return 0; // (if head == tail, this is true, too)
  return cursor->data;
}

llist::~llist() {
  reset();
  while(!end())
    remove();
  delete tail;  // no data in tail
}
