/**************************** DOS4.H **********************************\
|*                                                                    *|
|* Structures for use with DOS4.C. & MEMORY.C                         *|
|*                                                                    *|
|* (c) Copyright 1989, David Craig. All rights reserved.              *|
|* Permission is granted to incorporate these functions into a larger *|
|* work and to distribute the resulting executable file.              *|
|*                                                                    *|
|* OK for Microsoft 5.1, Turbo 2.0; All memory models supported.      *|
|*                                                                    *|
\**********************************************************************/

typedef unsigned char   byte;
typedef unsigned int    word;
typedef unsigned long   dword;

/****************************************************************
 * structures and defines needed to use 6Ch, extended read/write
 ****************************************************************/

#define FILE_OPENED     1           /* Function 6Ch - CX register */
#define FILE_CREATED    2           /* Returned by DOS */
#define FILE_REPLACED   3

struct  open_mode                   /* Function 6Ch - BX register */
{                                   /* Passed to DOS */
    word    res1        : 1;
    word    commint     : 1;
    word    int24h      : 1;
    word    res2        : 5;
    word    inheritance : 1;
    word    sharing     : 3;
    word    res3        : 1;
    word    access      : 3;
};

struct  flag_word                   /* Function 6Ch - DX register */
{                                   /* Passed to DOS */
    word    res1        : 7;
    word    not_exists  : 5;
    word    exists      : 4;
};

/***********************************************
 * Boot sector contents
 ***********************************************/
struct boot
{
    byte    jump[3];
    byte    oem_name[8];
    word    bytes_per_sector;       /* BPB begins here */
    byte    sectors_per_au;
    word    reserved_sectors;
    byte    number_of_fats;
    word    number_of_entries;
    word    number_of_sectors;
    byte    media_descriptor;
    word    fat_size;
    word    sectors_per_track;
    word    number_of_heads;
    dword   hidden_sectors;
    dword   big_number_of_sectors;
    byte    physical_drive_number;      /* DOS 4.00 */
    byte    bpb_reserved;
    byte    extended_boot_record_sig;   /* 0x29 */
    dword   volume_serial_number;
    byte    volume_label[11];
    byte    bpb_fat_id[8];
};


/***********************************************
 * DOS 4.x Disk Table
 ***********************************************/
struct disk_table
{
    byte    designator;
    byte    unit_number;
    word    sector_size;
    byte    cluster_size;
    byte    shift_value;
    word    fat_start;
    byte    fat_copies;
    word    max_entries;
    word    first_sector;
    word    last_cluster;
    word    fat_size;               /* Was a byte pre DOS 4.0 */
    word    dir_start;
    byte    far *ddh;
    byte    media_type;
    byte    drive_used;             /* if zero, drive has been used */
    struct  disk_table far *nxt;
};

/***********************************************
 * Packet used to pass large sector numbers
 ***********************************************/
struct packet
{
    dword   starting_sector;
    word    nbr_sectors;
    void    far *buffer;
};


/***********************************************
 * Memory Control Block (MCB)
 ***********************************************/
struct  mcb
{
    byte    control;                    /* 'M' or 'Z' = last */
    word    owner;                      /* PSP of owner or 0008h - IBMBIO */
    word    size;                       /* Size in paragraphs */
    byte    unk1;
    byte    unk2;
    byte    unk3;
    byte    name[8];                    /* DOS 4.00 */
};


/***********************************************
 * System info tables accessed thru 52h
 ***********************************************/

struct  device_hdr
{
    struct  device_hdr far *next_dev;   /* Pointer to next in chain */
    word    attribute;                  /* Attribute Field */
    word    strategy;                   /* Offset of strategy routine */
    word    intrupt;                    /* Offset of interrupt routine */
    byte    name_unit[8];               /* Character Device - Name */
                                        /* Block Device - Number of Units */
    byte    joined_drive_count;         /* Only in NUL device header */
};

struct  func_52h
{
    struct  disk_table far *disk_table; /* Pointer to first disk table */
    byte    far *sft_ptr;               /* System File Table - handle */
    struct  device_hdr far *clock_ptr;  /* Pointer to CLOCK$ device */
    struct  device_hdr far *con_ptr;    /* Pointer to CON device */
    word    max_sec;                    /* Maximum sector size supported */
    byte    far *cache;                 /* First Cache Control Block pointer */
    byte    far *drive_inf;             /* Current Directory Structure */
    byte    far *fcb_ptr;               /* System File Table - FCBs */
    word    size_fcb_table;             /* Size of FCB SFT Table */
    byte    drive_count;
    byte    last_drive;
    struct  device_hdr nul_dev;
};

