/*************************** DIFDATA.H ****************************
*   Data #defines for DIF side of dif.c
*   (c) Copyright Victor Volkman, 1989. See dif.c for terms
******************************************************************/

#define DIF_STR_LEN  81      /* Max size of a DIF string field         */
#define NUM_STRS     16      /* Number of labels & comments per vector */
#define CR           0x0D    /* ASCII Carriage Return                  */

#define DIF_TYPE_SPECIAL (-1)
#define DIF_TYPE_NUMERIC   0
#define DIF_TYPE_STRING    1

enum dif_hdr_vals {
   DIF_TABLE, DIF_VECTORS, DIF_TUPLES, DIF_DATA,
   DIF_LABEL, DIF_COMMENT, DIF_SIZE, DIF_PERIODICITY, DIF_MAJORSTART,
   DIF_MINORSTART, DIF_TRUELENGTH, DIF_UNITS, DIF_DISPLAYUNITS
   };

#define NUM_HDR_VALS (((int) DIF_DISPLAYUNITS))

enum dif_val_vals {
   DIF_VAL_V, DIF_VAL_NA, DIF_VAL_ERROR, DIF_VAL_TRUE,
   DIF_VAL_FALSE, DIF_VAL_BOT, DIF_VAL_EOD
   };

#define NUM_VAL_VALS (((int) DIF_VAL_EOD))

/* DIF cell in the input file appears as:
   vector or type, float_val
   str_val
*/

typedef struct {
   int vector;          /* Vector if header cell, type indicator elsewhere */
   double float_val;    /* numeric data in float format                    */
   int dec_cnt;         /* number of digits following the decimal point    */
   int numer_len;       /* number of digits, incl. dec. point and sign     */
   char str_val[DIF_STR_LEN];  /* string value from cell, quotes removed   */
   } dif_elt, *dif_elt_p;

typedef struct {
   char **labels;              /* See text of the article for an   */
   int num_labels;             /* explanation of these vector      */
   char **comments;            /* topics.                          */
   int num_comments;
   int size;
   int period;
   int majorstart;
   int minorstart;
   int truelength;
   char units[DIF_STR_LEN];
   char displayunits[DIF_STR_LEN];
   } vector_desc, *vector_desc_p;

typedef struct {
   char title[DIF_STR_LEN];    /* Usually same as the filename     */
   int num_vectors;            /* Same as fields in a database     */
   int num_tuples;             /* Same as records in a database    */
   vector_desc_p vec;          /* Describes each vector in a tuple */
   } dif_hdr, *dif_hdr_p;
