/*************************** DB3DATA.H ************************
*   Data #defines for dBase III side of dif.c 
*   (c) Copyright Victor Volkman, 1989. See dif.c for terms
**************************************************************/

#define DB3_CHAR    'C'
#define DB3_NUMERIC 'N'
#define DB3_LOGICAL 'L'
#define DB3_MEMO    'M'
#define DB3_DATE    'D'
#define DB3_NONE    '\0'

#define DB3_DATE_SIZE    8
#define DB3_LOGICAL_SIZE 1
#define DB3_DEFAULT_SIZE 1 /* field size for empty vectors, customize for */
                           /* your application                            */
#define DB3_HDR_SIZE 32    /* Header portion preceding the field descriptors */
#define DB3_HDR_ACTUAL_SIZE 22  /* Only 22 bytes formally defined */
#define DB2_HDR_SIZE 520
#define DB3_NAME_LEN 11    /* field name length */
#define DB3_FILE_TYPE 0x03
#define DB2_FILE_TYPE 0x02

#define UPD_YY 0       /* Date format for last_upd field */
#define UPD_MM 1
#define UPD_DD 2


typedef struct {   /* One of these structures per database field */
   char fld_name[DB3_NAME_LEN];  /* Letters & digits, no spaces    */
   char fld_type;                /* DB3_CHAR, DB3_NUMERIC, ...     */
   long fld_data_addr;           /* Scratchpad field address       */
   char fld_size;                /* field size in bytes            */
   char fld_dec_cnt;             /* Number of places after decimal */
   char reserved[4];
   } db3_hdr_elt, *db3_hdr_elt_p;

typedef struct {   /* One of these structures per database file */
   char ver_no;           /* dBase III id                          */
   char last_upd[3];      /* Date of last update YY/MM/DD          */
   long num_recs;         /* Number of records == number of tuples */
   int size_hd;           /* Total header size                     */
   int size_rec;          /* Size of a database record             */
   char reserved[20];
   db3_hdr_elt_p fld;     /* this field not actually in db3 header */
   char *data;            /* this field not actually in db3 header */
   } db3_hdr, *db3_hdr_p;
