; TOPLINE.ASM for E32 - Copyright (C) 1994 Douglas Herr
;  all rights reserved

; prints file information on top line of screen:
;
;  filename
;  cursor row
;  cursor column

include	model.inc

public	topline, showpos, saved_pos
extrn	i4tostr:near
extrn	tputchr:near
extrn	tprintce:near
extrn	tprint:near
extrn	dwordtohex:near

include	dataseg.inc
extrn	no_file_name:byte
extrn	filesiz:dword		; bytes in buffer (NOT buffer size)
extrn	filename:dword		; ptr to filename
extrn	file_row:dword
extrn	inverse:byte
extrn	cur_posn:word
extrn	left_margin:word
extrn	columns:byte
extrn	dirty_bits:byte
extrn	first_row:byte
extrn	cursor:dword
extrn	display_mode:byte

saved_pos	dd 0FFFFh
pos_proc	dd _ascii
		dd _hex
@curseg	ends

include	codeseg.inc
topline	proc	near
	test	dirty_bits,00100000b	; name change?
	jz	short showpos

	mov	esi,filename
	cmp	byte ptr [esi],0
	jne	short got_file_name
	lea	esi,no_file_name

got_file_name:
	mov	ah,inverse
	xor	dx,dx
	mov	dh,first_row
	dec	dh
	mov	al,' '
	call	tputchr
	inc	dl
	call	tprintce
	mov	saved_pos,0FFFFFFFFh
	and	dirty_bits,11011111b
topline	endp

number_buffer	equ	[ebp-12]

showpos	proc	near
	enter	12,0
	lea	esi,number_buffer
	mov	eax,cursor
	mov	dh,first_row
	mov	dl,columns
	dec	dh

	movzx	ecx,display_mode
	jmp	pos_proc[ecx]

_hex:
; EAX = cursor
	call	dwordtohex
	sub	dl,9
	mov	ah,inverse
	call	tprint
	leave
	ret

_ascii:
	cmp	eax,saved_pos
	mov	saved_pos,eax
	je	short exit
	movzx	eax,byte ptr cur_posn	; EAX = cursor column
	lea	esi,number_buffer
	add	ax,left_margin		; adjust for screen shift
	adc	eax,1			; show column '0' as '1'
	call	i4tostr
	add	esi,6
	sub	dl,5
	mov	ah,inverse
	call	tprint
	sub	dl,2
	mov	al,'C'			; 'Column' label
	call	tputchr
	sub	dl,6
	mov	eax,file_row
	lea	esi,number_buffer
	call	i4tostr
	add	esi,6
	mov	ah,inverse
	call	tprint
	sub	dl,2
	mov	al,'R'			; 'Row' label
	call	tputchr
exit:
	leave
	ret
showpos	endp

@curseg	ends
	end
