diff -ur -x qcc -x *.exe -x *.list -x *.pl -x *.h qc-ori/ai.qc qc/ai.qc
--- qc-ori/ai.qc	Thu Sep 26 11:15:38 1996
+++ qc/ai.qc	Fri Oct  4 00:00:00 1996
@@ -578,25 +578,25 @@
 
 //=============================================================================
 
-float()	WizardCheckAttack;
-float()	DogCheckAttack;
+//#jp#(Omit) float()	WizardCheckAttack;
+//#jp#(Omit) float()	DogCheckAttack;
 
 float() CheckAnyAttack =
 {
 	if (!enemy_vis)
 		return;
-	if (self.classname == "monster_army")
-		return SoldierCheckAttack ();
-	if (self.classname == "monster_ogre")
-		return OgreCheckAttack ();
-	if (self.classname == "monster_shambler")
-		return ShamCheckAttack ();
-	if (self.classname == "monster_demon1")
-		return DemonCheckAttack ();
-	if (self.classname == "monster_dog")
-		return DogCheckAttack ();
-	if (self.classname == "monster_wizard")
-		return WizardCheckAttack ();
+//#jp#(Omit)	if (self.classname == "monster_army")
+//#jp#(Omit)		return SoldierCheckAttack ();
+//#jp#(Omit)	if (self.classname == "monster_ogre")
+//#jp#(Omit)		return OgreCheckAttack ();
+//#jp#(Omit)	if (self.classname == "monster_shambler")
+//#jp#(Omit)		return ShamCheckAttack ();
+//#jp#(Omit)	if (self.classname == "monster_demon1")
+//#jp#(Omit)		return DemonCheckAttack ();
+//#jp#(Omit)	if (self.classname == "monster_dog")
+//#jp#(Omit)		return DogCheckAttack ();
+//#jp#(Omit)	if (self.classname == "monster_wizard")
+//#jp#(Omit)		return WizardCheckAttack ();
 	return CheckAttack ();
 };
 
diff -ur -x qcc -x *.exe -x *.list -x *.pl -x *.h qc-ori/buttons.qc qc/buttons.qc
--- qc-ori/buttons.qc	Thu Sep 26 11:15:38 1996
+++ qc/buttons.qc	Fri Oct  4 00:00:00 1996
@@ -55,6 +55,7 @@
 {
 	if (other.classname != "player")
 		return;
+	if (other.player_status & PLAYER_IS_OBSERVER) return; //#jp#(Observer)
 	self.enemy = other;
 	button_fire ();
 };
diff -ur -x qcc -x *.exe -x *.list -x *.pl -x *.h qc-ori/client.qc qc/client.qc
--- qc-ori/client.qc	Sun Sep 29 23:29:00 1996
+++ qc/client.qc	Fri Oct  4 00:00:00 1996
@@ -59,6 +59,7 @@
 	parm7 = self.ammo_cells;
 	parm8 = self.weapon;
 	parm9 = self.armortype * 100;
+        parm16 = self.player_status; //#jp#(PlayerStatus)
 };
 
 void() SetNewParms =
@@ -72,15 +73,20 @@
 	parm7 = 0;
 	parm8 = 1;
 	parm9 = 0;
+	parm16 = 0; //#jp#(PlayerStatus)
 };
 
 void() DecodeLevelParms =
 {
+  self.player_status = parm16;			//#jp#(PlayerStatus)
+  SkinRestoreSkinFromStatusFlag(self);		//#jp#(Skin)
+  if (!USE_MODULE_OBSERVER) {			//#jp#(Observer)
 	if (serverflags)
 	{
 		if (world.model == "maps/start.bsp")
 			SetNewParms ();		// take away all stuff on starting new episode
 	}
+  }						//#jp#(Observer)
 	
 	self.items = parm1;
 	self.health = parm2;
@@ -149,6 +155,7 @@
 // skip any text in deathmatch
 	if (deathmatch)
 	{
+		LevelSelectSelectLevel(); //#jp#(LevelSelect)
 		GotoNextMap ();
 		return;
 	}
@@ -294,6 +301,11 @@
 	if (other.classname != "player")
 		return;
 
+  if (ExitRulesExitingIsNotAllowed(other)) {	//#jp#(ExitRules)
+    T_Damage (other, world, other, 50000);	//#jp#(ExitRules)
+    return;					//#jp#(ExitRules)
+  }						//#jp#(ExitRules)
+
 	if ((cvar("noexit") == 1) || ((cvar("noexit") == 2) && (mapname != "start")))
 	{
 		T_Damage (other, self, self, 50000);
@@ -353,7 +365,9 @@
 	if (coop)
 	{
 		// make a copy of the dead body for appearances sake
+   if (!(self.player_status & PLAYER_IS_OBSERVER)) {//#jp#(Observer)
 		CopyToBodyQue (self);
+   }//#jp#(Observer)
 		// get the spawn parms as they were at level start
 		setspawnparms (self);
 		// respawn		
@@ -362,15 +376,24 @@
 	else if (deathmatch)
 	{
 		// make a copy of the dead body for appearances sake
+   if (!(self.player_status & PLAYER_IS_OBSERVER)) {//#jp#(Observer)
 		CopyToBodyQue (self);
+   }//#jp#(Observer)
 		// set default spawn parms
 		SetNewParms ();
+		parm16 = self.player_status; //#jp#(PlayerStatus)
 		// respawn		
 		PutClientInServer ();
 	}
 	else
 	{	// restart the entire server
+   if (!(self.player_status & PLAYER_IS_OBSERVER)) {//#jp#(Observer)
 		localcmd ("restart\n");
+   } else {				//#jp#(Observer)
+      SetNewParms();			//#jp#(Observer)
+      parm16 = self.player_status;	//#jp#(Observer)//#jp#(PlayerStatus)
+      PutClientInServer ();		//#jp#(Observer)
+   }					//#jp#(Observer)
 	}
 };
 
@@ -389,6 +412,12 @@
 	set_suicide_frame ();
 	self.modelindex = modelindex_player;
 	self.frags = self.frags - 2;	// extra penalty
+        RankCountEvent(self,RANK_SUICIDE);		//#jp#(Rank)
+	ServerConsoleClientSuicide(self);               //#jp#(ServerConsole)
+        if (KickSuicider(self)) return;			//#jp#(KickSuicider)
+        if (self.player_status & PLAYER_IS_OBSERVER) {	//#jp#(Observer)
+           self.observer_status = OBSERVER_BECOME_OBSERVER;//#jp#(Observer)
+        }						//#jp#(Observer)
 	respawn ();
 };
 
@@ -498,6 +527,14 @@
 	self.invincible_finished = 0;
 	self.effects = 0;
 	self.invincible_time = 0;
+        self.burn_burning = 0;		//#jp#(Burn)
+        self.modules_weapon = 0;	//#jp#(Modules)
+        self.modules_killweapon = 0;	//#jp#(Modules)
+        self.drone_1 = world;		//#jp#(Drone)
+        self.drone_2 = world;		//#jp#(Drone)
+        self.drone_4 = world;		//#jp#(Drone)
+        self.drone_8 = world;		//#jp#(Drone)
+        self.drone_count = 0;		//#jp#(Drone)
 
 	DecodeLevelParms ();
 	
@@ -524,6 +561,32 @@
 	setmodel (self, "progs/player.mdl");
 	modelindex_player = self.modelindex;
 
+if (!self.kick_suicider_lasttime)				//#jp#(KickSuicider)
+  self.kick_suicider_lasttime = time - 100000;			//#jp#(KickSuicider)
+if (!self.player_status) {					//#jp#(PlayerStatus)
+  PlayerStatusSetFlag(self,PLAYER_IS_CLIENT);			//#jp#(PlayerStatus)
+  if (USE_MODULE_OBSERVER) {					//#jp#(Observer)
+    self.observer_status = OBSERVER_BECOME_OBSERVER;		//#jp#(Observer)
+  }								//#jp#(Observer)
+}								//#jp#(PlayerStatus)
+if (self.player_status & PLAYER_IS_OBSERVER) {			//#jp#(Observer)
+  // happens after level change					//#jp#(Observer)
+  if (!(self.items & IT_AXE)) {					//#jp#(Observer)
+    // stay observer after level change				//#jp#(Observer)
+    self.observer_status = OBSERVER_BECOME_OBSERVER;		//#jp#(Observer)
+  }								//#jp#(Observer)
+}								//#jp#(Observer)
+if (!(self.observer_status & OBSERVER_BECOME_OBSERVER)) {	//#jp#(Observer)
+  self.protect_finished = time + 6;				//#jp#(Protect)
+  self.effects = self.effects | EF_BRIGHTFIELD;			//#jp#(Protect)
+}								//#jp#(Observer)
+if (self.observer_status & OBSERVER_BECOME_OBSERVER) {		//#jp#(Observer)
+   //becoming observer						//#jp#(Observer)
+   ObserverBecomeObserver(self);				//#jp#(Observer)
+   PlayerStatusSetFlag(self,PLAYER_IS_OBSERVER);		//#jp#(Observer)
+   return;							//#jp#(Observer)
+}								//#jp#(Observer)
+
 	setsize (self, VEC_HULL_MIN, VEC_HULL_MAX);
 	
 	self.view_ofs = '0 0 22';
@@ -713,6 +776,8 @@
 		return;
 	}
 
+   if (ObserverDeathThink()) return;	//#jp#(Observer)
+
 // wait for any button down
 	if (!self.button2 && !self.button1 && !self.button0)
 		return;
@@ -788,10 +853,12 @@
 
 	if (self.waterlevel != 3)
 	{
+if (!(self.player_status & PLAYER_IS_OBSERVER)) {//#jp#(Observer)
 		if (self.air_finished < time)
 			sound (self, CHAN_VOICE, "player/gasp2.wav", 1, ATTN_NORM);
 		else if (self.air_finished < time + 9)
 			sound (self, CHAN_VOICE, "player/gasp1.wav", 1, ATTN_NORM);
+}//#jp#(Observer)
 		self.air_finished = time + 12;
 		self.dmg = 2;
 	}
@@ -924,6 +991,53 @@
 		return;
 	}
 	
+        if (time > vote_checktime) {					//#jp#(Vote)
+           VoteThink();							//#jp#(Vote)
+        }								//#jp#(Vote)
+        if (!(self.player_status & PLAYER_PASSED_INIT_PHASE)) {		//#jp#(PlayerStatus)
+           if (!(self.player_status & PLAYER_IS_INITIALIZED)) {		//#jp#(PlayerStatus)
+              ModulesInitModules(self);					//#jp#(Modules)
+              if (USE_MODULE_OBSERVER) {				//#jp#(Observer)
+                 sound (self, CHAN_BODY, "wizard/wsight.wav", 1, ATTN_NONE);//#jp#(Observer)
+              }								//#jp#(Observer)
+              self.player_status_init_time = time;			//#jp#(PlayerStatus)
+              PlayerStatusSetFlag(self,PLAYER_IS_INITIALIZED);		//#jp#(PlayerStatus)
+           }								//#jp#(PlayerStatus)
+           if (!(self.player_status & PLAYER_DID_INIT_CALLS)) {		//#jp#(Init)
+              if (time > self.player_status_init_time + 1) {		//#jp#(Init)
+                 InitLetClientExecInit(self);				//#jp#(Init)
+                 PlayerStatusSetFlag(self,PLAYER_DID_INIT_CALLS);	//#jp#(Init)
+              }								//#jp#(Init)
+           }								//#jp#(Init)
+           if (!(self.player_status & PLAYER_PASSED_MOTD)) {		//#jp#(Motd)
+              MotdThink();						//#jp#(Motd)
+           }								//#jp#(Motd)
+           if (time > self.player_status_init_time + 10) {		//#jp#(PlayerStatus)
+              PlayerStatusSetFlag(self,PLAYER_PASSED_INIT_PHASE);	//#jp#(PlayerStatus)
+           }								//#jp#(PlayerStatus)
+        }								//#jp#(PlayerStatus)
+        if (self.modules_level_inited != 2) {				//#jp#(Modules)
+           if (!self.modules_level_inited) {				//#jp#(Modules)
+              if (USE_MODULE_OBSERVER) {				//#jp#(Observer)
+                 bprint (self.netname);					//#jp#(Observer)
+                 bprint (" entered the game\n");			//#jp#(Observer)
+              }								//#jp#(Observer)
+              if (!exitrules_inited) { ExitRulesSetValues(); }		//#jp#(ExitRules)
+              self.modules_level_entertime = time;			//#jp#(Modules)
+              self.modules_level_inited = 1;				//#jp#(Modules)
+           }								//#jp#(Observer)
+           if (time - self.modules_level_entertime > 2) {		//#jp#(Modules)
+              if (self.player_status & PLAYER_PASSED_INIT_PHASE) {	//#jp#(PlayerStatus)
+                 ModulesShowLevelInfo(self);				//#jp#(Modules)
+                 self.modules_level_inited = 2;				//#jp#(Modules)
+              }								//#jp#(PlayerStatus)
+           }								//#jp#(Modules)
+        }								//#jp#(Modules)
+        if (self.player_status & PLAYER_IS_OBSERVER) {			//#jp#(Observer)
+           ObserverThink();						//#jp#(Observer)
+           return;							//#jp#(Observer)
+        }								//#jp#(Observer)
+
 	if (self.deadflag == DEAD_DYING)
 		return;	// dying, so do nothing
 
@@ -942,6 +1056,7 @@
 	{
 		self.weapon = W_BestWeapon ();
 		W_SetCurrentAmmo ();
+		if (self.weapon==IT_NAILGUN) WeldToggleWeapon(self); //#jp#(Weld)
 	}
 };
 	
@@ -1098,6 +1213,12 @@
 		}
 	}	
 
+  if (self.protect_finished) {				//#jp#(Protect)
+    if (self.protect_finished < time) {			//#jp#(Protect)
+      self.protect_finished = 0;			//#jp#(Protect)
+      self.effects = self.effects - (self.effects & EF_BRIGHTFIELD);//#jp#(Protect)
+    }							//#jp#(Protect)
+  }							//#jp#(Protect)
 };
 
 
@@ -1155,9 +1276,12 @@
 */
 void() ClientConnect =
 {
+if (!USE_MODULE_OBSERVER) {//#jp#(Observer)
 	bprint (self.netname);
 	bprint (" entered the game\n");
+}//#jp#(Observer)
 	
+        ServerConsolePlayerEntered(self); //#jp#(ServerConsole)
 // a client connecting during an intermission can cause problems
 	if (intermission_running)
 		ExitIntermission ();
@@ -1185,6 +1309,7 @@
 	bprint (" frags\n");
 	sound (self, CHAN_BODY, "player/tornoff2.wav", 1, ATTN_NONE);
 	set_suicide_frame ();
+	PlayerStatusSetFlag(self,PLAYER_DISCONNECTED); //#jp#(PlayerStatus)
 };
 
 /*
@@ -1200,6 +1325,9 @@
 	local	string deathstring, deathstring2;
 	rnum = random();
 
+	RankClientObituary(targ,attacker); //#jp#(Rank)
+	ServerConsoleClientObituary(targ,attacker); //#jp#(ServerConsole)
+
 	if (targ.classname == "player")
 	{
 		if (attacker.classname == "teledeath")
@@ -1229,13 +1357,36 @@
 			{
 				// killed self
 				attacker.frags = attacker.frags - 1;
+if (targ.exitrules_death) {		//#jp#(ExitRules)
+   if (USE_MODULE_EXITRULES) {		//#jp#(ExitRules)
+      ExitRulesClientObituary(targ);	//#jp#(ExitRules)
+      return;				//#jp#(ExitRules)
+   }					//#jp#(ExitRules)
+}					//#jp#(ExitRules)
 				bprint (targ.netname);
 				
+if (targ.modules_killweapon == MODULES_WEAPON_SHRAPNEL) {//#jp#(Shrapnel)
+   bprint (" didn't read the manual\n");		//#jp#(Shrapnel)
+}							//#jp#(Shrapnel)
+else							//#jp#(Shrapnel)
+if (targ.modules_killweapon == MODULES_WEAPON_BURN) {	//#jp#(Burn)
+   bprint (" plays with the fire\n");			//#jp#(Burn)
+}							//#jp#(Burn)
+else							//#jp#(Burn)
+if (targ.modules_killweapon == MODULES_WEAPON_WELD) {	//#jp#(Weld)
+   bprint (" couldn't wait to pull the trigger\n");	//#jp#(Weld)
+}							//#jp#(Weld)
+else							//#jp#(Weld)
+if (targ.modules_killweapon == MODULES_WEAPON_DRONE) {	//#jp#(Drone)
+   bprint (" gathers gooseberries\n");			//#jp#(Drone)
+}							//#jp#(Drone)
+else							//#jp#(Drone)
 				if (targ.weapon == 64 && targ.waterlevel > 1)
 				{
 					bprint (" discharges into the water.\n");
 					return;
 				}
+else							//#jp#(Modules)
 				if (targ.weapon == IT_GRENADE_LAUNCHER)
 					bprint (" tries to put the pin back in\n");
 				else
@@ -1262,6 +1413,35 @@
 				attacker.frags = attacker.frags + 1;
 
 				rnum = attacker.weapon;
+if (attacker.frags> exitrules_maxfrags) exitrules_maxfrags = attacker.frags; //#jp#(ExitRules);
+if (targ.modules_killweapon == MODULES_WEAPON_SHRAPNEL) {//#jp#(Shrapnel)
+   deathstring = " was flamed by ";			//#jp#(Shrapnel)
+   deathstring2 = "\n";					//#jp#(Shrapnel)
+   rnum = 0;						//#jp#(Shrapnel)
+}							//#jp#(Shrapnel)
+else							//#jp#(Shrapnel)
+if (targ.modules_killweapon == MODULES_WEAPON_BURN) {	//#jp#(Burn)
+   deathstring = " was cremated by ";			//#jp#(Burn)
+   deathstring2 = "\n";					//#jp#(Burn)
+   rnum = 0;						//#jp#(Burn)
+}							//#jp#(Burn)
+else							//#jp#(Burn)
+if (targ.modules_killweapon == MODULES_WEAPON_WELD) {	//#jp#(Weld)
+   deathstring = " was torched by ";			//#jp#(Weld)
+   deathstring2 = "\n";					//#jp#(Weld)
+   rnum = 0;						//#jp#(Weld)
+}							//#jp#(Weld)
+else							//#jp#(Weld)
+if (targ.modules_killweapon == MODULES_WEAPON_DRONE) {	//#jp#(Drone)
+   deathstring = " plays with ";			//#jp#(Drone)
+   deathstring2 = "'s balls\n";				//#jp#(Drone)
+   if (targ.health < -40) {				//#jp#(Drone)
+      deathstring = " erupted while rubbing ";		//#jp#(Drone)
+      deathstring2 = "'s pickly toy\n";			//#jp#(Drone)
+   }							//#jp#(Drone)
+   rnum = 0;						//#jp#(Drone)
+}							//#jp#(Drone)
+
 				if (rnum == IT_AXE)
 				{
 					deathstring = " was ax-murdered by ";
diff -ur -x qcc -x *.exe -x *.list -x *.pl -x *.h qc-ori/combat.qc qc/combat.qc
--- qc-ori/combat.qc	Thu Sep 26 11:15:38 1996
+++ qc/combat.qc	Fri Oct  4 00:00:00 1996
@@ -57,6 +57,11 @@
 {
 	local entity oself;
 
+   if (targ.classname == "drone") {	//#jp#(Drone)
+	targ.think = DroneDie;		//#jp#(Drone)
+	targ.nextthink = time;	//#jp#(Drone)
+        return;				//#jp#(Drone)
+   }					//#jp#(Drone)
 	oself = self;
 	self = targ;
 	
@@ -164,11 +169,42 @@
 	if ( (teamplay == 1) && (targ.team > 0)&&(targ.team == attacker.team) )
 		return;
 		
+	if (targ.classname == "drone") {		//#jp#(Drone)
+	  if (inflictor.classname == "player") {	//#jp#(Drone)
+	    if (attacker.classname == "player") {	//#jp#(Drone)
+	      // drone attacked by shotgun		//#jp#(Drone)
+	      take = 100;				//#jp#(Drone)
+	    }						//#jp#(Drone)
+	  }						//#jp#(Drone)
+	}						//#jp#(Drone)
+
+  if (targ.protect_finished >=time) {			//#jp#(Protect)
+    if (take < 1000) {					//#jp#(Protect)
+      if (time > targ.protect_sound_time + 2) {		//#jp#(Protect)
+	sound (targ, CHAN_ITEM,protect_sound, 1, ATTN_NORM);//#jp#(Protect)
+	targ.protect_sound_time = time;			//#jp#(Protect)
+      }							//#jp#(Protect)
+      return;						//#jp#(Protect)
+    }							//#jp#(Protect)
+  }							//#jp#(Protect)
+
 // do the damage
 	targ.health = targ.health - take;
 			
 	if (targ.health <= 0)
 	{
+	  if (inflictor.modules_weapon == MODULES_WEAPON_DRONE) {	//#jp#(Drone)
+	    targ.modules_killweapon = MODULES_WEAPON_DRONE;		//#jp#(Drone)
+	  }								//#jp#(Drone)
+	  else if (inflictor.modules_weapon == MODULES_WEAPON_SHRAPNEL) {//#jp#(Shrapnel)
+	    targ.modules_killweapon = MODULES_WEAPON_SHRAPNEL;		//#jp#(Shrapnel)
+	  }								//#jp#(Shrapnel)
+	  else if (inflictor.modules_weapon == MODULES_WEAPON_BURN) {	//#jp#(Burn)
+	    targ.modules_killweapon = MODULES_WEAPON_BURN;		//#jp#(Burn)
+	  }								//#jp#(Burn)
+	  else if (inflictor.modules_weapon == MODULES_WEAPON_WELD) {	//#jp#(Weld)
+	    targ.modules_killweapon = MODULES_WEAPON_WELD;		//#jp#(Weld)
+	  }								//#jp#(Weld)
 		Killed (targ, attacker);
 		return;
 	}
diff -ur -x qcc -x *.exe -x *.list -x *.pl -x *.h qc-ori/fight.qc qc/fight.qc
--- qc-ori/fight.qc	Thu Sep 26 11:15:38 1996
+++ qc/fight.qc	Fri Oct  4 00:00:00 1996
@@ -12,15 +12,15 @@
 
 void() knight_atk1;
 void() knight_runatk1;
-void() ogre_smash1;
-void() ogre_swing1;
+//#jp#(Omit) void() ogre_smash1;
+//#jp#(Omit) void() ogre_swing1;
 
-void() sham_smash1;
-void() sham_swingr1;
-void() sham_swingl1;
+//#jp#(Omit) void() sham_smash1;
+//#jp#(Omit) void() sham_swingr1;
+//#jp#(Omit) void() sham_swingl1;
 
-float()	DemonCheckAttack;
-void(float side)	Demon_Melee;
+//#jp#(Omit) float()	DemonCheckAttack;
+//#jp#(Omit) void(float side)	Demon_Melee;
 
 void(vector dest) ChooseTurn;
 
Only in qc: files.dat
diff -ur -x qcc -x *.exe -x *.list -x *.pl -x *.h qc-ori/items.qc qc/items.qc
--- qc-ori/items.qc	Thu Oct  3 18:56:22 1996
+++ qc/items.qc	Fri Oct  4 00:00:00 1996
@@ -2,9 +2,9 @@
 /* ALL LIGHTS SHOULD BE 0 1 0 IN COLOR ALL OTHER ITEMS SHOULD
 BE .8 .3 .4 IN COLOR */
 
-
 void() SUB_regen =
 {
+  if (USE_MODULE_RANDOM) { RandomSetOrigin(self); }   //#jp#(Random)
 	self.model = self.mdl;		// restore original model
 	self.solid = SOLID_TRIGGER;	// allow it to be touched again
 	sound (self, CHAN_VOICE, "items/itembk2.wav", 1, ATTN_NORM);	// play respawn sound
@@ -52,6 +52,7 @@
 		remove(self);
 		return;
 	}
+  if (USE_MODULE_RANDOM) { RandomInitItem(); }   //#jp#(Random)
 };
 
 /*
@@ -168,10 +169,12 @@
 			return;
 	}
 	
+     if (!USE_MODULE_MESSAGES || messages_flag & MESSAGES_HEALTH) { //#jp#(Messages)
 	sprint(other, "You receive ");
 	s = ftos(self.healamount);
 	sprint(other, s);
 	sprint(other, " health\n");
+     }					//#jp#(Messages)
 	
 // health touch sound
 	sound(other, CHAN_ITEM, self.noise, 1, ATTN_NORM);
@@ -180,6 +183,7 @@
 	
 	self.model = string_null;
 	self.solid = SOLID_NOT;
+	if (USE_MODULE_RANDOM) RandomUpdateItem(); //#jp#(Random)
 
 	// Megahealth = rot down the player's super health
 	if (self.healtype == 2)
@@ -274,11 +278,14 @@
 	if (deathmatch == 1)
 		self.nextthink = time + 20;
 	self.think = SUB_regen;
+	if (USE_MODULE_RANDOM) RandomUpdateItem(); //#jp#(Random)
 
+    if (!USE_MODULE_MESSAGES || messages_flag & MESSAGES_ARMOR) //#jp#(Messages)
 	sprint(other, "You got armor\n");
 // armor touch sound
 	sound(other, CHAN_ITEM, "items/armor1.wav", 1, ATTN_NORM);
 	stuffcmd (other, "bf\n");
+	other.protect_finished = time - 10; //#jp#(Protect)
 	
 	activator = other;
 	SUB_UseTargets();				// fire all targets / killtargets
@@ -347,6 +354,15 @@
 
 float(float w) RankForWeapon =
 {
+  // fix bug occuring when picking up backpack //#jp#(Modules)
+  if      (w & IT_LIGHTNING)        return 1;  //#jp#(Modules)
+  else if (w & IT_ROCKET_LAUNCHER)  return 2;  //#jp#(Modules)
+  else if (w & IT_SUPER_NAILGUN)    return 3;  //#jp#(Modules)
+  else if (w & IT_GRENADE_LAUNCHER) return 4;  //#jp#(Modules)
+  else if (w & IT_SUPER_SHOTGUN)    return 5;  //#jp#(Modules)
+  else if (w & IT_NAILGUN)          return 6;  //#jp#(Modules)
+  else                              return 7;  //#jp#(Modules)
+
 	if (w == IT_LIGHTNING)
 		return 1;
 	if (w == IT_ROCKET_LAUNCHER)
@@ -394,6 +410,7 @@
 	local	float	hadammo, best, new, old;
 	local	entity	stemp;
 	local	float	leave;
+	local float weld_oldweapon; //#jp#(Weld)
 
 	if (!(other.flags & FL_CLIENT))
 		return;
@@ -460,9 +477,11 @@
 	else
 		objerror ("weapon_touch: unknown classname");
 
+    if (!USE_MODULE_MESSAGES || messages_flag & MESSAGES_WEAPON) {//#jp#(Messages)
 	sprint (other, "You got the ");
 	sprint (other, self.netname);
 	sprint (other, "\n");
+    }//#jp#(Messages)
 // weapon touch sound
 	sound (other, CHAN_ITEM, "weapons/pkup.wav", 1, ATTN_NORM);
 	stuffcmd (other, "bf\n");
@@ -473,6 +492,8 @@
 	old = other.items;
 	other.items = other.items | new;
 	
+	weld_oldweapon = other.weapon; //#jp#(Weld)
+
 	stemp = self;
 	self = other;
 
@@ -483,6 +504,9 @@
 
 	W_SetCurrentAmmo();
 
+	if (other.weapon==IT_NAILGUN && other.weapon != weld_oldweapon)  WeldToggleWeapon(other); //#jp#(Weld)
+	self.protect_finished = time - 10; //#jp#(Protect)
+
 	self = stemp;
 
 	if (leave)
@@ -494,6 +518,7 @@
 	if (deathmatch == 1)
 		self.nextthink = time + 30;
 	self.think = SUB_regen;
+	if (USE_MODULE_RANDOM) RandomUpdateItem(); //#jp#(Random)
 	
 	activator = other;
 	SUB_UseTargets();				// fire all targets / killtargets
@@ -645,9 +670,11 @@
 
 	bound_other_ammo ();
 	
+    if (!USE_MODULE_MESSAGES || messages_flag & MESSAGES_AMMO) {//#jp#(Messages)
 	sprint (other, "You got the ");
 	sprint (other, self.netname);
 	sprint (other, "\n");
+    }//#jp#(Messages)
 // ammo touch sound
 	sound (other, CHAN_ITEM, "weapons/lock4.wav", 1, ATTN_NORM);
 	stuffcmd (other, "bf\n");
@@ -660,6 +687,7 @@
 		self = other;
 		self.weapon = W_BestWeapon();
 		W_SetCurrentAmmo ();
+  if (self.weapon != best && self.weapon==IT_NAILGUN) WeldToggleWeapon(self); //#jp#(Weld)
 		self = stemp;
 	}
 
@@ -675,6 +703,7 @@
 	if (deathmatch == 1)
 		self.nextthink = time + 30;
 	self.think = SUB_regen;
+	if (USE_MODULE_RANDOM) RandomUpdateItem(); //#jp#(Random)
 
 	activator = other;
 	SUB_UseTargets();				// fire all targets / killtargets
@@ -878,9 +907,11 @@
 	if (other.items & self.items)
 		return;
 
+    if (!USE_MODULE_MESSAGES || messages_flag & MESSAGES_KEY) {//#jp#(Messages)
 	sprint (other, "You got the ");
 	sprint (other, self.netname);
 	sprint (other,"\n");
+    }//#jp#(Messages)
 
 	sound (other, CHAN_ITEM, self.noise, 1, ATTN_NORM);
 	stuffcmd (other, "bf\n");
@@ -1085,9 +1116,13 @@
 	if (other.health <= 0)
 		return;
 
+  other.protect_finished = time - 10; //#jp#(Protect)
+
+  if (!USE_MODULE_MESSAGES || messages_flag & MESSAGES_POWERUP) {//#jp#(Messages)
 	sprint (other, "You got the ");
 	sprint (other, self.netname);
 	sprint (other,"\n");
+  }//#jp#(Messages)
 
 	if (deathmatch)
 	{
@@ -1107,6 +1142,7 @@
 	self.solid = SOLID_NOT;
 	other.items = other.items | self.items;
 	self.model = string_null;
+	if (USE_MODULE_RANDOM) RandomUpdateItem(); //#jp#(Random)
 
 // do the apropriate action
 	if (self.classname == "item_artifact_envirosuit")
@@ -1232,6 +1268,7 @@
 	local	float	best, old, new;
 	local		entity	stemp;
 	local	float	acount;
+ 	local float weld_oldweapon; //#jp#(Weld)
 	
 	if (other.classname != "player")
 		return;
@@ -1239,6 +1276,7 @@
 		return;
 
 	acount = 0;
+  if (!USE_MODULE_MESSAGES || messages_flag & MESSAGES_BACKPACK) {//#jp#(Messages)
 	sprint (other, "You get ");
 
 	if (self.items)
@@ -1248,6 +1286,7 @@
 			sprint (other, "the ");
 			sprint (other, self.netname);
 		}
+  }//#jp#(Messages)
 
 // if the player was using his best weapon, change up to the new one if better		
 	stemp = self;
@@ -1260,6 +1299,7 @@
 	other.ammo_nails = other.ammo_nails + self.ammo_nails;
 	other.ammo_rockets = other.ammo_rockets + self.ammo_rockets;
 	other.ammo_cells = other.ammo_cells + self.ammo_cells;
+	weld_oldweapon = other.weapon; //#jp#(Weld)
 
 	new = self.items;
 	if (!new)
@@ -1269,6 +1309,7 @@
 	
 	bound_other_ammo ();
 
+  if (!USE_MODULE_MESSAGES || messages_flag & MESSAGES_BACKPACK) {//#jp#(Messages)
 	if (self.ammo_shells)
 	{
 		if (acount)
@@ -1307,6 +1348,8 @@
 	}
 	
 	sprint (other, "\n");
+    }//#jp#(Messages)
+
 // backpack touch sound
 	sound (other, CHAN_ITEM, "weapons/lock4.wav", 1, ATTN_NORM);
 	stuffcmd (other, "bf\n");
@@ -1322,6 +1365,8 @@
 		Deathmatch_Weapon (old, new);
 
 	W_SetCurrentAmmo ();
+	if (other.weapon==IT_NAILGUN && other.weapon != weld_oldweapon)  WeldToggleWeapon(other); //#jp#(Weld)
+	other.protect_finished = time - 10; //#jp#(Protect)
 };
 
 /*
diff -ur -x qcc -x *.exe -x *.list -x *.pl -x *.h qc-ori/player.qc qc/player.qc
--- qc-ori/player.qc	Thu Sep 26 11:15:40 1996
+++ qc/player.qc	Fri Oct  4 00:00:00 1996
@@ -282,6 +282,11 @@
 		return;
 	}
 
+   if (self.burn_burning) {	//#jp#(Burn)
+      BurnPainSound();		//#jp#(Burn)
+      return;			//#jp#(Burn)
+   }				//#jp#(Burn)
+
 	if (self.pain_finished > time)
 	{
 		self.axhitme = 0;
@@ -424,9 +429,15 @@
 	return;
 };
 
+void() GibPlayer; //#jp#(Burn)
 
 void() PlayerDead =
 {
+  if (self.modules_killweapon == MODULES_WEAPON_BURN) { //#jp#(Burn)
+    GibPlayer();                                        //#jp#(Burn)
+    return;                                             //#jp#(Burn)
+  }                                                     //#jp#(Burn)
+
 	self.nextthink = -1;
 // allow respawn after a certain time
 	self.deadflag = DEAD_DEAD;
@@ -436,6 +447,13 @@
 {
 	local vector v;
 
+  if (self.modules_killweapon == MODULES_WEAPON_BURN) {	//#jp#(Burn)
+    v = self.velocity;					//#jp#(Burn)
+    v_x = v_x + crandom()*80;				//#jp#(Burn)
+    v_y = v_y + crandom()*80;				//#jp#(Burn)
+    v_z = v_z + 50 + random()*50;			//#jp#(Burn)
+    return v;						//#jp#(Burn)
+  }							//#jp#(Burn)
 	v_x = 100 * crandom();
 	v_y = 100 * crandom();
 	v_z = 200 + 100 * random();
@@ -487,8 +505,10 @@
 	self.solid = SOLID_NOT;
 	self.view_ofs = '0 0 8';
 	setsize (self, '-16 -16 0', '16 16 56');
+ if (!(self.modules_killweapon == MODULES_WEAPON_BURN)) {	//#jp#(Burn)
 	self.velocity = VelocityForDamage (dm);
 	self.origin_z = self.origin_z - 24;
+ }								//#jp#(Burn)
 	self.flags = self.flags - (self.flags & FL_ONGROUND);
 	self.avelocity = crandom() * '0 600 0';
 };
@@ -528,6 +548,8 @@
 	self.items = self.items - (self.items & IT_INVISIBILITY);
 	self.invisible_finished = 0;	// don't die as eyes
 	self.invincible_finished = 0;
+	self.protect_finished = 0;					//#jp#(Protect)
+	self.effects = self.effects - (self.effects & EF_BRIGHTFIELD);	//#jp#(Protect)
 	self.super_damage_finished = 0;
 	self.radsuit_finished = 0;
 	self.modelindex = modelindex_player;	// don't use eyes
@@ -554,6 +576,11 @@
 	
 	self.angles_x = 0;
 	self.angles_z = 0;
+
+  if (self.modules_killweapon == MODULES_WEAPON_BURN) { //#jp#(Burn)
+    player_dieb1();                                     //#jp#(Burn)
+    return;                                             //#jp#(Burn)
+  }                                                     //#jp#(Burn)
 	
 	if (self.weapon == IT_AXE)
 	{
Only in qc-ori: progs.dat
diff -ur -x qcc -x *.exe -x *.list -x *.pl -x *.h qc-ori/progs.src qc/progs.src
--- qc-ori/progs.src	Thu Sep 26 11:15:40 1996
+++ qc/progs.src	Fri Oct  4 00:00:00 1996
@@ -1,6 +1,29 @@
 ../progs.dat
 
 defs.qc
+
+_modules.qh
+_plystat.qh
+_burn.qh
+_drone.qh
+_exitrls.qh
+_init.qh
+_kckscdr.qh
+_levsel.qh
+_lightng.qh
+_message.qh
+_motd.qh
+_random.qh
+_rank.qh
+_skin.qh
+_observe.qh
+_protect.qh
+_servhlp.qh
+_servcon.qh
+_shrap.qh
+_vote.qh
+_weldgun.qh
+
 subs.qc
 fight.qc
 ai.qc
@@ -17,19 +40,43 @@
 plats.qc
 misc.qc
 
-ogre.qc
-demon.qc
-shambler.qc
-knight.qc
-soldier.qc
-wizard.qc
-dog.qc
-zombie.qc
-boss.qc
-
-tarbaby.qc		// registered
-hknight.qc		// registered
-fish.qc			// registered
-shalrath.qc		// registered
+//#jp#(Omit) ogre.qc
+//#jp#(Omit) demon.qc
+//#jp#(Omit) shambler.qc
+//#jp#(Omit) knight.qc
+//#jp#(Omit) soldier.qc
+//#jp#(Omit) wizard.qc
+//#jp#(Omit) dog.qc
+//#jp#(Omit) zombie.qc
+//#jp#(Omit) boss.qc
+
+//#jp#(Omit) tarbaby.qc		// registered
+//#jp#(Omit) hknight.qc		// registered
+//#jp#(Omit) fish.qc			// registered
+//#jp#(Omit) shalrath.qc		// registered
 enforcer.qc		// registered
-oldone.qc		// registered
+//#jp#(Omit) oldone.qc		// registered
+
+_plystat.qc
+_burn.qc
+_drone.qc
+_exitrls.qc
+_init.qc
+_kckscdr.qc
+_levsel.qc
+_lightng.qc
+_message.qc
+_modules.qc
+_motd.qc
+_observe.qc
+_protect.qc
+_skin.qc
+_random.qc
+_rank.qc
+_servcon.qc
+_servhlp.qc
+_shrap.qc
+_vote.qc
+_weldgun.qc
+_omit.qc
+
diff -ur -x qcc -x *.exe -x *.list -x *.pl -x *.h qc-ori/weapons.qc qc/weapons.qc
--- qc-ori/weapons.qc	Mon Sep 30 03:08:08 1996
+++ qc/weapons.qc	Fri Oct  4 00:00:00 1996
@@ -22,6 +22,45 @@
 	precache_sound ("weapons/grenade.wav");	// grenade launcher
 	precache_sound ("weapons/bounce.wav");		// grenade bounce
 	precache_sound ("weapons/shotgn2.wav");	// super shotgun
+   if (USE_MODULE_SHRAPNEL) {				//#jp#(Shrapnel)
+     shrapnel_launch_sound_1 = "weapons/sgun1.wav";	//#jp#(Shrapnel)
+     shrapnel_launch_sound_2 = "knight/sword1.wav";	//#jp#(Shrapnel)
+     shrapnel_explode_sound  = "weapons/sgun1.wav";	//#jp#(Shrapnel)
+     //precache_sound (shrapnel_launch_sound_1);		//#jp#(Shrapnel)
+     precache_sound (shrapnel_launch_sound_2);		//#jp#(Shrapnel)
+     //precache_sound (shrapnel_explode_sound);		//#jp#(Shrapnel)
+   }							//#jp#(Shrapnel)
+   if (USE_MODULE_DRONE) {				//#jp#(Drone)
+     drone_launch_sound_1 = "shalrath/attack2.wav";	//#jp#(Drone)
+     drone_launch_sound_2 = "knight/khurt.wav";		//#jp#(Drone)
+     drone_hoover_sound   = "boss1/throw.wav";		//#jp#(Drone)
+     precache_sound (drone_launch_sound_1);		//#jp#(Drone)
+     precache_sound (drone_launch_sound_2);		//#jp#(Drone)
+     precache_sound (drone_hoover_sound);		//#jp#(Drone)
+   }							//#jp#(Drone)
+   if (USE_MODULE_WELDGUN) {				//#jp#(Weld)
+     weld_fire_sound_1  = "weapons/spike2.wav";		//#jp#(Weld)
+     weld_fire_sound_2  = "hknight/idle.wav";		//#jp#(Weld)
+     weld_explode_sound = "wizard/hit.wav";		//#jp#(Weld)
+     //precache_sound (weld_fire_sound_1);		//#jp#(Weld)
+     precache_sound (weld_fire_sound_2);		//#jp#(Weld)
+     precache_sound (weld_explode_sound);		//#jp#(Weld)
+   }							//#jp#(Weld)
+   if (USE_MODULE_PROTECT) {				//#jp#(Protect)
+     protect_sound  = "wizard/wdeath.wav";		//#jp#(Protect)
+     precache_sound (protect_sound);			//#jp#(Protect)
+   }							//#jp#(Protect)
+   if (USE_MODULE_BURN) {				//#jp#(Burn)
+     burn_pain_sound_1     = "player/lburn1.wav";	//#jp#(Burn)
+     burn_pain_sound_2     = "player/lburn2.wav";	//#jp#(Burn)
+     burn_extinguish_sound = "player/slimbrn2.wav";	//#jp#(Burn)
+     burn_light_sound      = "boss1/throw.wav";		//#jp#(Burn)
+     //precache_sound (burn_pain_sound_1);		//#jp#(Burn)
+     //precache_sound (burn_pain_sound_2);		//#jp#(Burn)
+     //precache_sound (burn_extinguish_sound);		//#jp#(Burn)
+     precache_sound (burn_light_sound);			//#jp#(Burn)
+   }							//#jp#(Burn)
+
 };
 
 float() crandom =
@@ -62,6 +101,7 @@
 		WriteCoord (MSG_BROADCAST, org_y);
 		WriteCoord (MSG_BROADCAST, org_z);
 	}
+	self.protect_finished = time - 10; //#jp#(Protect)
 };
 
 
@@ -268,6 +308,8 @@
 
 	sound (self, CHAN_WEAPON, "weapons/guncock.wav", 1, ATTN_NORM);	
 
+	self.protect_finished = time - 10; //#jp#(Protect)
+
 	self.punchangle_x = -2;
 	
 	self.currentammo = self.ammo_shells = self.ammo_shells - 1;
@@ -293,6 +335,8 @@
 		
 	sound (self ,CHAN_WEAPON, "weapons/shotgn2.wav", 1, ATTN_NORM);	
 
+	self.protect_finished = time - 10; //#jp#(Protect)
+
 	self.punchangle_x = -4;
 	
 	self.currentammo = self.ammo_shells = self.ammo_shells - 2;
@@ -374,6 +418,12 @@
 void() W_FireRocket =
 {
 	local	entity missile, mpuff;
+
+	self.protect_finished = time - 10; //#jp#(Protect)
+	if (self.modules_weapon & MODULES_WEAPON_SHRAPNEL) { //#jp#(Shrapnel)
+	  ShrapnelMissileFire();                             //#jp#(Shrapnel)
+	  return;                                            //#jp#(Shrapnel)
+	}                                                    //#jp#(Shrapnel)
 	
 	self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;
 	
@@ -471,9 +521,25 @@
 	{
 		self.weapon = W_BestWeapon ();
 		W_SetCurrentAmmo ();
+		if (self.weapon==IT_NAILGUN) WeldToggleWeapon(self); //#jp#(Weld)
 		return;
 	}
 
+  self.protect_finished = time - 10; //#jp#(Protect)
+  if (USE_MODULE_LIGHTNING) {				//#jp#(Lightning)
+    if (self.waterlevel > 2) {				//#jp#(Lightning)
+      if (USE_MODULE_LIGHTNING) {			//#jp#(Lightning)
+	local float ddd;				//#jp#(Lightning)
+	ddd = 20*self.ammo_cells;			//#jp#(Lightning)
+	if (ddd > 400) ddd = 400;			//#jp#(Lightning)
+	T_RadiusDamage (self, self, ddd, world);	//#jp#(Lightning)
+	self.ammo_cells = 0;				//#jp#(Lightning)
+	W_SetCurrentAmmo ();				//#jp#(Lightning)
+	return;						//#jp#(Lightning)
+      }							//#jp#(Lightning)
+    }							//#jp#(Lightning)
+  }							//#jp#(Lightning)
+  else {						//#jp#(Lightning)
 // explode if under water
 	if (self.waterlevel > 1)
 	{
@@ -483,12 +549,15 @@
 		T_RadiusDamage (self, self, 35*cells, world);
 		return;
 	}
+   }							//#jp#(Lightning)
 
+   if (!USE_MODULE_LIGHTNING) {				//#jp#(Lightning)
 	if (self.t_width < time)
 	{
 		sound (self, CHAN_WEAPON, "weapons/lhit.wav", 1, ATTN_NORM);
 		self.t_width = time + 0.6;
 	}
+   }							//#jp#(Lightning)
 	self.punchangle_x = -2;
 
 	self.currentammo = self.ammo_cells = self.ammo_cells - 1;
@@ -497,6 +566,8 @@
 	
 	traceline (org, org + v_forward*600, TRUE, self);
 
+   if (USE_MODULE_LIGHTNING) LightningMakeNoise(self,trace_endpos);//#jp#(Lightning)
+
 	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
 	WriteByte (MSG_BROADCAST, TE_LIGHTNING2);
 	WriteEntity (MSG_BROADCAST, self);
@@ -531,6 +602,8 @@
 {
 	if (other == self.owner)
 		return;		// don't explode on owner
+   if (other.classname == "drone") return; //#jp#(Drone)
+
 	if (other.takedamage == DAMAGE_AIM)
 	{
 		GrenadeExplode();
@@ -549,6 +622,12 @@
 void() W_FireGrenade =
 {
 	local	entity missile, mpuff;
+
+  self.protect_finished = time - 10; //#jp#(Protect)
+  if (self.modules_weapon & MODULES_WEAPON_DRONE) {	//#jp#(Drone)
+    DroneFire();					//#jp#(Drone)
+    return;						//#jp#(Drone)
+  }							//#jp#(Drone)
 	
 	self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;
 	
@@ -606,6 +685,11 @@
 */
 void(vector org, vector dir) launch_spike =
 {
+  if (self.modules_weapon & MODULES_WEAPON_WELD) {    //#jp#(Weld)
+    WeldFire(org,dir);                                //#jp#(Weld)
+    return;				              //#jp#(Weld)
+  }					              //#jp#(Weld)
+
 	newmis = spawn ();
 	newmis.owner = self;
 	newmis.movetype = MOVETYPE_FLYMISSILE;
@@ -630,6 +714,7 @@
 	local entity	old;
 	
 	sound (self, CHAN_WEAPON, "weapons/spike2.wav", 1, ATTN_NORM);
+	self.protect_finished = time - 10; //#jp#(Protect)
 	self.attack_finished = time + 0.2;
 	self.currentammo = self.ammo_nails = self.ammo_nails - 2;
 	dir = aim (self, 1000);
@@ -660,8 +745,13 @@
 		return;
 	}
 
+  if (!(self.modules_weapon & MODULES_WEAPON_WELD)) {    //#jp#(Weld)
 	sound (self, CHAN_WEAPON, "weapons/rocket1i.wav", 1, ATTN_NORM);
+  } else {                                               //#jp#(Weld)
+    ox = ox - 1;                                         //#jp#(Weld)
+  }	                                                 //#jp#(Weld)
 	self.attack_finished = time + 0.2;
+	self.protect_finished = time - 10; //#jp#(Protect)
 	self.currentammo = self.ammo_nails = self.ammo_nails - 1;
 	dir = aim (self, 1000);
 	launch_spike (self.origin + '0 0 16' + v_right*ox, dir);
@@ -686,6 +776,8 @@
 		remove(self);
 		return;
 	}
+
+   if (other.classname == "drone") return; //#jp#(Drone)
 	
 // hit something that bleeds
 	if (other.takedamage)
@@ -731,6 +823,10 @@
 	if (other.takedamage)
 	{
 		spawn_touchblood (18);
+   if (other.classname == "drone") {		//#jp#(Drone)
+      T_Damage (other, self, self.owner, 4);	//#jp#(Drone)
+      return;					//#jp#(Drone)
+   }						//#jp#(Drone)
 		T_Damage (other, self, self.owner, 18);
 	}
 	else
@@ -761,6 +857,10 @@
 
 	self.items = self.items - ( self.items & (IT_SHELLS | IT_NAILS | IT_ROCKETS | IT_CELLS) );
 	
+	if (self.weapon != IT_GRENADE_LAUNCHER) DroneResetWeapon(self);   //#jp#(Shrapnel)
+	if (self.weapon != IT_ROCKET_LAUNCHER) ShrapnelResetWeapon(self); //#jp#(Drone)
+	if (self.weapon != IT_NAILGUN) WeldResetWeapon(self);             //#jp#(Weld)
+
 	if (self.weapon == IT_AXE)
 	{
 		self.currentammo = 0;
@@ -852,6 +952,7 @@
 		return TRUE;
 	
 	self.weapon = W_BestWeapon ();
+   if (self.weapon==IT_NAILGUN) WeldToggleWeapon(self); //#jp#(Weld)
 
 	W_SetCurrentAmmo ();
 	
@@ -935,6 +1036,7 @@
 	{
 		player_light1();
 		self.attack_finished = time + 0.1;
+		self.lightning_sound_lasttime = -1;//#jp#(Lightning)
 		sound (self, CHAN_AUTO, "weapons/lstart.wav", 1, ATTN_NORM);
 	}
 };
@@ -949,6 +1051,8 @@
 {
 	local	float	it, am, fl;
 	
+	if (self.player_status & PLAYER_IS_OBSERVER) return; //#jp#(Observer)
+
 	it = self.items;
 	am = 0;
 	
@@ -971,6 +1075,7 @@
 	else if (self.impulse == 4)
 	{
 		fl = IT_NAILGUN;
+		if (self.weapon != IT_NAILGUN) WeldToggleWeapon(self); //#jp#(Weld)
 		if (self.ammo_nails < 1)
 			am = 1;
 	}
@@ -983,12 +1088,14 @@
 	else if (self.impulse == 6)
 	{
 		fl = IT_GRENADE_LAUNCHER;
+		DroneToggleWeapon(self);  //#jp#(Drone)
 		if (self.ammo_rockets < 1)
 			am = 1;
 	}
 	else if (self.impulse == 7)
 	{
 		fl = IT_ROCKET_LAUNCHER;
+		ShrapnelToggleWeapon(self); //#jp#(Shrapnel)
 		if (self.ammo_rockets < 1)
 			am = 1;
 	}
@@ -1018,6 +1125,9 @@
 //
 	self.weapon = fl;		
 	W_SetCurrentAmmo ();
+
+ if (self.weapon == IT_NAILGUN)  WeldToggleWeapon(self);   //#jp#(Weld)
+
 };
 
 /*
@@ -1064,6 +1174,8 @@
 	
 	it = self.items;
 	self.impulse = 0;
+
+	if (self.player_status & PLAYER_IS_OBSERVER) return; //#jp#(Observer)
 	
 	while (1)
 	{
@@ -1119,6 +1231,7 @@
 		if ( (it & self.weapon) && am == 0)
 		{
 			W_SetCurrentAmmo ();
+  if (self.weapon == IT_NAILGUN) WeldToggleWeapon(self); //#jp#(Weld)
 			return;
 		}
 	}
@@ -1139,6 +1252,8 @@
 	it = self.items;
 	self.impulse = 0;
 
+	if (self.player_status & PLAYER_IS_OBSERVER) return; //#jp#(Observer)
+
 	while (1)
 	{
 		am = 0;
@@ -1193,6 +1308,7 @@
 		if ( (it & self.weapon) && am == 0)
 		{
 			W_SetCurrentAmmo ();
+  if (self.weapon == IT_NAILGUN) WeldToggleWeapon(self); //#jp#(Weld)
 			return;
 		}
 	}
@@ -1229,6 +1345,8 @@
 */
 void() ImpulseCommands =
 {
+   if (self.impulse) {						//#jp#(Modules)
+
 	if (self.impulse >= 1 && self.impulse <= 8)
 		W_ChangeWeapon ();
 
@@ -1243,6 +1361,74 @@
 
 	if (self.impulse == 255)
 		QuadCheat ();
+
+        if (self.impulse >= 200) {				//#jp#(Modules)
+           if (self.impulse == 200) {				//#jp#(Skin)
+	      if (USE_MODULE_SKIN) SkinUseOtherSkin(self,1);	//#jp#(Skin)
+           }							//#jp#(Skin)
+           else if (self.impulse == 201) {			//#jp#(Skin)
+	      if (USE_MODULE_SKIN) SkinUseOtherSkin(self,(-1));	//#jp#(Skin)
+           }							//#jp#(Skin)
+           else if (self.impulse == 202) {			//#jp#(Skin)
+	      if (USE_MODULE_SKIN) SkinHelp(self);		//#jp#(Skin)
+           }							//#jp#(Skin)
+           else if (self.impulse == 203) {			//#jp#(Rank)
+              if (USE_MODULE_RANK) RankDumpRanksToConsole(self);//#jp#(Rank)
+           }							//#jp#(Rank)
+           else if (self.impulse == 204) {			//#jp#(Rank)
+              if (USE_MODULE_RANK) RankHelp(self);		//#jp#(Rank)
+           }							//#jp#(Rank)
+           else if (self.impulse == 205) {			//#jp#(Observer)
+              if (USE_MODULE_OBSERVER) ObserverHelp(self);	//#jp#(Observer)
+           }							//#jp#(Observer)
+           else if (self.impulse == 206) {			//#jp#(Observer)
+              if (USE_MODULE_OBSERVER) ObserverNoclip(self);	//#jp#(Observer)
+           }							//#jp#(Observer)
+           else if (self.impulse == 207) {			//#jp#(ServerHelp)
+              if (USE_MODULE_SERVERHELP) ServerHelpShowHelp(self);//#jp#(ServerHelp)
+           }							//#jp#(ServerHelp)
+           else if (self.impulse == 208) {			//#jp#(Init)
+              if (InitCallIsPermitted(self)) {			//#jp#(Init)
+                 stuffcmd(self,"init;\n");			//#jp#(Init)
+              }							//#jp#(Init)
+           }							//#jp#(Init)
+           else if (self.impulse == 209) {			//#jp#(Init)
+              if (InitCallIsPermitted(self)) {			//#jp#(Init)
+	         if (USE_MODULE_SKIN) {				//#jp#(Skin)
+                    SkinQuietlyUseOtherSkin(self,1);		//#jp#(Skin)
+                 }						//#jp#(Skin)
+                 stuffcmd(self,"init;\n");			//#jp#(Init)
+              }							//#jp#(Init)
+           }							//#jp#(Init)
+           else if (self.impulse == 210) {			//#jp#(ExitRules)
+              if (USE_MODULE_EXITRULES) ExitRulesHelp(self);	//#jp#(ExitRules)
+           }							//#jp#(ExitRules)
+           else if (self.impulse == 211) {			//#jp#(VoteExit)
+              if (USE_MODULE_VOTE) VoteHelp(self);		//#jp#(Vote)
+           }							//#jp#(Vote)
+           else if (self.impulse == 212) {			//#jp#(VoteExit)
+              if (USE_MODULE_VOTE) VoteShowVotes(self);		//#jp#(Vote)
+           }							//#jp#(Vote)
+           else if (self.impulse == 213) {			//#jp#(Vote)
+              if (USE_MODULE_VOTE) VoteExitVote(self);		//#jp#(Vote)
+           }							//#jp#(Vote)
+           else if (self.impulse == 214) {			//#jp#(Vote)//#jp#(ExitRules)
+              if (USE_MODULE_VOTE) VoteExitRulesVote(self);	//#jp#(Vote)//#jp#(ExitRules)
+           }							//#jp#(Vote)//#jp#(ExitRules)
+           else if (self.impulse == 215) {			//#jp#(Vote)//#jp#(ExitRules)
+              if (USE_MODULE_DRONE) DroneHelp(self);		//#jp#(Drone)
+           }							//#jp#(Drone)
+           else if (self.impulse == 216) {			//#jp#(Shrapnel)
+              if (USE_MODULE_SHRAPNEL) ShrapnelHelp(self);	//#jp#(Shrapnel)
+           }							//#jp#(Shrapnel)
+           else if (self.impulse == 217) {			//#jp#(Weld)
+              if (USE_MODULE_WELDGUN) WeldHelp(self);		//#jp#(Weld)
+           }							//#jp#(Weld)
+           else if (self.impulse == 218) {			//#jp#(Modules)
+              ModulesShowActiveModules(self);			//#jp#(Modules)
+           }							//#jp#(Modules)
+        }							//#jp#(Modules)
+   }								//#jp#(Modules)
 		
 	self.impulse = 0;
 };
diff -ur -x qcc -x *.exe -x *.list -x *.pl -x *.h qc-ori/world.qc qc/world.qc
--- qc-ori/world.qc	Thu Sep 26 11:15:40 1996
+++ qc/world.qc	Fri Oct  4 00:00:00 1996
@@ -254,6 +254,10 @@
 	precache_sound ("misc/water1.wav");			// swimming
 	precache_sound ("misc/water2.wav");			// swimming
 
+if (USE_MODULE_OBSERVER) {			//#jp#(Observer)
+	precache_sound ("wizard/wsight.wav");	//#jp#(Observer)
+}						//#jp#(Observer)
+
 	precache_model ("progs/player.mdl");
 	precache_model ("progs/eyes.mdl");
 	precache_model ("progs/h_player.mdl");
@@ -288,6 +292,16 @@
 
 	precache_model ("progs/v_light.mdl");
 	
+	if (USE_MODULE_DRONE) {                 //#jp#(Drone)
+	  precache_model ("progs/v_spike.mdl"); //#jp#(Drone)
+	}                                       //#jp#(Drone)
+	if (USE_MODULE_WELDGUN) {               //#jp#(Weld)
+	  precache_model ("progs/flame2.mdl");  //#jp#(Weld)
+	}                                       //#jp#(Weld)
+	if (USE_MODULE_SHRAPNEL) {              //#jp#(Shrapnel)
+	  precache_model ("progs/flame2.mdl");  //#jp#(Shrapnel)
+	  precache_model ("progs/tarbaby.mdl"); //#jp#(Shrapnel)
+	}                                       //#jp#(Shrapnel)
 
 //
 // Setup light animation tables. 'a' is total darkness, 'z' is maxbright.
@@ -377,6 +391,7 @@
 // respawned elsewhere
 void(entity ent) CopyToBodyQue =
 {
+	bodyque_head.skin = ent.skin; //#jp#(Skin)
 	bodyque_head.angles = ent.angles;
 	bodyque_head.model = ent.model;
 	bodyque_head.modelindex = ent.modelindex;
