/*----------------------------------------------------------------------------
PROJECT	config.exe
FILE	config.h
HISTORY
	Tilakraj Roychoudhury 941018 Created
ABOUT
	Contains the config structure that is used by the configuration
	parser to pass the required configuration to the plug and play
	configuration engine.
----------------------------------------------------------------------------*/

#define	MAX_IO_PORTS		8
#define MAX_DMA_CHANNELS	2
#define	MAX_IRQS		2
#define MAX_MEM_REGISTERS	4


#define LOBYTE(w)       ((unsigned char)(w))
#define HIBYTE(w)       ((unsigned char)(((unsigned int)(w) >> 8) & 0xFF))

#define LOWORD(l)       ((unsigned int)(unsigned long)(l))
#define HIWORD(l)       ((unsigned int)((((unsigned long)(l)) >> 16) & 0xFFFF))


typedef struct _CONFIG
{
	// unused field
	unsigned long	dwFlags;
	// logical device number for this configuration
	unsigned short	wLogicalDevice;


	// pointer to next node in link list
	_CONFIG		*Next;

	// number of I/O ranges
	unsigned short	wNumIO;
	// the IO base address
	unsigned short	wIO [ MAX_IO_PORTS ];

	// number of IRQ channels
	unsigned short	wNumIRQ;
	// the IRQ resources
	unsigned short	wIRQ [ MAX_IRQS ];

	// number of DMA channels
	unsigned short	wNumDMA;
	// the DMA channel resoures
	unsigned short	wDMA [ MAX_DMA_CHANNELS ];

	// number of valid memory descriptors
	unsigned short	wNumMEM;				
	// base address of the peripherals on board memory
	unsigned long	dwMEM [ MAX_MEM_REGISTERS ];
	// length of memory in bytes 
	unsigned long	dwLength [ MAX_MEM_REGISTERS ];
	// 8 or 16 bit decoding
	unsigned char	bBits [ MAX_MEM_REGISTERS ];
}	CONFIG, *PCONFIG;

//----------------------------------------------------------------------------
//			FUNCTION PROTOTYPES
//----------------------------------------------------------------------------
// prptotypes of functions defines in config.c
void	Reset ( void );
void 	EnterSleepMode ( void );
void 	GoIntoIsolation ( unsigned char CSN );
void	SetReadPort ( void );
void	AssignCSN ( void );
void	Config ( PCONFIG pConfig );

// prototypes of functions defined in parser.c
unsigned short GetNextToken( char* pszString, unsigned short &wPosition,
	char* pszToken  );
unsigned short ParseLine ( char* szFileString , PCONFIG *ppConfig);

