// $RCSfile: JavaTalkClient.java,v $
// $Id: JavaTalkClient.java,v 1.25 1996/07/15 20:19:18 fms Exp fms $
// by Frank Stajano, http://www.cam-orl.co.uk/~fms
// Development started on 1996 05 09
// (c) Olivetti Research Limited

/*
    Copyright (c) 1996 Olivetti Research Limited

    Permission is hereby granted, without written agreement and
    without license or royalty fees, to use, copy, modify, and
    distribute this software and its documentation for any purpose,
    provided that the above copyright notice and the following three
    paragraphs appear in all copies of this software, its documentation
    and any derivative work.

    In no event shall Olivetti Research Limited be liable to any party
    for direct, indirect, special, incidental, or consequential damages
    arising out of the use of this software and its documentation, even
    if Olivetti Research Limited has been advised of the possibility of
    such damage.

    Olivetti Research Limited specifically disclaims any warranties,
    including, but not limited to, the implied warranties of
    merchantability and fitness for a particular purpose. The
    software provided hereunder is on an "as is" basis, and Olivetti
    Research Limited has no obligation to provide maintenance,
    support, updates, enhancements, or modifications.

    Derived or altered versions must be plainly marked as such, and
    must not be misrepresented as being the original software.
*/


// TRIVIAL TODO
// only honour enter key if focus is in small window
// provide buttons for functions like MYNAME and WHO
// make font and size changeable by user
// play cute sound when someone joins

// ADVANCED TODO
// implement the more complete timestamp protocol
// make window floating
// provide separate window for roundtrip messages
// synchronize server and client clocks

import java.io.*;
import java.net.*;
import java.applet.*;
import java.awt.*;
import java.util.*;

public class JavaTalkClient extends Applet {
    // These are automatically substituted
    public static final String rcsVersion = "$Revision: 1.25 $";
    public static final String rcsDate = "$Date: 1996/07/15 20:19:18 $";
    public static final String rcsProgram = "$RCSfile: JavaTalkClient.java,v $";

    // These extract the useful parts from the automatically substituted ones.
    public static final String version = rcsVersion.substring(11, rcsVersion.length()-2);
    public static final String date = rcsDate.substring(7, 17);
    public static final String program = rcsProgram.substring(10, rcsProgram.length()-9);
    public static final String about = "\n  " + program + " v. " + version + " of " + date
            + "\n  by Frank Stajano, (C) Olivetti Research Limited\n";

    public static final int DEFAULT_PORT = 6764;
    public static final String DEFAULT_HOST = "badges.cam-orl.co.uk";
    public static final boolean DEFAULT_SHOWROUNDTRIP = false;
    public static final boolean DEFAULT_SHOWTIMESTAMPS = false;

    public static final int MAX_CHARS = 10000;
        // When the text window contains this
        // amount of stuff or more,
        // it's time to start chopping old stuff off the top.
        // NB: weird behaviour (i.e. you can't write to the window
        // any more) is observed around the 27000-28000
        // characters mark. I don't know what imposes the limit and
        // haven't found any documentation on it yet-- I
        // thought it would be more like 64kb, i.e. 32k unicode chars.
        // This constant used to be set at 32000 and the program would
        // freeze when reaching 28000 or so...

    public static Random idGen = new Random();
        // random number generator, common to the class so that successive
        // applets use the same stream instead of restarting a new generator

    protected Listener listener = null;
    protected Typist typist = null;
    protected int port;
    protected String host;
    protected int maxChars;
    protected Socket s = null;
    protected String myAddressAndPort;
    protected int myId = idGen.nextInt();
    protected boolean showRoundTripInitially;
    protected boolean showTimestampsInitially;

    public String[][] getParameterInfo() {
        String[][] info = {
            // name, type, description
            {"host", "string", "internet name of the host on which the server runs"},
            {"port", "integer", "port on which the server is listening for connections"},
            {"showRoundTrip", "boolean", "initial value of corresponding checkbox"},
            {"showTimestamps", "boolean", "initial value of corresponding checkbox"},
            {"maxChars", "integer", "maximum number of characters in window before top chopped off"}
        };
        return info;
    }

    public String getAppletInfo() {
        return about;
    }

    public void init() {
        // Figure out parameters
        System.err.println("init() called");
        System.err.println(about);

        try {
            port = Integer.parseInt(getParameter("port"));
        }
        catch (NumberFormatException e) {
            port = DEFAULT_PORT;
        }

        host = getParameter("host");
        if (host == null) {
            host = DEFAULT_HOST;
        }
        showRoundTripInitially = Boolean.valueOf(
                getParameter("showRoundTrip")).booleanValue();
        showTimestampsInitially = Boolean.valueOf(
                getParameter("showTimestamps")).booleanValue();

        try {
            maxChars = Integer.parseInt(getParameter("maxChars"));
        }
        catch (NumberFormatException e) {
            maxChars = MAX_CHARS;
        }


        System.out.println("host = " + host
                + "\nport = " + port
                + "\nshowRoundTrip = " + showRoundTripInitially
                + "\nshowTimestamps = " + showTimestampsInitially
                + "\nmaxChars = " + maxChars
        );
    }

    public void destroy() {
        System.err.println("destroy() called");
    }

    public void finalize() throws Throwable {
        System.err.println("finalize() called");
    }

    public void start() {
        System.err.println("start() called");
        // make socket, windows and threads
        try {
            s = new Socket(host, port);

            myAddressAndPort = s.getInetAddress() + ":"+ s.getPort();
            System.err.println("Connected to server at " + myAddressAndPort);
        }
        catch (IOException e) {
            System.err.println("Couldn't make socket: "+  e);
            this.cleanUp();
            return;
        }


        //{{INIT_CONTROLS
        setLayout(null);
        resize(511,377);
        winLocal=new TextField(44);
        winLocal.setFont(new Font("Courier",Font.PLAIN,10));
        add(winLocal);
        winLocal.reshape(126,315,371,30);
        typePrompt=new Label("Type here:", Label.RIGHT);
        typePrompt.setFont(new Font("Helvetica",Font.PLAIN,12));
        add(typePrompt);
        typePrompt.reshape(7,330,112,15);
        winAll=new TextArea(19,60);
        winAll.setFont(new Font("Courier",Font.PLAIN,10));
        add(winAll);
        winAll.reshape(7,0,497,308);
        showRoundTripCheck=new Checkbox("Show round trip time");
        add(showRoundTripCheck);
        showRoundTripCheck.reshape(126,353,154,22);
        showTimestampsCheck=new Checkbox("Show timestamp messages");
        add(showTimestampsCheck);
        showTimestampsCheck.reshape(315,353,182,22);
        //}}

        showRoundTripCheck.setState(showRoundTripInitially);
        showTimestampsCheck.setState(showTimestampsInitially);
        winAll.setEditable(false);
        winAll.appendText(about + "\n");
        listener = new Listener(s, winAll, this);
        typist = new Typist(s, winLocal, this);

    }

    public void stop() {
        System.err.println("stop() called");
        cleanUp();
        super.stop();
    }

    public void cleanUp() {
        System.err.println("cleanUp() called");

        // remember these in case the user stops and restarts
        showRoundTripInitially = showRoundTripCheck.getState();
        showTimestampsInitially = showTimestampsCheck.getState();

        // stop threads, remove windows and delete socket
        if (typist != null && typist.running) {
            typist.stop();
        }
        typist = null;
        System.err.println("typist thread stopped and forgotten");

        if (listener != null && listener.running) {
            System.err.println("about to stop listener...");
            listener.stop();
            System.err.println("listener stopped ok");
        }
        listener = null;
        System.err.println("listener thread stopped and forgotten");

        removeAll();
        System.err.println("windows deleted");

        try {
            if (s != null) {
                s.close();
                System.err.println("socket closed ok");
            }
        }
        catch (IOException e) {
            System.err.println("Couldn't close socket: " + e);
        }
        s = null;
        myAddressAndPort = "";
        repaint();
    }


    public boolean keyUp(Event e, int key)  {
        // When the applet receives a key event, if it was a Return
        // then it is dispatched to the typist thread.
        int flags = e.modifiers;
        if ((e.id == Event.KEY_RELEASE)  &&  (e.key == '\n')) {
            if (typist != null) {
                typist.sendLine();
            }
            return true; // I handled it myself
        } else {
            return false; // I want someone else to handle it
        }
    }


    public void paint(Graphics g) {
        if (typist == null && listener == null && s == null) {
            g.setFont(new Font("Helvetica",Font.BOLD,18));
            g.drawString("Not connected to server. Threads stopped.", 20, 180);
        }
    }


    public void safelyAppendTextToMainWindow(String toBeAppended) {
        // trim top lines off the widget when we are near the max size
        // or it will become full and it won't take any more.
        TextArea w = winAll;
        String text = w.getText();
        while (text.length() + toBeAppended.length() > maxChars) {
            int upTo = text.indexOf("\n");
            w.replaceText("", 0, upTo+1);
            text = w.getText();
        }
        w.appendText(toBeAppended);
    }

    //{{DECLARE_CONTROLS
    TextField winLocal;
    Label typePrompt;
    TextArea winAll;
    Checkbox showRoundTripCheck;
    Checkbox showTimestampsCheck;
    //}}

}



class Typist extends Thread {
    protected PrintStream sout;
    protected TextField w;
    protected boolean running = false;
    protected JavaTalkClient applet;
    protected long lineId = 0;

    public Typist(Socket s, TextField window, JavaTalkClient applet) {
        System.err.println("Making a typist...");
        w = window;
        this.applet = applet;
        try {
            sout = new PrintStream(s.getOutputStream());
            System.err.println("Typist thread opened output stream to server");
        }
        catch (IOException e) {
            System.err.println ("Typist thread can't open output stream to server");
            running = false;
            applet.cleanUp();
            return;
        }
        this.start();
    }

    public void run() {
        System.err.println("Typist thread running...");
        running = true;
    }

    protected void finalize() throws Throwable {
            sout.close();
            sout = null;
            System.err.println("Typist thread closed its output stream.");
       System.out.println("Typist thread stopped.");
    }


    public void sendLine() {
        String line = w.getText();
        w.setText("");

        if (line == null) {
        }

        line = line.trim() + "\n";

        if (applet.showRoundTripCheck.getState()) {
            long timeSent = (new Date()).getTime();
            sout.print("TIMESTAMP myid:" + applet.myId
                    + " lineid:" + lineId
                    + " timesent:" + timeSent + "\n");
        }
        sout.print(line);
        sout.flush();

        lineId++;
    }
}


class Listener extends Thread {
    protected DataInputStream sin;
    protected TextArea w;
    protected boolean running = false;
    protected JavaTalkClient applet;

    public Listener(Socket s, TextArea window, JavaTalkClient applet) {
        System.out.println("Making a listener...");
        w = window;
        this.applet = applet;
        try {
            sin = new DataInputStream(s.getInputStream());
            System.out.println("Listener thread opened its input stream.");
        }
        catch (IOException e) {
            System.err.println ("Listener thread can't open input stream: " + e);
            running = false;
            applet.cleanUp();
            return;
        }
        this.start();
    }

    public void run() {
        // listens to the socket and, whenever the server says something,
        // puts it in the window.

        System.out.println("Listener thread starting...");
        running = true;

        String line;
        while (true) {
            try {
                line = sin.readLine();
            }
            catch (IOException e) {
                System.err.println("Listener: error in readLine: " + e);
                running = false;
                applet.cleanUp();
                return;
            }

            // Check if connection is closed (i.e. for EOF)
            if (line == null) {
                System.out.println("Listener got EOF from server: closing");
                running = false;
                applet.cleanUp();
                return;
            }

            String roundTripPrompt = "";
            if (applet.showRoundTripCheck.getState()) {
                Date date = new Date();
                int match = line.indexOf("TIMESTAMP myid:"
                        + applet.myId);
                if (line.indexOf("TIMESTAMP myid:"
                        + applet.myId) != -1) {
                    int i = line.indexOf("lineid:");
                    int j = line.indexOf("timesent:");
                    String lineIdString =
                            line.substring(i+"lineid:".length(), j).trim();
                    int lineId = Integer.parseInt(lineIdString);
                    long timeSent = Long.parseLong(
                            line.substring(j+"timesent:".length()));
                    long timeReceived = date.getTime();
                    long roundTrip = timeReceived - timeSent;
                    roundTripPrompt = "[roundtrip: " + roundTrip + " ms] ";
                }
            }

            // Show timestamp lines only on request,
            // but show other lines all the time.
            //
            // NB: do not confuse "timestamp lines" with "roundtrip prompt"
            // because they are different! The timestamp line comes in from
            // the server, while the roundtrip prompt is generated locally.
            // A timestamp line plus a message line take 2 passes round the loop:
            // after each pass, the roundTripPrompt is printed, but it will
            // be empty unless the line of the previous pass was a timestamp.
            if (applet.showTimestampsCheck.getState()
                    || (line.indexOf("TIMESTAMP myid:") == -1)) {
                applet.safelyAppendTextToMainWindow (line + "\n");
            }

            applet.safelyAppendTextToMainWindow(roundTripPrompt);

        }
    }
}

