{ Check in form }
unit vckinfrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, shdmem;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Name: TEdit;
    Label2: TLabel;
    Company: TEdit;
    Label3: TLabel;
    Visited: TEdit;
    Label4: TLabel;
    Timefield: TEdit;
    Label5: TLabel;
    Key: TEdit;
    CheckIn: TButton;
    Clear: TButton;
    SharedMemory: TShareMem;  { Shared Memory!}
    procedure ClearClick(Sender: TObject);
    procedure CheckInClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    function GetNewKey : String;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function TForm1.GetNewKey : String;
var
  k : String;
  keynum : Integer;
  code : Integer;
begin
{ Lock shared memory }
  SharedMemory.Lock(INFINITE);
{ Get next key }
  SharedMemory.Rcl(0,k);
{ Convert to number }
  Val(k,keynum,code);
{ Set return value from number (if string is empty
  this ensures a zero return value) }
  result:=IntToStr(keynum);
{ Increment next key value and put back }
  keynum:=keynum+1;
  k:=IntToStr(keynum);
  SharedMemory.Sto(0,k);
  SharedMemory.Unlock;
end;

procedure TForm1.CheckInClick(Sender: TObject);
begin
timefield.Text:=TimeToStr(Time);
key.Text:=GetNewKey;
{ commit to database here }
end;

procedure TForm1.ClearClick(Sender: TObject);
begin
timefield.Text:='';
key.Text:='';
name.Text:='';
company.Text:='';
visited.Text:='';
ActiveControl:=Name;
end;



procedure TForm1.FormCreate(Sender: TObject);
begin
if SharedMemory.NewFile then
  { clear memory }
  SharedMemory.Clear;
end;

end.
