'RGB100.BAS
'
'RGB palette loader 1.00 -- written by Lloyd Chang
'
'required: VGA (Video Graphics Adapter)
'
'purpose: Creates, saves, then loads an RGB palette.
'
'files that should accompany this program: ASTRNAUT.24
'                                          ASTRNAUT.8
'                                          ASTRNAUT.JPG
'                                          BRUN45.EXE
'                                          FILE_ID.DIZ
'                                          INDEX.TXT
'                                          RAW100.BAS
'                                          RAW100.EXE
'                                          RGB.PAL
'                                          SEE8-100.BAS
'
DECLARE SUB RGBLoad ()
DECLARE SUB RGBSave ()
SCREEN 13
PRINT "The default palette is in being used."
PRINT
FOR Count% = 0 TO 255
  COLOR Count%
  PRINT CHR$(219);
NEXT Count%
COLOR 15
LOCATE 25, 1
PRINT "Press any key to continue";
SLEEP
LOCATE 11, 1
PRINT "256 Colors RGB Palette has been created."
PRINT
RGBSave
PRINT
PRINT
PRINT "256 Colors RGB Palette has been saved."
SLEEP
LOCATE (CSRLIN - 5)
PRINT SPACE$(40)
PRINT
PRINT SPACE$(38)
PRINT
PRINT SPACE$(38)
LOCATE 1, 1
COLOR 255
PRINT "The RGB palette is being loaded." + SPACE$(5)
RGBLoad

SUB RGBLoad
DEFINT A-Z
RGBFile% = FREEFILE
OPEN "RGB.PAL" FOR BINARY AS #RGBFile%
RGBPalette$ = SPACE$(768)
GET #RGBFile%, , RGBPalette$
CLOSE #RGBFile%
DIM RGBPal(0 TO 255) AS LONG
FOR Count% = 0 TO 255
  Red% = (ASC(MID$(RGBPalette$, ((Count% * 3) + 1), 1)) \ 4)
  Green% = (ASC(MID$(RGBPalette$, ((Count% * 3) + 2), 1)) \ 4)
  Blue% = (ASC(MID$(RGBPalette$, ((Count% * 3) + 3), 1)) \ 4)
  RGBPal(Count%) = (65536 * Blue% + 256 * Green% + Red%)
NEXT Count%
PALETTE USING RGBPal
END SUB

DEFSNG A-Z
SUB RGBSave
DEFINT A-Z
RGBFile% = FREEFILE
OPEN "RGB.PAL" FOR BINARY AS #RGBFile%
PRINT "Saving";
FOR CountA% = 0 TO 1
  FOR CountB% = 0 TO 1
    FOR CountC% = 0 TO 1
      FOR CountD% = 0 TO 1
        FOR CountE% = 0 TO 1
          FOR CountF% = 0 TO 1
            FOR CountG% = 0 TO 1
              FOR CountH% = 0 TO 1
                FirstColor% = 0
                SecondColor% = 0
                ThirdColor% = 0
                PaletteColor% = 0
                SELECT CASE CountH%
                  CASE IS = 1
                    FirstColor% = FirstColor% + (2 ^ 0)
                END SELECT
                SELECT CASE CountG%
                  CASE IS = 1
                    FirstColor% = FirstColor% + (2 ^ 1)
                END SELECT
                SELECT CASE CountF%
                  CASE 1
                    FirstColor% = FirstColor% + (2 ^ 2)
                END SELECT
                SELECT CASE CountE%
                  CASE 1
                    SecondColor% = SecondColor% + (2 ^ 0)
                END SELECT
                SELECT CASE CountD%
                  CASE 1
                    SecondColor% = SecondColor% + (2 ^ 1)
                END SELECT
                SELECT CASE CountC%
                  CASE IS = 1
                    ThirdColor% = ThirdColor% + (2 ^ 0)
                END SELECT
                SELECT CASE CountB%
                  CASE IS = 1
                    ThirdColor% = ThirdColor% + (2 ^ 1)
                END SELECT
                SELECT CASE CountA%
                  CASE 1
                    ThirdColor% = ThirdColor% + (2 ^ 2)
                END SELECT
                Red% = ((ThirdColor% * 8) / (7 * 8) * 63)
                'Switch ThirdColor% above with FirstColor%
                'below for RGB mode.  Otherwise, it is
                'currently in BGR mode.
                Green% = ((SecondColor% * 16) / (3 * 16) * 63)
                Blue% = ((FirstColor% * 8) / (7 * 8) * 63)
                Red$ = CHR$(Red% * 4)
                Green$ = CHR$(Green% * 4)
                Blue$ = CHR$(Blue% * 4)
                PUT #RGBFile%, , Red$
                PUT #RGBFile%, , Green$
                PUT #RGBFile%, , Blue$
                SELECT CASE (((((CountA%) * 128) + ((CountB%) * 64) + ((CountC%) * 32) + ((CountD%) * 16) + ((CountE%) * 8) + ((CountF%) * 4) + ((CountG%) * 2) + CountH%) + 1) MOD 8)
                  CASE 0
                    PRINT ".";
                END SELECT
NEXT CountH%, CountG%, CountF%, CountE%, CountD%, CountC%, CountB%, CountA%
CLOSE #RGBFile%
END SUB

