unit Fifomain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, RChart, StdCtrls, Buttons, ExtCtrls;

type
  TForm1 = class(TForm)
    RChart1: TRChart;
    BButStart: TBitBtn;
    BButStop: TBitBtn;
    BButExit: TBitBtn;
    procedure BButStartClick(Sender: TObject);
    procedure BButStopClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure BButExitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


var
  Abort   : boolean;
  DataCnt : double;

(******************************************************************)
procedure TForm1.BButStartClick(Sender: TObject);
(******************************************************************)

const
  Step = 1.0;


begin
BButExit.Enabled := false;
BButStart.Enabled := false;
BButStop.Enabled := true;
abort := false;
while not abort do
  begin
  Application.Processmessages;
  DataCnt := DataCnt + Step;
  RChart1.DataColor := clblue;
  RChart1.MarkAt (datacnt, sin(0.19*DataCnt)*cos(0.02*DataCnt), 10);
  RChart1.DataColor := clred;
  RChart1.MoveTo (datacnt-1, cos(0.09*(DataCnt-1)));
  RChart1.DrawTo (datacnt, cos(0.09*DataCnt));
  if datacnt > 80 then
    begin
    RChart1.RemoveFirstItem;                  { remove MarkAt }
    RChart1.RemoveFirstItem;                  { remove MoveTo }
    RChart1.RemoveFirstItem;                  { remove DarwTo }
    RChart1.SetRange (RChart1.RangeLoX+Step, RChart1.RangeLoY,
                      RChart1.RangeHiX+Step, RChart1.RangeHiy);
    end;
  RChart1.ShowGraf;
  end;
end;

(******************************************************************)
procedure TForm1.BButStopClick(Sender: TObject);
(******************************************************************)

begin
Abort := true;
BButExit.Enabled := true;
BButStart.Enabled := true;
BButStop.Enabled := false;
end;

(******************************************************************)
procedure TForm1.FormActivate(Sender: TObject);
(******************************************************************)

begin
DataCnt := 0;
end;

(******************************************************************)
procedure TForm1.BButExitClick(Sender: TObject);
(******************************************************************)

begin
close;
end;


end.
