unit MultReg;

interface

Uses MultLang, MDialogs, MButtons;

procedure Register;

implementation

Uses DsgnIntf, Classes, MulAbout, Forms, LangEdit, Messages, SysUtils, Tabs,
     Menus, StdCtrls, ExtCtrls, MCombBox, CompColl, WinProcs;

Type
  {Languages Property Editor}
  TLangTextProperty = Class(TPropertyEditor)
  Public
    Procedure Edit; Override;
    Function GetAttributes: TPropertyAttributes; Override;
    Function GetValue:String; Override;
  End;

  {Language file Property Editor}
  TLangFileProperty = Class(TStringProperty)
  Public
    Procedure Edit; Override;
    Function GetAttributes: TPropertyAttributes; Override;
  End;

  {Default language Property Editor}
  TDefaultLangProperty = Class(TStringProperty)
  Public
    Function GetAttributes: TPropertyAttributes; Override;
    Procedure GetValues(Proc: TGetStrProc); Override;
  End;

  {Language component editor}
  TMultLangEditor = Class(TComponentEditor)
  Public
    Procedure ExecuteVerb(Index:Integer); Override;
    Function GetVerbCount:Integer; Override;
    Function GetVerb(Index:Integer):String; Override;
  End;

  {AdoptOn Property Editor}
  TAdoptOnProperty = Class(TComponentProperty)
  Public
    Procedure GetValues(Proc: TGetStrProc); Override;
  End;

  {About Property Editor}
  TAboutProperty = Class(TPropertyEditor)
  Public
    Procedure Edit; Override;
    Function GetAttributes: TPropertyAttributes; Override;
    Function GetValue:String; Override;
  End;

Procedure TAboutProperty.Edit;
{Invokes the about dialog when clicking on ... in Object Inspector}
Begin
  TMultLang(GetComponent(0)).ShowAbout;
End;

Function TAboutProperty.GetAttributes: TPropertyAttributes;
{Make settings for just displaying a string in the about property in the Object Inspector}
Begin
  GetAttributes := [paDialog, paReadOnly];
End;

Function TAboutProperty.GetValue: String;
{Text in the ObjectInspector for the About property}
Begin
  GetValue := '(Dbl click here ...)';
End;

Type
TComponentCollectorEditor = class(TComponentEditor)
public
  procedure Edit; override;
  procedure ExecuteVerb(Index:Integer); override;
  function GetVerbCount:Integer; override;
  function GetVerb(Index:Integer):string; override;
end;

TAboutProperty2 = class(TPropertyEditor)
public
  procedure Edit; override;
  function GetAttributes: TPropertyAttributes; override;
  function GetValue:string; override;
end;

TUpdateProperty = class(TPropertyEditor)
public
  procedure Edit; override;
  function GetAttributes: TPropertyAttributes; override;
  function GetValue:string; override;
end;

procedure TAboutProperty2.Edit;
{Invokes the about dialog when clicking on ... in Object Inspector}
begin
  TComponentCollector(GetComponent(0)).ShowAbout;
end;

function TAboutProperty2.GetAttributes: TPropertyAttributes;
{Make settings for just displaying a string in the about property in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TAboutProperty2.GetValue: String;
{Text in the ObjectInspector for the About property}
begin
  GetValue := '(About)';
end;

procedure TUpdateProperty.Edit;
{Invokes the about dialog when clicking on ... in Object Inspector}
begin
  TComponentCollector(GetComponent(0)).Collect;
end;

function TUpdateProperty.GetAttributes: TPropertyAttributes;
{Make settings for just displaying a string in the about property in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TUpdateProperty.GetValue: String;
{Text in the ObjectInspector for the About property}
begin
  GetValue := '(Updates ...)';
end;


Procedure Register;
{Register the component to the component palette and all Property Editors}
Begin
  RegisterPropertyEditor(TypeInfo(String), TMultLang, 'About', TAboutProperty);
  RegisterPropertyEditor(TypeInfo(TList), TMultLang, 'Languages', TLangTextProperty);
  RegisterPropertyEditor(TypeInfo(String), TMultLang, 'LanguageFile', TLangFileProperty);
  RegisterPropertyEditor(TypeInfo(String), TMultLang, 'DefaultLanguage', TDefaultLangProperty);
  RegisterPropertyEditor(TypeInfo(TComponent), TMultLang, 'AdoptOn', TAdoptOnProperty);
  RegisterPropertyEditor(TypeInfo(String), TComponentCollector, 'About', TAboutProperty2);
  RegisterPropertyEditor(TypeInfo(TStrings), TComponentCollector, 'OwnedComponents', TUpdateProperty);
  RegisterComponents('Multi Lingual', [TMultLang, TMOpenDialog, TMSaveDialog, TMPrintDialog,
     TMPrinterSetupDialog, TMFindDialog, TMReplaceDialog, TMFontDialog, TMColorDialog,
     TMButtons, TMComboBox, TComponentCollector]);
  RegisterComponentEditor(TMultLang, TMultLangEditor);
  RegisterComponentEditor(TComponentCollector, TComponentCollectorEditor);
End;

Procedure TMultLangEditor.ExecuteVerb(Index:Integer);
{When right click on the component at design-time}
Var OrgHlpFile:String;
Begin
  Case Index Of
    0 : TMultLang(Component).ShowAbout;
    1 : Begin
        OrgHlpFile:=Application.HelpFile;
        Application.HelpFile:='MULTLANG.HLP';
        Application.HelpContext(10);
        Application.HelpFile:=OrgHlpFile;
        End;
    2 : TMultLang(Component).Edit(Nil);
  End;
End;

Function TMultLangEditor.GetVerb(Index:Integer):String;
{Right Click contents in design-time}
Begin
  Case Index Of
    0 : GetVerb:='About ...'; {This is default to dbl-click}
    1 : GetVerb:='Help Contents';
    2 : GetVerb:='Edit Languages';
  End;
End;

Function TMultLangEditor.GetVerbCount:Integer;
{Nr of items in Right Click popup at desing-time}
Begin
  GetVerbCount:=3;
End;

Procedure TLangTextProperty.Edit;
{When clicking on ... in Object Inspector}
Begin
  TMultLang(GetComponent(0)).Edit(Nil);
End;

Function TLangTextProperty.GetAttributes: TPropertyAttributes;
{Makes the property equal as TStrings}
Begin
  GetAttributes := [paDialog, paReadOnly];
End;

Function TLangTextProperty.GetValue:String;
{The name of Languages property in the Object Inspector}
Begin
  GetValue := '(Languages ...)';
End;

Function TLangFileProperty.GetAttributes: TPropertyAttributes;
{LanguageFile property, makes it possible to also bring up the Open dialog}
Begin
  GetAttributes := [paDialog];
End;

Procedure TLangFileProperty.Edit;
{Open selected in the LanguageFile property}
Var LangEditForm:TLangEditorForm;
Begin
  LangEditForm:=TLangEditorForm.Create(Nil);
  Try
    LangEditForm.MOpenDialog1.Filter:=LangEditForm.MultLang1.GetString('LoadBtn_Filter');
    LangEditForm.MOpenDialog1.Title:=LangEditForm.MultLang1.GetString('LoadBtn_Title');
    LangEditForm.MOpenDialog1.DefaultExt:='LAN';
    LangEditForm.MOpenDialog1.FileName:=GetStrValue;
    If (LangEditForm.MOpenDialog1.Execute) Then
      If (AnsiUpperCase(GetStrValue)<>AnsiUpperCase(LangEditForm.MOpenDialog1.FileName)) Then
        {TMultLang(GetComponent(0)).SetLanguageFile(LangEditForm.MOpenDialog1.FileName);}
        SetStrValue(LangEditForm.MOpenDialog1.FileName);
  Finally
    LangEditForm.Free;
  End;
End;

Function TDefaultLangProperty.GetAttributes: TPropertyAttributes;
{Make settings for a drop down list of available languages}
Begin
  GetAttributes := [paValueList, paReadOnly];
End;

Procedure TDefaultLangProperty.GetValues(Proc:TGetStrProc);
{Returns the names of the available languages}
Var Index:Integer;
Begin
 For Index:=0 To TMultLang(GetComponent(0)).Languages.Count-1 Do
  If (PLangText(TMultLang(GetComponent(0)).Languages.Items[Index])^.Kind=rkLanguage) Then
    Proc(StrPas(PLangText(TMultLang(GetComponent(0)).Languages.Items[Index])^.Value));
End;

Procedure TAdoptOnProperty.GetValues(Proc:TGetStrProc);
{Returns the names of the available AdoptOn controls}
Var Index:Integer;
Begin
  With Designer.Form Do
    For Index:=0 To ComponentCount-1 Do
      If (Components[Index] is TTabSet) Or (Components[Index] is TMainMenu) Or
         (Components[Index] is TPopupMenu) Or (Components[Index] is TListBox) Or
         (Components[Index] is TComboBox) Or (Components[Index] is TRadioGroup) Or
         (Components[Index] is TMenuItem) Then
        Proc(Components[Index].Name);
End;


procedure TComponentCollectorEditor.Edit;
{When double clicking on the component at design-time}
begin
  TComponentCollector(Component).SelectComponent(TComponentCollector(Component).GetComponentName(0, 2));
end;

procedure TComponentCollectorEditor.ExecuteVerb(Index:Integer);
{When right click on the component at design-time}
var Place:Longint; Adjust:Integer;
begin
  Place:=Component.DesignInfo;
  Adjust:=0;
  if (TComponentCollector(Component).GetPageIndex>0) then Adjust:=1;
  with TComponentCollector(Component) do
    if (MaxPopupItems<>0) and (Index=MaxPopupItems+Adjust) then
      begin
      SetPageIndex(GetPageIndex+1);
      PostMessage(GetActiveWindow, WM_LBUTTONUP, 1, 0);
      PostMessage(GetActiveWindow, WM_RBUTTONDOWN, Integer(LongRec(Place).Hi), Integer(LongRec(Place).Lo));
      end
    else if (MaxPopupItems<>0) and (Index=0) and (Adjust>0) then
      begin
      SetPageIndex(GetPageIndex-1);
      PostMessage(GetActiveWindow, WM_LBUTTONUP, 1, 0);
      PostMessage(GetActiveWindow, WM_RBUTTONDOWN, Integer(LongRec(Place).Hi), Integer(LongRec(Place).Lo));
      end
    else
      begin
      Index:=Index+(GetPageIndex * MaxPopupItems)-Adjust;
      SelectComponent(GetComponentName(Index, 1));
      PostMessage(GetActiveWindow, WM_LBUTTONUP, 1, 0);
      end;
end;

function TComponentCollectorEditor.GetVerb(Index:Integer):String;
{Right Click contents in design-time}
var Adjust:Integer;
begin
  with TComponentCollector(Component) do
    begin
    Adjust:=0;
    if (GetPageIndex>0) then Adjust:=1;
    if (Adjust>0) and (Index=0) then
      Result:='/\/\ PREVIOUS POPUP LIST /\/\'
    else if (MaxPopupItems<>0) and (MaxPopupItems+Adjust=Index) then
      Result:='\/\/ NEXT POPUP LIST \/\/'
    else
      begin
      if (Adjust>0) then
        Index:=Index+(MaxPopupItems * GetPageIndex)-1;
      Result:=TComponentCollector(Component).GetComponentName(Index, 0);
      end;
    end;
end;

function TComponentCollectorEditor.GetVerbCount:Integer;
{Nr of items in Right Click popup at desing-time}
begin
  Result:=TComponentCollector(Component).GetCount;
  with TComponentCollector(Component) do
    if (MaxPopupItems<>0) then
      begin
      Result:=Result-(MaxPopupItems * GetPageIndex);
      if (Result>MaxPopupItems) then Result:=MaxPopupItems+1;
      if (GetPageIndex>0) then Inc(Result);
      end;
end;

end.
