Attribute VB_Name = "MCDSK_32_DEF"
Option Explicit

' file

'  definition for error type for ISFileNameVALID
Public Const IFV_ERROR = 0
Public Const IFV_NAME_TOO_LONG = 1
Public Const IFV_EXT_TOO_LONG = 2
Public Const IFV_TOO_MANY_BACKSLASH = 3
Public Const IFV_BAD_DRIVE_LETTER = 4
Public Const IFV_BAD_COLON_POS = 5
Public Const IFV_EXT_WITHOUT_NAME = 6

' definition for sFile attributes
Public Const A_RDONLY = &H1             'Read only file
Public Const A_HIDDEN = &H2             'Hidden file
Public Const A_SYSTEM = &H4             'System file
Public Const A_SUBDIR = &H10            'Subdirectory
Public Const A_ARCHIVE = &H20           'Archive file
Public Const A_NORMAL = &H80            'Normal sFile - No read/write restrictions
Public Const A_COMPRESSED = &H800       'Compressed file
Public Const A_NORMAL_ARCHIVE = &HFE    'Normal, Archive
Public Const A_ALL = &HFF               'Normal, Archive, Read-Only, Hidden, System

' definition for drive type
Public Const DRIVE_UNKNOWN = 0
Public Const DRIVE_NO_ROOT_DIR = 1
Public Const DRIVE_REMOVABLE = 2
Public Const DRIVE_FIXED = 3
Public Const DRIVE_REMOTE = 4
Public Const DRIVE_CDROM = 5
Public Const DRIVE_RAMDISK = 6

'  definition for sFile sort
Public Const SORT_ASCENDING = 1
Public Const SORT_DESCENDING = 2
Public Const SORT_CASE_SENSITIVE = 4
Public Const SORT_CASE_INSENSITIVE = 8

' definition for sFile I/O
Public Const EOFILE = -1
Public Const SEEK_CUR = 1
Public Const SEEK_END = 2
Public Const SEEK_SET = 0

' definition for sFile uucp
Public Const MODE_UUENCODE = 0
Public Const MODE_UUDECODE = 1

'  structure for sFile attributes
Type FileAttributeType
   ErrNo             As Integer
   Archive           As Integer
   Hidden            As Integer
   Normal            As Integer
   ReadOnly          As Integer
   SubDir            As Integer
   System            As Integer
   Compressed        As Integer
End Type

'  structure for split path
Type tagSPLITPATH
   nDrive            As String
   nDir              As String
   nName             As String
   nExt              As String
End Type

Declare Function cAllSubDirectories Lib "mcdsk-32.dll" (ByVal lpBaseDirectory As String, nDir As Long) As String
Declare Function cChDir Lib "mcdsk-32.dll" (ByVal lpDir As String) As Integer
Declare Function cChDrive Lib "mcdsk-32.dll" (ByVal lpDrive As String) As Integer
Declare Function cCmpFileAttribute Lib "mcdsk-32.dll" (ByVal File1 As String, ByVal File2 As String) As Integer
Declare Function cCmpFileContents Lib "mcdsk-32.dll" (ByVal File1 As String, ByVal File2 As String, ByVal Sensitivity As Integer) As Integer
Declare Function cCmpFileSize Lib "mcdsk-32.dll" (ByVal File1 As String, ByVal File2 As String) As Integer
Declare Function cCmpFileTime Lib "mcdsk-32.dll" (ByVal File1 As String, ByVal File2 As String) As Integer
Declare Function cCountDirectories Lib "mcdsk-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cCountFiles Lib "mcdsk-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cFileSize Lib "mcdsk-32.dll" (ByVal lpFilename As String) As Long
Declare Function cIsFilenameValid Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileArchive Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileEmpty Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileFlag Lib "mcdsk-32.dll" (ByVal nFilename As String, ByVal nStatus As Integer) As Integer
Declare Function cIsFileHidden Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileNormal Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileReadOnly Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileSubDir Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileSystem Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileCompressed Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cKillDir Lib "mcdsk-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cKillDirFilesAll Lib "mcdsk-32.dll" (ByVal lpDir As String, ByVal lpMask As String) As Integer
Declare Function cKillDirs Lib "mcdsk-32.dll" (ByVal lpDir As String, ByVal HeaderDirectory As Integer) As Integer
Declare Function cKillFile Lib "mcdsk-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cKillFileAll Lib "mcdsk-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cKillFiles Lib "mcdsk-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cKillFilesAll Lib "mcdsk-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cMakeDir Lib "mcdsk-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cMakeMultipleDir Lib "mcdsk-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cFileResetAllAttrib Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cFileResetArchive Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cFileResetFlag Lib "mcdsk-32.dll" (ByVal nFilename As String, ByVal nStatus As Integer) As Integer
Declare Function cFileResetHidden Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cFileResetReadOnly Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cFileResetSystem Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSetAllAttrib Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSetArchive Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSetAttrib Lib "mcdsk-32.dll" (ByVal nFilename As String, nFileAttribute As Any) As Integer
Declare Function cFileSetFlag Lib "mcdsk-32.dll" (ByVal nFilename As String, ByVal nStatus As Integer) As Integer
Declare Function cFileSetHidden Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSetReadOnly Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSetSystem Lib "mcdsk-32.dll" (ByVal nFilename As String) As Integer
Declare Function cUniqueFileName Lib "mcdsk-32.dll" (Txt As String) As String
Declare Function cFileCopy Lib "mcdsk-32.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cFileCopy2 Lib "mcdsk-32.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cFileDrive Lib "mcdsk-32.dll" (ByVal lpFilename As String) As String
Declare Function cFileGetAttrib Lib "mcdsk-32.dll" (ByVal nFilename As String, nFileAttribute As Any) As Integer
Declare Function cFileMove Lib "mcdsk-32.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cFilePathExists Lib "mcdsk-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cFilesSize Lib "mcdsk-32.dll" (ByVal nFilename As String) As Long
Declare Function cFilesSizeOnDisk Lib "mcdsk-32.dll" (ByVal nFilename As String) As Long
Declare Function cFilesSlack Lib "mcdsk-32.dll" (ByVal nFilename As String, Size1 As Long, Size2 As Long) As Integer
Declare Function cGetDiskClusterSize Lib "mcdsk-32.dll" (ByVal lpDrive As String) As Long
Declare Function cGetDiskFree Lib "mcdsk-32.dll" (ByVal lpDrive As String) As Long
Declare Function cGetDiskSpace Lib "mcdsk-32.dll" (ByVal lpDrive As String) As Long
Declare Function cGetDiskUsed Lib "mcdsk-32.dll" (ByVal lpDrive As String) As Long
Declare Function cRcsCountFileDir Lib "mcdsk-32.dll" (ByVal FileOrDir As Integer, ByVal FirstFileOrDir As String, ByVal MaskDir As String, ByVal Recurse As Integer) As Integer
Declare Function cRcsFilesSize Lib "mcdsk-32.dll" (ByVal FirstDir As String, ByVal MaskDir As String, ByVal Recurse As Integer) As Long
Declare Function cRcsFilesSizeOnDisk Lib "mcdsk-32.dll" (ByVal FirstDir As String, ByVal MaskDir As String, ByVal Recurse As Integer) As Long
Declare Function cRcsFilesSlack Lib "mcdsk-32.dll" (ByVal FirstDir As String, ByVal MaskDir As String, ByVal Recurse As Integer, Size1 As Long, Size2 As Long) As Integer
Declare Function cSubDirectory Lib "mcdsk-32.dll" (ByVal nFilename As String, ByVal FirstNext As Integer) As String
Declare Function cFileChangeChars Lib "mcdsk-32.dll" (ByVal nFilename As String, CharSet As String, NewCharSet As String, ByVal nFileTemp As String) As Long
Declare Function cFileCompressTab Lib "mcdsk-32.dll" (ByVal File1 As String, ByVal File2 As String, ByVal nTab As Long) As Long
Declare Function cFileExpandTab Lib "mcdsk-32.dll" (ByVal File1 As String, ByVal File2 As String, ByVal nTab As Long) As Long
Declare Function cFileFilter Lib "mcdsk-32.dll" (ByVal File1 As String, ByVal File2 As String, Filter As String) As Long
Declare Function cFileFilterNot Lib "mcdsk-32.dll" (ByVal File1 As String, ByVal File2 As String, Filter As String) As Long
Declare Function cFileLineCount Lib "mcdsk-32.dll" (ByVal lpFilename As String) As Long
Declare Function cFileMerge Lib "mcdsk-32.dll" (ByVal File1 As String, ByVal File2 As String, ByVal fileTo As String) As Long
Declare Function cFileSearch Lib "mcdsk-32.dll" (ByVal nFilename As String, ByVal Search As String, ByVal Sensitivity As Integer) As Long
Declare Function cFileSearchAndReplace Lib "mcdsk-32.dll" (ByVal nFilename As String, ByVal Search As String, ByVal Replace As String, ByVal nFileTemp As String, ByVal Sensitivity As Integer) As Long
Declare Function cFileSearchCount Lib "mcdsk-32.dll" (ByVal nFilename As String, ByVal Search As String, ByVal Sensitivity As Integer) As Long
Declare Function cFileToUpper Lib "mcdsk-32.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cFileToLower Lib "mcdsk-32.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cTruncatePath Lib "mcdsk-32.dll" (ByVal nFilename As String, ByVal NewLength As Long) As String
Declare Function cFullPath Lib "mcdsk-32.dll" (ByVal nFilename As String) As String
Declare Function cMakePath Lib "mcdsk-32.dll" (ByVal nDrive As String, ByVal nDir As String, ByVal nFilename As String, ByVal Ext As String) As String
Declare Function cSplitPath Lib "mcdsk-32.dll" (ByVal nFilename As String, SPLITPATH As Any) As Integer
Declare Function cFileDateCreated Lib "mcdsk-32.dll" (ByVal lpFilename As String) As String
Declare Function cFileLastDateAccess Lib "mcdsk-32.dll" (ByVal lpFilename As String) As String
Declare Function cFileLastDateModified Lib "mcdsk-32.dll" (ByVal lpFilename As String) As String
Declare Function cFileTimeCreated Lib "mcdsk-32.dll" (ByVal lpFilename As String) As String
Declare Function cFileLastTimeAccess Lib "mcdsk-32.dll" (ByVal lpFilename As String) As String
Declare Function cFileLastTimeModified Lib "mcdsk-32.dll" (ByVal lpFilename As String) As String
Declare Function cGetDriveType Lib "mcdsk-32.dll" (ByVal lpDrive As String) As Integer
Declare Function cFileSort Lib "mcdsk-32.dll" (ByVal FileIn As String, ByVal FileOut As String, ByVal SortMethod As Integer, ByVal RecordLength As Long, ByVal KeyOffset As Long, ByVal KeyLength As Long, rRecords As Long) As Long
Declare Function cFileStatistics Lib "mcdsk-32.dll" (ByVal nFilename As String, nLines As Long, nWords As Long, nChars As Long) As Long
Declare Function cFilesInDirectory Lib "mcdsk-32.dll" (ByVal nFilename As String, ByVal FirstNext As Integer) As String
Declare Function cFilesInDirOnDisk Lib "mcdsk-32.dll" (ByVal nFile As String, ByVal nFilename As String, ByVal nAttribute As Integer) As Integer
Declare Function cFilesInDirToArray Lib "mcdsk-32.dll" (ByVal nFilename As String, ByVal nAttribute As Integer, array() As String) As Integer
Declare Function cRenameFile Lib "mcdsk-32.dll" (ByVal lpFilename1 As String, ByVal lpFilename2 As String) As Integer
Declare Function cSearchFile Lib "mcdsk-32.dll" (ByVal lpStartPath As String, ByVal lpFileMask As String, ByVal lpFileResult As String) As Long
Declare Function cFileUUCP Lib "mcdsk-32.dll" (ByVal lpFilename1 As String, ByVal lpFilename2 As String, ByVal EncodeDecode As Integer) As Long

