package codegen;
import java.io.*;
import codegen.*;

public class Field {
  byte[] name;  /* Utf8 */
  public Type type;
  int name_index; /* Index in constant table, or 0 if un-assigned */
  int signature_index; /* Index in constant table, or 0 if un-assigned */
  int constant_value_index; /* If non-0, cpool index of constant value. */
  int flags;
  Field next;

  public final byte[] getSignature () { return type.getSignature (); }

  /** The class that contains this field. */
  ClassType owner;

  /** Add a new Field to a ClassType. */
  public Field (ClassType ctype)
  {
    if (ctype.last_field == null)
      ctype.fields = this;
    else
      ctype.last_field.next = this;
    ctype.last_field = this;
    ctype.fields_count++;
    owner = ctype;
  }

  void write (DataOutputStream dstr, ClassType classfile)
       throws java.io.IOException
  {
    short attributes_count = constant_value_index > 0 ? (short)1 : (short)0;
    dstr.writeShort (flags);
    dstr.writeShort (name_index);
    dstr.writeShort (signature_index);
    dstr.writeShort (attributes_count);
    if (constant_value_index > 0) {
      dstr.writeShort (classfile.ConstantValue_name_index);
      dstr.writeInt (2);  // attribute_length
      dstr.writeShort (constant_value_index);
    }
  }
  
  void assign_constants (ClassType classfile) {
    if (name_index == 0 && name != null)
      name_index = classfile.get_utf8_const (name);
    if (signature_index == 0 && type != null)
      signature_index = classfile.get_utf8_const (type.signature);
    if (constant_value_index > 0 && classfile.ConstantValue_name_index == 0)
      classfile.ConstantValue_name_index
	= classfile.get_utf8_const ("ConstantValue");
  }

  public String strName ()
  {
    // FIXME - only works for ASCII names!
    return name == null ? null : new String (name, 0);
  }
}
