//FNUM.H - advanced C++ number handling functions.
/*
started 04/30/96 by Richard Springstead.  copyright waived.
The purpose of the iofnum functions is the integration of advanced number storing
functions with the iofstream group.
06/25/96 - during a sudden brainstorm I envisioned a way to standardize the functions
all into a single class called FNUM, which also allowed me to place all functions
into the class description as inlines! I was most impressed with myself.
To use these functions I suggest declaring a global FNUM class at the begining of the source file
and from there it is simple.
(i.e
#include "fstream.h"
#include "iofnum.h"

FNUM Number;
void main(void) {
	int n = 5;    // this being the desired integer to write to disk
	ofstream output;  //C++ V2.0 stream class
	output. open("filename.ext", ios::binary); // opens in binary mode (or should).
	Number.out(n, output); // calls the overloaded FNUM class function out
	output.close();        // close the file (should also flush the buffer.
	ifstream input;        // establish an input stream.
	input.open("filename.ext", ios::binary); // connect input stream to a file.
	Number.in(n, input); // call overloaded FNUM in function.
	input.close(); // close the file steam (and should flush buffer).

}

)
the out and in are overloaded to handle all standard data types.
I may add a string in/out later (which I have).  I should be easy to add
any desired datatype not listed.

the advantages of FNUM:
	FNUM uses what I call "memory image" storage of numeric variables, often reducing the space
required to store those values as compared to ascii in most situations, and eliminates the
need to convert the complex numbers to and from ascii.
	All the functions should prove to be reasonably fast and consume very
little memory.

and the disadvantages of FNUM:
	The biggest being that these functions DO NOT CHECK for file errors, you'll have to
either do these seperately, or if you design a standard error checking routine,
it should be a simple thing to have eash function call it.
	Files written/read in text mode may cause problems due to the
newline/carriage return character striking.
this can be prevented by openning the stream in binary mode -
ofstream output;
output.open("filename.ext", ios::binary);
- like so.


7/18/96 - At this point I have decided to add a few special additions
	basically the get/put for Null Terminated strings.
*/

typedef unsigned char BYTE;

class FNUM {
	char far *address;

	public:
void out(char c, ofstream far& output) { output.put(c); }
void out(unsigned char c, ofstream far & output) {output.put(c);}
void out(int n, ofstream far& output) { address = (char *)&n; output << address[0] << address[1];}
void out(unsigned int un, ofstream far& output) { address = (char *)&un; output << address[0] << address[1]; }
void out(long ln, ofstream far& output) { address = (char *)&ln; output << address[0] << address[1] << address[2] << address[3]; }
void out(unsigned long uln, ofstream far& output) { address = (char *)&uln; output << address[0] << address[1] << address[2] << address[3]; }
void out(float fl, ofstream far& output) { address = (char *)&fl; output << address[0] << address[1] << address[2] << address[3]; }
void out(double dn, ofstream far& output) { address = (char *)&dn; output << address[0] << address[1] << address[2] << address[3] << address[4] << address[5] << address[6] << address[7]; }
void out(char far *nzascii, ofstream far& output) { output << nzascii << endl;}

void in(char c, ifstream far& input) { input.get(c); }
void in(unsigned char c, ifstream far& input) {input.get(c); }
void in(int  n,ifstream far& input) { address = (char *)&n; input >> address[0] >> address[1]; }
void in(unsigned int un, ifstream far& input) { address = (char *)&un; input >> address[0] >> address[1]; }
void in(long ln, ifstream far& input) { address = (char *)&ln; input >> address[0] >> address[1] >> address[2] >> address[3]; }
void in(unsigned long uln, ifstream far& input) { address = (char *)&uln; input >> address[0] >> address[1] >> address[2] >> address[3]; }
void in(double dn, ifstream far& input) { address = (char *)&dn; input >> address[0] >> address[1] >> address[2] >> address[3]; }
void in(float fl, ifstream far& input) { address = (char *)&fl; input >> address[0] >> address[1] >> address[2] >> address[3] >> address[4] >> address[5] >> address[6] >> address[7]; }
void in(char far *nzascii, int len, char delim = '\n', ifstream far& input) { input.get(nzascii, len, delim); }
};

/*  FNUM author's final notes -
FNUM is presented to you as is and free of charge, basically because I feel
that what it contains is not above any programmer's capability (it's that
simple) and that it may prove an interresting learming tool into the
bizzare mysteries of C plus plus programming.  I have been studying C++
for almost a year now, and I am still in awe of the language.

The functions presented here may be used as desired, with neither remitance
nor credit being required by the author (me, Richard Springstead) who also
will not accept any liability for any damage caused, consiquential or otherwise,
by the use or inclusion of these functions, in other words, use at your own risk!

I present FNUM to the programming world at large as a message in a bottle,
hoping that in the great vastness of our world another will see and respond.
If you wish to send me any comments, idea, critiques (no abuse, please),
or just a friendly how-do I can be contacted in the following ways.

E-mail:
richard.springstead@dconline.org

or
US MAIL:
Richard Springstead
142 S. Jefferson St.
Coldwater, MI 49036