/**************************************************************************

   File:          DialTest.c
   
**************************************************************************/

#define STRICT

/**************************************************************************
   Include Files
**************************************************************************/

#include <windows.h>
#include <windowsx.h>
#include "resource.h"
#include "DialUp.h"

/**************************************************************************
   Local Function Prototypes
**************************************************************************/

BOOL CALLBACK ModalDlgProc(HWND, UINT, WPARAM, LPARAM);
BOOL EnumProc(LPCTSTR, LPARAM);
void CenterWindow(HWND);

/**************************************************************************
   Global Variables
**************************************************************************/

HINSTANCE   g_hInst;

/**************************************************************************

   WinMain()

**************************************************************************/

int PASCAL WinMain(  HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR lpCmdLine,
                     int nCmdShow)
{
OSVERSIONINFO  os;

os.dwOSVersionInfoSize = sizeof(os);
GetVersionEx(&os);
if(os.dwMajorVersion < 4)
   {
   MessageBox(NULL, "This application will only run on Windows 95 or Windows NT 4.0 or greater", "Error", MB_OK | MB_ICONINFORMATION);
   return 1;
   }

g_hInst = hInstance;

DialogBox(g_hInst, MAKEINTRESOURCE(IDD_MAIN_DIALOG), NULL, ModalDlgProc);

return 1;
}

/*****************************************************************************

   ModalDlgProc

*****************************************************************************/

BOOL CALLBACK ModalDlgProc(   HWND hWnd, 
                              UINT uMessage, 
                              WPARAM wParam, 
                              LPARAM lParam)
{
switch (uMessage)
   {
   case WM_INITDIALOG:
      CenterWindow(hWnd);
      
      EnumDialUpConnections(EnumProc, (LPARAM)GetDlgItem(hWnd, IDC_CONNECTION_LIST));

      SendDlgItemMessage(hWnd, IDC_CONNECTION_LIST, LB_SETCURSEL, (WPARAM)-1, 0);
      
      EnableWindow(GetDlgItem(hWnd, IDC_SHORTCUT), FALSE);
      EnableWindow(GetDlgItem(hWnd, IDC_EXECUTE), FALSE);

      return TRUE;
      
   case WM_DESTROY:
      break;
   
   case WM_COMMAND:
      switch(GET_WM_COMMAND_ID(wParam, lParam))
         {
         case IDC_SHORTCUT:
            {
            DWORD dwIndex;

            dwIndex = SendDlgItemMessage(hWnd, IDC_CONNECTION_LIST, LB_GETCURSEL, 0, 0);
            if(dwIndex != LB_ERR)
               {
               TCHAR szItemName[MAX_PATH];
               TCHAR szLinkName[MAX_PATH];

               if(LB_ERR != SendDlgItemMessage(hWnd, IDC_CONNECTION_LIST, LB_GETTEXT, dwIndex, (LPARAM)szItemName))
                  {
                  LPITEMIDLIST   pidlDesktop;

                  SHGetSpecialFolderLocation(hWnd, CSIDL_DESKTOP, &pidlDesktop);
                  SHGetPathFromIDList(pidlDesktop, szLinkName);
                  lstrcat(szLinkName, "\\Shortcut to ");
                  lstrcat(szLinkName, szItemName);
                  
                  CreateDialUpLink(szItemName, szLinkName);
                  }
               }
            }
            return FALSE;

         case IDC_EXECUTE:
            {
            DWORD dwIndex;

            dwIndex = SendDlgItemMessage(hWnd, IDC_CONNECTION_LIST, LB_GETCURSEL, 0, 0);
            if(dwIndex != LB_ERR)
               {
               TCHAR szItemName[MAX_PATH];

               if(LB_ERR != SendDlgItemMessage(hWnd, IDC_CONNECTION_LIST, LB_GETTEXT, dwIndex, (LPARAM)szItemName))
                  {
                  ExecuteDialUpConnection(szItemName);
                  }
               }
            }
            return FALSE;

         case IDC_MAKE:
            {
            ExecuteNewConnection();
            }
            return FALSE;

         case IDC_CONNECTION_LIST:
            switch(GET_WM_COMMAND_CMD(wParam, lParam))
               {
               case LBN_SELCHANGE:
                  if(LB_ERR == SendDlgItemMessage(hWnd, IDC_CONNECTION_LIST, LB_GETCURSEL, 0, 0))
                     {
                     EnableWindow(GetDlgItem(hWnd, IDC_SHORTCUT), FALSE);
                     EnableWindow(GetDlgItem(hWnd, IDC_EXECUTE), FALSE);
                     }
                  else
                     {
                     EnableWindow(GetDlgItem(hWnd, IDC_SHORTCUT), TRUE);
                     EnableWindow(GetDlgItem(hWnd, IDC_EXECUTE), TRUE);
                     }
                  break;
               }
            return FALSE;
         
         case IDCANCEL:
         case IDOK:
            EndDialog(hWnd, IDOK);
            break;
         }
      return FALSE;
    } 
    
return FALSE;
}

/*****************************************************************************

   EnumProc

*****************************************************************************/

BOOL EnumProc(LPCTSTR lpszConnectionName, LPARAM lParam)
{
HWND  hwndList = (HWND)lParam;

SendMessage(hwndList, LB_ADDSTRING, 0, (LPARAM)lpszConnectionName);

return TRUE;
}

/*****************************************************************************

   CenterWindow

*****************************************************************************/

void CenterWindow(HWND hWnd)
{
RECT  rc;
int   x,
      y;

GetWindowRect(hWnd, &rc);

x = GetSystemMetrics(SM_CXSCREEN)/2 - ((rc.right - rc.left)/2);
y = GetSystemMetrics(SM_CYSCREEN)/2 - ((rc.bottom - rc.top)/2);

//don't move the window if it's already in the right position
if((x != rc.left) || (y != rc.top))
   MoveWindow(hWnd, x, y, rc.right - rc.left, rc.bottom - rc.top, TRUE);
}

