/** PASCAL to HTML Filter Utility *******/

#include <stdio.h>
#include <string.h>


/* Output chars and convert various
   HTML-specific characters */
void outchar (char ch)
{ switch (ch) {
    case '<'  : printf ("&lt;"); break;
    case '>'  : printf ("&gt;"); break;
    case '&'  : printf ("&amp;"); break;
    case '\"' : printf ("&quot;"); break;
    default   : putchar (ch);
    }
} /* outchar */


void main (void)
{ char line[255+1];
  int i, /* counter for each char in line */
      incomment=0, /* flag to indicate if currently
                      in comment; comment styles: 
                    0=no comment  1={ }  2=(* *) */
      inquote=0; /* flag to indicate if currently in
                    quoted text */

  /* start HTML output; indicate text is
     preformatted and will begin in bold */
  printf ("<pre><b>");

  /* process each line from stdin */
  while (gets(line) != NULL) {

    i = 0;
    /* look at each char on line */
    while (line[i]) {
      if (!incomment && line[i] == '\'')
        if (line[i+1] != '\'')
          /* toggle quote status */
          inquote = !inquote;
        else /* if it is "''", skip first quote
                without checking */
          { outchar(line[i++]); }
      if (!inquote)
        if (!incomment && (line[i] == '{' ||
                   strncmp(line+i,"(*",2) == 0)) {
          /* beginning of comment */
          printf ("</b><i>");
          incomment = (line[i] == '{' ? 1 : 2);
          }
        else if ((incomment == 1 && line[i] == '}') ||
           (incomment == 2 &&
                  strncmp(line+i,"*)",2) == 0)) {
          /* end of comment */
          outchar (line[i++]);
          if (incomment == 2) outchar (line[i++]);
          printf ("</i><b>");
          incomment = 0;
          continue;
          }

      outchar (line[i++]);

      } /* end of line */

    putchar ('\n');
    }  /* end of input */

  /* finish up HTML output */
  printf ("</b></pre>\n");
}
