/* ----------------------------------------------------
 *  Filename:           binfile.h
 *  Summary:            Simple interface class for
 *                      non-stream binary files
 *  Author:             T.W. Nelson
 *  Compiler:           BCC++ 4.0
 *  Compile options:
 *  Start date:         10-Dec-1994
 *  Last update:        15-Jun-1995
 *  Version:            2.00
 *  Notes:
 *
 *  15-Jun-1995 (2.00): Began 2.0 revisions
 *
 *  Source code Copyright (c) 1995 T.W. Nelson.
 *  This source (including derivations thereof) may
 *  be used in any manner provided copyright notice
 *  is displayed appropriately.
 * ------------------------------------------------- */

#if  !defined( __BINFILE_H )
#define __BINFILE_H

#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>

typedef unsigned long ulong;

class BinaryFile    {
    int _fh;
    int _size;      //object size

  public:
    BinaryFile(int sz): _fh(-1), _size(sz) {}
    ~BinaryFile() { Close(); }
    int Fh() const { return _fh;    }

    virtual int Open( const char *fname )
    {
        _fh = open( fname, O_RDWR|O_BINARY );
        return _fh == -1 ? -1 : 0;      //0 if OK
    }

    virtual int Create( const char *fname )
    {
        _fh = open( fname, O_CREAT|O_BINARY,
                           S_IREAD|S_IWRITE );
        return _fh == -1 ? -1 : 0;      //0 if OK
    }

    virtual int ReadPos( ulong pos, void *buf )
    {
        lseek( _fh, pos, SEEK_SET );
        return read( _fh, buf, _size );
    }

    virtual int WritePos( ulong pos, const void *buf )
    {
        lseek( _fh, pos, SEEK_SET );
        return write( _fh, buf, _size );
    }

    virtual int Close()
    {
        return close( _fh );
    }
};
#endif  // EOF
