/* genlist.h
 * Copyright (c) 1995 T.W. Nelson.  Permission
 * is hereby granted to use this code in any
 * manner provided the user display this
 * copyright notice in the source
 */


#if !defined( __GENLIST_H )
#define __GENLIST_H
#include "classlib\dlistimp.h"  /* BCC++ Container */

template <class T,class Alloc>
class TIGenDoubleListIterator;

template <class T,class Alloc>
class TIGenDoubleList    {
    TMIDoubleListImp<T,Alloc> *Lp;
  public:
    friend TIGenDoubleListIterator<T,Alloc>;
    TIGenDoubleList()
        { Lp = new TMIDoubleListImp<T,Alloc>; }
    ~TIGenDoubleList() { delete Lp; }
    int PutHead( T *t ) { return Lp->AddAtHead(t); }
    T *PeekHead() const { return Lp->PeekHead(); }
    T *PeekTail() const { return Lp->PeekTail(); }
    int Unlink( T *t, int del = 0 )
        { return Lp->Detach(t,del); }
    void Flush( int del = 0 ) { Lp->Flush(del); }
};

template <class T,class Alloc>
class TIGenDoubleListIterator {
    TMIDoubleListIteratorImp<T,Alloc> *Itp;
  public:
    TIGenDoubleListIterator
        ( const TIGenDoubleList<T,Alloc> &p )
        { Itp = new TMIDoubleListIteratorImp<T,Alloc>
                                    ( *(p.Lp) );  }
    ~TIGenDoubleListIterator() { delete Itp; }
    void Restart() { Itp->Restart();    }
    T *operator ++ (int)
        { return Itp->operator ++ (1); }
    T *operator ++ ()
        { return Itp->operator ++ (); }
};
#endif  //EOF
