#include <stdio.h>
#include <string.h>

#include "JavaAccessor.h"


/*** Get environment variable ***/
struct Hjava_lang_String
       *JavaAccessor_getEnv(struct HJavaAccessor
                                   *javaObj,
                            struct Hjava_lang_String
                                   *varName)
{
   char *var=makeCString(varName), *value;

   value=getenv(var);
   if (!value)
   {
       SignalError(0,
                   "java/lang/NullPointerException",
                   0);
       return NULL;
   }

   return makeJavaString(value,
                         strlen(value));
}


/*** Delete a local file ***/
long JavaAccessor_deleteFile(struct HJavaAccessor
                                    *javaObj,
                             struct Hjava_lang_String
                                    *fileName)
{
   HJavaAccessor *hJavaAccessor;
   int rc=unlink(makeCString(fileName));
   unhand(javaObj)->delRC=rc;

   hJavaAccessor=(HJavaAccessor *)
        execute_java_constructor(0,
                                 "JavaAccessor",
                                 0,
                                 "()");

   if (hJavaAccessor)
       execute_java_dynamic_method(0,
                                   (HObject *)hJavaAccessor,
                                   "printRC",
                                   "(I)V",
                                   rc);
   else
      printf("Unable to create hJavaAccessor\n");

   return rc;
}

