#ifndef _GLOBALS_H
#define _GLOBALS_H

#ifdef _USEMAP
#include <map.h>
#endif

typedef unsigned int BOOL;
const int FALSE = 0;
const int TRUE = 1;

// record formats
const unsigned int FORMAT1 = 1;
const unsigned int FORMAT2 = 2;
const unsigned int FORMAT3 = 3;

#ifdef _USEMAP
// datatypes
const unsigned int FLOAT = 1;
const unsigned int STRING = 2;

class CKey {
public:
	CKey() {}
	CKey(unsigned int Format, char Prefix) : m_format(Format), m_prefix(Prefix) {}
	~CKey() {}

	int operator=(const CKey& rhs) { m_format = rhs.m_format; m_prefix = rhs.m_prefix; return 1; }
	CKey(const CKey& rhs) { m_format = rhs.m_format; m_prefix = rhs.m_prefix; }

	unsigned int m_format;
	char m_prefix;
};

class less_CKey {
public:
	BOOL operator()(const CKey& K1, const CKey& K2) const
	{
		if (K1.m_format > K2.m_format)
			return TRUE;
		else
		if (K1.m_format < K2.m_format)
			return FALSE;
		else
		if (K1.m_prefix > K2.m_prefix)
			return TRUE;
		else
			return FALSE;
	}
};

class CValue {
public:
	CValue() {}
	CValue(long Offset, unsigned int Datatype) : m_offset(Offset), m_datatype(Datatype) {}
	~CValue() {}

	int operator=(const CValue& rhs) { m_offset = rhs.m_offset; m_datatype = rhs.m_datatype; return 1; }
	CValue(const CValue& rhs) { m_offset = rhs.m_offset; m_datatype = rhs.m_datatype; }

	unsigned int Datatype() { return m_datatype; }

	long m_offset;
	unsigned int m_datatype;
};

typedef map < CKey, CValue, less_CKey > mymap;
typedef pair< CKey, CValue > pair_type;
extern mymap m;
extern mymap::iterator j;
#endif	// #ifdef _USEMAP

const int cDateLen = 8;
const int cDescLen = 30;

typedef struct {
	char Name[21];
	short Format;
	union {
		struct {
			float Amount;
			char Date[cDateLen + 1];
		} sFormat1;
		struct {
			char Date[cDateLen + 1];
			char Desc[cDescLen + 1];
		} sFormat2;
		struct {
			float Amount;
			char Date[cDateLen + 1];
			char Desc[cDescLen + 1];
		} sFormat3;
	};
} sVariantRecord;


#endif	// _GLOBALS_H
