# Microsoft nmake makefile for qlib.
# Thanks to K. B. Williams (Kbwms@aol.com).
#
# This is for large memory model, Microsoft C.
# For NQ = 24, you MUST COPY
#   the file qhead16.h to qhead.h.
#   the file qheadl24.asm to qhead.asm.
# For NQ = 12, you MUST COPY
#   the file qhead12.h to qhead.h.
#   the file qheadl12.asm to qhead.asm.
# You MUST EDIT mconf.h to indicate BIGENDIAN is 0.
# For old linkers, remove the `;' from the link commands.
#
# For small memory model use subm.obj, divn.obj, mulr.obj
# and put LARGEMEM=0.

CC	= cl -AL
CFLAGS	= -nologo -W1 -c
INCS	= qhead16.h
ASM	= masm

#inference rules
.c.obj:
	$(CC) $(CFLAGS) $*.c

.asm.obj:
	$(ASM) $*.asm;		# for new MASM v. 6.10
#	$(ASM) $*.asm/r;	# for older versions

all: qlibl.lib qcalc.exe

qlibl.lib: mtherr.obj qacosh.obj qasin.obj qasinh.obj qatanh.obj\
	   qatn.obj qcbrt.obj qconst.obj qcos.obj qcosh.obj qexp.obj \
	   qexp10.obj qfac.obj qgamma.obj qjn.obj qyn.obj qlog.obj \
	   qlog10.obj qpow.obj qrand.obj qremain.obj qsin.obj \
	   qsinh.obj qsqrt.obj qtan.obj qtanh.obj qfloor.obj \
	   qflti.obj subml.obj divnl.obj mulrl.obj
	del qlibl.lib
	lib /nologo @qlibasml.rsp

mtherr.obj:	mtherr.c    mconf.h   protos.h
qacosh.obj:	qacosh.c    qhead.h   protos.h
qairy.obj:	qairy.c     qhead.h   protos.h
qasin.obj:	qasin.c     qhead.h   protos.h
qasinh.obj:	qasinh.c    qhead.h   protos.h
qatanh.obj:	qatanh.c    qhead.h   protos.h
qatn.obj:	qatn.c      qhead.h   protos.h  mconf.h
qbeta.obj:	qbeta.c     qhead.h   protos.h
qcbrt.obj:	qcbrt.c     qhead.h   protos.h
qcgamma.obj:	qcgamma.c   qhead.h   protos.h
qcmplx.obj:	qcmplx.c    qhead.h    mconf.h    protos.h
qconst.obj:	qconst.c    qhead.h   protos.h
qcos.obj:	qcos.c      qhead.h   protos.h
qcosh.obj:	qcosh.c     qhead.h   protos.h
qdawsn.obj:	qdawsn.c    qhead.h   protos.h
qellie.obj:	qellie.c    qhead.h   protos.h
qellik.obj:	qellik.c    qhead.h   protos.h
qellpe.obj:	qellpe.c    qhead.h   protos.h
qellpj.obj:	qellpj.c    qhead.h   protos.h
qellpk.obj:	qellpk.c    qhead.h   protos.h
qerf.obj:	qerf.c      qhead.h   protos.h
qerfc.obj:	qerfc.c     qhead.h   protos.h
qeuclid.obj:	qeuclid.c   qhead.h   protos.h
qexp.obj:	qexp.c      qhead.h   protos.h
qexp10.obj:	qexp10.c    qhead.h   protos.h
qexp2.obj:	qexp2.c     qhead.h   protos.h
qexpn.obj:	qexpn.c     qhead.h   protos.h
qfac.obj:	qfac.c      qhead.h   protos.h
qfloor.obj:	qfloor.c    qhead.h   protos.h
qflt.obj:	qflt.c      mconf.h    qhead.h    qtens.h    protos.h
qflta.obj:	qflta.c     qhead.h   protos.h
qflti.obj:	qflti.c     mconf.h    qhead.h    qtens.h    protos.h
qfresf.obj:	qfresf.c    qhead.h   protos.h
qgamma.obj:	qgamma.c    qhead.h   protos.h
qhy2f1.obj:	qhy2f1.c    mconf.h    qhead.h    protos.h
qhyp.obj:	qhyp.c      qhead.h   protos.h
qi1.obj:	qi1.c       qhead.h   protos.h
qigam.obj:	qigam.c     qhead.h   protos.h
qigami.obj:	qigami.c    qhead.h   protos.h
qin.obj:	qin.c       qhead.h   protos.h
qincb.obj:	qincb.c     qhead.h   protos.h
qincbi.obj:	qincbi.c    mconf.h    qhead.h    protos.h
qincg.obj:	qincg.c     qhead.h   protos.h
qincgs.obj:	qincgs.c    qhead.h   protos.h
qine.obj:	qine.c      qhead.h   protos.h
qjn.obj:	qjn.c       mconf.h    qhead.h    protos.h
qjypn.obj:	qjypn.c     qhead.h   protos.h
qjyqn.obj:	qjyqn.c     qhead.h   protos.h
qk0.obj:	qk0.c       qhead.h   protos.h
qkn.obj:	qkn.c       mconf.h    qhead.h    protos.h
qkne.obj:	qkne.c      mconf.h    qhead.h    protos.h
qlog.obj:	qlog.c      qhead.h   protos.h
qlog1.obj:	qlog1.c     qhead.h   protos.h
qlog10.obj:	qlog10.c    qhead.h   protos.h
qndtr.obj:	qndtr.c     qhead.h   protos.h
qndtri.obj:	qndtri.c    qhead.h    mconf.h    protos.h
qpow.obj:	qpow.c      qhead.h    mconf.h    protos.h
qprob.obj:	qprob.c     qhead.h   protos.h
qpsi.obj:	qpsi.c      qhead.h   protos.h
qremain.obj:	qremain.c   qhead.h   protos.h
qshici.obj:	qshici.c    qhead.h   protos.h
qsici.obj:	qsici.c     qhead.h   protos.h
qsimq.obj:	qsimq.c     qhead.h   protos.h
qsin.obj:	qsin.c      qhead.h   protos.h
qsindg.obj:	qsindg.c    qhead.h   protos.h
qsinh.obj:	qsinh.c     qhead.h   protos.h
qspenc.obj:	qspenc.c    qhead.h   protos.h
qsqrta.obj:	qsqrta.c    qhead.h    mconf.h    protos.h
qstudt.obj:	qstudt.c    mconf.h    qhead.h    protos.h
qtan.obj:	qtan.c      qhead.h   protos.h
qtanh.obj:	qtanh.c     qhead.h   protos.h
qyn.obj:	qyn.c       qhead.h   protos.h
qzetac.obj:	qzetac.c    qhead.h   protos.h

subml.obj:	subml.asm	qheadl.asm
divnl.obj:	divnl.asm	qheadl.asm
mulrl.obj:	mulrl.asm	qheadl.asm

#support for optional extra functions
EXTRAS	= gamma.obj igami.obj ndtri.obj incbi.obj const.obj polevl.obj\
	  igam.obj incbet.obj
LEXTRA	= gamma igami ndtri incbi const polevl igam incbet

gamma.obj:	gamma.c	    mconf.h	protos.h
igam.obj:	igam.c	    mconf.h	protos.h
igami.obj:	igami.c	    mconf.h	protos.h
ndtri.obj:	ndtri.c	    mconf.h	protos.h
incbet.obj:	incbet.c    mconf.h	protos.h
incbi.obj:	incbi.c	    mconf.h	protos.h
polevl.obj:	polevl.c
qparanoi.obj:	qparanoi.c  qhead.h   protos.h

# See the unix makefile for MOREFUNS=1 dependents.
# At least some of them will fit, if you want them.
qcalc.obj: qcalc.c qcalc.h qhead.h protos.h
	$(CC) $(CFLAGS) -DLARGEMEM=1 -DMOREFUNS=0  qcalc.c

qcalc.exe: qcalc.obj qlibl.lib
	link /nologo /STACK:32000 qcalc,,,qlibl;

# Test the version of arithmetic that is correctly rounded.
# It is much slower than the others, so it would not ordinarily
# be used.  Note that it does not support denormal numbers.
# Get the package ieeetest.zoo for that.

qsqrta.obj:	qsqrta.c  qhead.h  mconf.h  protos.h   protos.h

qflt.obj:	qflt.c mconf.h qhead.h qtens.h protos.h   protos.h
	$(CC) $(CFLAGS) /DSTICKY=1 qflt.c

qflta.obj:	qflta.c	qhead.h   protos.h

