# Unix makefile for cephes math.h functions

CC = gcc
CFLAGS = -O2 -Wall -fno-builtin
AR = ar
RANLIB = ranlib
INCS = mconf.h
AS = as
# Define these for a 68000 or 386 computer, to set the rounding precision.
#SETP = setprec.o
#SETPF = setprec.387
#SETPF = setprec.688

OBJS = acosh.o asin.o asinh.o atan.o atanh.o cbrt.o chbevl.o \
clog.o cmplx.o const.o cosh.o drand.o exp.o exp2.o exp10.o fabs.o \
floor.o log.o log2.o log10.o polevl.o pow.o powi.o round.o sin.o \
sindg.o sinh.o tan.o tandg.o tanh.o unity.o sqrt.o mtherr.o $(SETP)

all: libmd.a mtst

mtst: mtst.o libmd.a
	$(CC) $(CFLAGS) -o mtst mtst.o libmd.a
#	coff2exe mtst

libmd.a: $(OBJS) $(INCS)
	$(AR) rv libmd.a $(OBJS)
	$(RANLIB) libmd.a

setprec.o: $(SETPF)
	$(AS) -o setprec.o $(SETPF)
