// Copyright 1995 by Jon Dart.  All Rights Reserved.
// srclimit.cpp : implementation file
//

#include "stdafx.h"
#include "arasan.h"
#include "srclimit.h"
#include "searchop.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// SearchLimitPage property page

IMPLEMENT_DYNCREATE(SearchLimitPage, CPropertyPage)

SearchLimitPage::SearchLimitPage() : CPropertyPage(SearchLimitPage::IDD)
{
	//{{AFX_DATA_INIT(SearchLimitPage)
	m_SearchType = -1;
	m_PlyOrMoves = _T("");
	m_Time = _T("");
	//}}AFX_DATA_INIT
}

SearchLimitPage::~SearchLimitPage()
{
}

BOOL SearchLimitPage::OnInitDialog()
{
    CPropertyPage::OnInitDialog();
    new_type(m_SearchType);
    return FALSE;
}

void SearchLimitPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(SearchLimitPage)
	DDX_Control(pDX, IDD_TIME_TEXT, m_TimeText);
	DDX_Control(pDX, IDD_PLY_TEXT, m_PlyOrMovesText);
	DDX_Control(pDX, IDD_PLY_EDIT, m_PlyOrMovesEdit);
	DDX_Control(pDX, IDD_TIME_EDIT, m_TimeEdit);
	DDX_Radio(pDX, IDD_FIXED_PLY, m_SearchType);
	DDX_Text(pDX, IDD_PLY_EDIT, m_PlyOrMoves);
	DDX_Text(pDX, IDD_TIME_EDIT, m_Time);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(SearchLimitPage, CPropertyPage)
	//{{AFX_MSG_MAP(SearchLimitPage)
		// NOTE: the ClassWizard will add message map macros here
        ON_BN_CLICKED(IDD_FIXED_PLY, OnFixedPly)
        ON_BN_CLICKED(IDD_FIXED_TIME, OnFixedTime)
        ON_BN_CLICKED(IDD_GAME_LIMIT, OnGameLimit)
        ON_BN_CLICKED(IDD_TOURNAMENT, OnTournament)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// SearchLimitPage message handlers

void SearchLimitPage::new_type(int srctype)
{
   ASSERT(srctype < 4);
   switch (srctype)
   {
     case 0:
       m_PlyOrMovesText.SetWindowText("Ply:");
       m_TimeText.ShowWindow(SW_HIDE);
       m_TimeEdit.ShowWindow(SW_HIDE);
       m_TimeText.EnableWindow(FALSE);
//       m_2ndaryButton.EnableWindow(FALSE);
       break;
    case 1:
       m_PlyOrMovesText.SetWindowText("Ply:");
       m_TimeText.ShowWindow(SW_HIDE);
       m_TimeEdit.ShowWindow(SW_HIDE);
       m_TimeText.EnableWindow(FALSE);
       m_PlyOrMovesText.SetWindowText("Seconds/Move:");
//       m_2ndaryButton.EnableWindow(FALSE);
       break;
    case 2:
       m_PlyOrMovesText.SetWindowText("Ply:");
       m_TimeText.ShowWindow(SW_HIDE);
       m_TimeEdit.ShowWindow(SW_HIDE);
       m_PlyOrMovesText.SetWindowText("Minutes/Game:");
       m_TimeText.EnableWindow(FALSE);
//       m_2ndaryButton.EnableWindow(FALSE);
       break;
    case 3:
       m_TimeText.ShowWindow(SW_SHOW);
       m_TimeEdit.ShowWindow(SW_SHOW);
       m_PlyOrMovesText.SetWindowText("Moves:");
       m_TimeText.SetWindowText("Minutes:");
       m_TimeText.EnableWindow(TRUE);
//       m_2ndaryButton.EnableWindow(TRUE);
       break;
    }
}

/////////////////////////////////////////////////////////////////////////////
// SearchLimitPage message handlers

void SearchLimitPage::OnFixedPly()
{
        new_type(0);
}

void SearchLimitPage::OnFixedTime()
{
        new_type(1);    
}

void SearchLimitPage::OnGameLimit()
{
        new_type(2);    
}

void SearchLimitPage::OnTournament()
{
        new_type(3);
}

