// Copyright 1994 by Jon Dart.  All Rights Reserved.

#include "stdafx.h"
#include "square.h"

const int Square::Files[64] =
{
   1, 2, 3, 4, 5, 6, 7, 8,
   1, 2, 3, 4, 5, 6, 7, 8,
   1, 2, 3, 4, 5, 6, 7, 8,
   1, 2, 3, 4, 5, 6, 7, 8,
   1, 2, 3, 4, 5, 6, 7, 8,
   1, 2, 3, 4, 5, 6, 7, 8,
   1, 2, 3, 4, 5, 6, 7, 8,
   1, 2, 3, 4, 5, 6, 7, 8
};

const int Square::Ranks[64] =
{
   1, 1, 1, 1, 1, 1, 1, 1,
   2, 2, 2, 2, 2, 2, 2, 2,
   3, 3, 3, 3, 3, 3, 3, 3,
   4, 4, 4, 4, 4, 4, 4, 4,
   5, 5, 5, 5, 5, 5, 5, 5,
   6, 6, 6, 6, 6, 6, 6, 6,
   7, 7, 7, 7, 7, 7, 7, 7,
   8, 8, 8, 8, 8, 8, 8, 8
};

const int Square::Edge[64] =
{
   1, 1, 1, 1, 1, 1, 1, 1,
   1, 0, 0, 0, 0, 0, 0, 1,
   1, 0, 0, 0, 0, 0, 0, 1,
   1, 0, 0, 0, 0, 0, 0, 1,
   1, 0, 0, 0, 0, 0, 0, 1,
   1, 0, 0, 0, 0, 0, 0, 1,
   1, 0, 0, 0, 0, 0, 0, 1,
   1, 1, 1, 1, 1, 1, 1, 1
};

const int Square::Colors[64] =
{
   1, 0, 1, 0, 1, 0, 1, 0,
   0, 1, 0, 1, 0, 1, 0, 1,
   1, 0, 1, 0, 1, 0, 1, 0,
   0, 1, 0, 1, 0, 1, 0, 1,
   1, 0, 1, 0, 1, 0, 1, 0,
   0, 1, 0, 1, 0, 1, 0, 1,
   1, 0, 1, 0, 1, 0, 1, 0,
   0, 1, 0, 1, 0, 1, 0, 1
};

const int Square::Center[64] =
{
   0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 1, 1, 0, 0, 0,
   0, 0, 0, 1, 1, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0
};

Square::Square( const int file, const int rank, const ColorType side )
{
	if (side == Black)
	   my_location =  (rank-1)*8 + file - 1;
	else
	   my_location = 55 - (rank-1)*8 + file;
	ASSERT(OnBoard());
}

int Square::Rank(const ColorType side) const
{

    ASSERT(OnBoard());
   if (side == Black)
      return Ranks[my_location];
   else
      return 9-Ranks[my_location];
}

const Square &Square::Invalid()
{
    static Square sq(InvalidSquare);
    return sq;
}

Square Square::Value( char *p )
{
    int rank, file;

    if ((*p >= 'a') && (*p <= 'h'))
       file = *p - 'a' + 1;
    else
       return Square::Invalid();
    ++p;
    if ((*p >= '1') && (*p <= '8'))
       rank = *p - '1' + 1;
    else
       return Square::Invalid();
    return (8-rank)*8 + file - 1;
}

char Square::FileImage() const
{
    return 'a' + File() - 1;
}

char Square::RankImage() const
{
    return '1' + Rank(White) - 1;
}



