// Copyright 1993 by Jon Dart.  All Rights Reserved.

#ifndef _CLOCK_H
#define _CLOCK_H

#include "color.h"
#include "types.h"
#include <time.h>
#include <windows.h>

class Clock
{
public:
    enum Direction { Up, Down };

    Clock( HWND parent );
    
    virtual ~Clock();
    
    void set_handle( const HWND parent );

    void reset();
    
    void start( const ColorType side );
    
    void pause();
    
    void resume();
    
    void stop();
    
    void update();
    
    void count_up();
    
    void count_down( time_t limit, const ColorType side );
    
    time_t get_limit( const ColorType side ) const
    {
	return limit[side];
    }
    
    time_t elapsed_time( const ColorType side )
    {
       return etime[side];	     
    }
    
    time_t time_left( const ColorType side );
    
    // a not-running clock may be stopped or paused.
    BOOL is_running() const
    {
        return running;	    
    }
    
    // a stopped clock can only be reset.
    BOOL is_stopped() const
    {
        return stopped;	    
    }
    
    // True if one side has exceeded the time limit
    BOOL time_is_up() const
    {
	return time_up;
    }
    
    void show_time( ColorType side );
    
    ColorType get_side_to_move() const
    {
       return side_to_move;	    
    }

private:
    HWND pWin;
    BOOL running, was_reset, stopped, time_up;
    time_t etime[2];
    time_t last_start[2];
    time_t limit[2];
    ColorType side_to_move;
    Direction dir;
};

#endif

extern Clock *the_clock;

