// Copyright 1995 by Jon Dart. All Rights Reserved.
#ifndef __DEBUG_H__
#define __DEBUG_H__


// This header provides a macro (UCOND_ASSERT) that can be used to insert an
// unconditional assert into the code.  I.e. the assert is present even
// in non-debug builds (unlike the MFC ASSERT macro).

#ifdef _DEBUG
#define UNCOND_ASSERT(e) ASSERT(e)
#else
#if defined(_DOS)
#define UNCOND_ASSERT(e) \
      if (!(e)) { fprintf(stderr,"Assertion failed: %s at %s line %d\n",#e,__FILE__,__LINE__); \
      abort(); \
      }   
#else
extern void uncond_assert(const char *expr, const char *file, const int line);
#define UNCOND_ASSERT(e) if (!(e)) uncond_assert(  #e, __FILE__, __LINE__)
#endif
#endif

#endif
