// Copyright 1992 by Jon Dart.  All Rights Reserved.

#ifndef _BEARING_H
#define _BEARING_H
#include "board.h"

extern const int Direction[2];

extern const byte KnightSquares[64][8];

extern const byte KingSquares[64][8];

extern const byte BishopSquares[64][32];

extern const byte RookSquares[64][32];

extern const int RankIncr;	// add this to move 1 rank

class Bearing
{
     // Finds pseudo-legal moves for individual pieces, plus
     // related functions.

     public:
	     
     enum { MaxBearSq = 28 };	     
     enum { Offset = 9 };

     static unsigned BearSq( const Board &board,
	 const Square loc, Square *squares);
     // Returns all squares to which a piece at location 'loc' can move.
     // It does not include castling moves, but does include en passant
     // captures and pawn promotions.  It doesn't check for pins, 
     // and hence may return some illegal moves.
	     
     static unsigned Attack( const Board &board,
	 const Square loc, const ColorType side,
	 Square *squares, BOOL indirect = FALSE);
     // returns a list of all squares on which pieces of color "side"
     // reside which attack the piece at "loc".  The function return
     // value is the number of such pieces.  If "loc" is empty,
     // returns all squares from which pieces can move to "loc".
     // En passant captures are not included.
     // If indirect = True, include "stacked" attackers (sliding pieces
     // behind a piece of the same color).  Each such piece is offset
     // a constant (9) in the square array from the piece it is stacked
     // behind.

     static unsigned Attack_or_Defend( const Board &board, const Square &loc,
	     Square *squares);
     // returns a list of all squares (empty or not) which the piece
     // at "loc" attacks or defends.  Note that this includes squares
     // to which the piece cannot move (e.g. squares occupied by pieces
     // of its color).  En passant captures are not included.
	     
     static BOOL Pinned( const Board &board, const Square loc,
	     Piece &PinnedByPiece, 
	     Square &PinnedBySquare,
	     int &dir);
     // returns TRUE if the piece at location 'square' is pinned. If it
     // is pinned, also returns PinnedByPiece = piece pinning piece at
     // 'square', PinnedBySquare = pinning piece's square, dir =
     // direction of pin.	     
     // We could call Attacks to get this information, but this is faster.
	     
};

#endif
