// file Address.java
// jlouie 9.96
// v1.04
// This Version:
//    Implements a Choice box in the modification window.
//    Supports multi-character searches without recursion.
//    Repositions window to > Point(30,30).
//    Fixes an index error in MyCanvas.
//    Saves changes after a return in Modify.
//    Data is displayed in a Canvas, not a TextArea.
// Features not yet supported:
//    Help.
// Known Bugs:
//    Sort button enable/disable is buggy (Mac).
//    Default button does not getFocus (Mac).
//    MyCanvas must be redrawn (Mac) see partial workaround Refresh().
//    toFront() is buggy (Win95) so minimize the DOS window.
// A Java Address Book using a simple tab/return delimited text file.
// This application will write to the file Address.txt
// Tested with JDK 1.02 Mac and Win95.
// See Modify.java and MyWidgets Source.
// Supplied AS_IS, free for non-commercial use with a functioning
// and unaltered about box.
//
// Ref: "Teach Yourself Java in 21 Days", Lemay & Perkins, Sams Net
// Ref: "Java in a Nutshell", David Flanagan, O'Reilly & Associates
// Ref: "Core Java", Cornell & Horstmann, Sunsoft Press
// Ref: "The Java Programming Language" Arnold & Gosling Addison Wesley
// General Ref: "Code Complete" Steve McConnell, Microsoft Press
// OOP Ref: "Object-Oriented Analysis and Design" Grady Booch, Addison Wesley

import java.awt.*;
import java.io.*;
import java.util.*;
import Widgets104.*;

public class Address extends Frame implements DialogInterface
{  
   final static String THE_FILE=          "Address.txt";
   final static String DEFAULT_RECORD=
      "Last\tFirst\tCompany\tStreet\tCity\tST\tZIP\tH\t000\t"+
"000-0000\tW\t000\t000-0000\tF\t000\t000-0000\tC\t000\t000-0000\tE-Mail\tNote\t\r";
   final static boolean IS_DEBUG= false;   // code size optimized if false
   static final Point p= new Point(30,30);
   public MyTextField[] arrayFields;       // current record as textfields array
   public Choice[] arrayChoice;            // used to choose Phone Type
   
   static public boolean isMac;              // can be set by polymorphic main!
   private boolean isDirty=         false; // flag changes in data
   private boolean isSorted=        false; // flag for Sort button & method
   private MyDialog md=             null;  // used to avoid multiple dialogs
   private MyCanvas mc;                    // output area for current record
   private Vector vectorRecords=    null;  // read in file as vector of records
   private Modify modify=           null;  // used to avoid multiple windows
   private Find find=               null;  // reference to Find window
   private int recPointer= 0;              // 0 is first record
   private int maxRecords= 1;              // but 1 = one record
   private Label currentRecord;            // displays current record
   private Label totalRecords;             // displays total records
   private MenuItem itemSave=       null;  // used to enable/disable menu item
   private Button buttonSort=       null;  // used to enable/disable buttons
   private Button buttonPrevious=   null;
   private Button buttonNext=       null;
   private Button buttonModify=     null;
   private Button buttonNew=        null;
   private Button buttonDelete=     null;
   private Button buttonFind=       null;
   private Button buttonQuit=       null;
   private Button buttonAdd=        null;
   
   public static void main(String[] input) // win application entry
   {
      isMac= false;
      new Address("Java Address Book");
   }
   
   public static void main()  // mac entry point
   {
      isMac= true;
      new Address("Java Address Book");
   }
   
   Address(String title)
   {
      super(title);
      
      arrayFields= new MyTextField[21];
      buttonPrevious= new  Button("<<<");
      buttonNext= new Button(">>>");
      buttonModify= new Button("Modify");
      buttonAdd= new Button("Add");
      buttonDelete= new Button("Delete");
      buttonFind= new Button("Find");
      buttonQuit= new Button("Quit");
      buttonSort= new Button("Sort");
      InitTextArray(arrayFields);               // set default values and tab order
      vectorRecords= ReadFile(Address.THE_FILE);// store records as vector
      Sort(vectorRecords);
      ReadRecord(vectorRecords, recPointer);    // read one record to arrayFields
      String data= ArrayToString(arrayFields);  // convert MyTextField[] to a string
      arrayChoice= new Choice[4];               // used to choose Phone Type
      for (int i=0; i<4; i++)
      {
         arrayChoice[i]= new Choice();
         arrayChoice[i].addItem("Home");
         arrayChoice[i].addItem("Work");
         arrayChoice[i].addItem("Fax");
         arrayChoice[i].addItem("Cellular");
         arrayChoice[i].addItem("Pager");
      }
      
      MenuBar mb= new MenuBar();
      Menu m= new Menu("File");
      m.add(itemSave= new MenuItem("Save"));
      itemSave.disable();                       // Sorted on read file
      m.add(new MenuItem("Quit"));
      mb.add(m);
      m= new Menu("Edit");
      m.add(new MenuItem("Modify"));
      mb.add(m);
      m.add(new MenuItem("Add"));
      mb.add(m);
      m.add(new MenuItem("Delete"));
      mb.add(m);
      m= new Menu("Search");
      m.add(new MenuItem("Find"));
      mb.add(m);
      m= new Menu("Help");
      m.add(new MenuItem("About Java Address..."));
      mb.add(m);
      setMenuBar(mb);
      setLayout(new BorderLayout());  
      Panel pl= new Panel();
      pl.setLayout(new FlowLayout(FlowLayout.CENTER));
      currentRecord= new Label("Current Record: "+Integer.toString(recPointer+1)+"   ");
      pl.add(currentRecord);
      totalRecords= new Label("Total Records: " + Integer.toString(maxRecords)+"   ");
      pl.add(totalRecords);
      this.add("North",pl);
      pl= new Panel();
      pl.setLayout(new FlowLayout(FlowLayout.CENTER));
      if (isMac) mc= new MyCanvas(data,10,40);
      else mc= new MyCanvas(data,10,35);             // display current record 
      pl.add(mc);
      this.add("Center",pl);
      pl= new Panel();
      pl.setLayout(new FlowLayout(FlowLayout.CENTER));
      Panel sub= new Panel();
      sub.setLayout(new FlowLayout(FlowLayout.CENTER));
      sub.add(buttonPrevious);
      sub.add(buttonNext);
      pl.add(sub);
      sub= new Panel();
      sub.setLayout(new FlowLayout(FlowLayout.CENTER));
      sub.add(buttonFind);
      sub.add(buttonSort);
      buttonSort.disable();
      sub.add(buttonModify);
      sub.add(buttonAdd);
      sub.add(buttonDelete);
      sub.add(buttonQuit);
      pl.add(sub);
      this.add("South",pl);
      this.resize(800,800);
      this.setResizable(false); 
      this.pack();
      Point l= location();
      if ((l.x<30)||(l.y<30)) this.move(p.x,p.y);
      //if (isMac) mc.Draw(data);  
      if (isMac) Refresh();
      this.show();
      EnableDisableArrows();
   }
   
   public void Refresh()
   {if (mc != null) mc.repaint();}  // used for Mac workaround called by Modify
   
   static private void InitTextArray(MyTextField[] arrayFields)
   {
      arrayFields[0]= new MyTextField("Last Name",14);
      arrayFields[1]= new MyTextField("First Name",14);
      arrayFields[2]= new MyTextField("Company",31);
      arrayFields[3]= new MyTextField("Street",31);
      arrayFields[4]= new MyTextField("City",13);
      arrayFields[5]= new MyTextField("ST",2);
      arrayFields[6]= new MyTextField("ZIP",10,MyTextField.PHONE_ONLY);
      arrayFields[7]= new MyTextField("H",1,MyTextField.CUSTOM_KEY,"HWFCP");
      arrayFields[8]= new MyTextField("Area Code",3,MyTextField.DIGITS_ONLY);
      arrayFields[9]= new MyTextField("Phone #",8,MyTextField.PHONE_ONLY);
      arrayFields[10]= new MyTextField("W",1,MyTextField.CUSTOM_KEY,"HWFCP");
      arrayFields[11]= new MyTextField("Area Code",3,MyTextField.DIGITS_ONLY);
      arrayFields[12]= new MyTextField("Phone #",8,MyTextField.PHONE_ONLY);
      arrayFields[13]= new MyTextField("F",1,MyTextField.CUSTOM_KEY,"HWFCP");
      arrayFields[14]= new MyTextField("Area Code",3,MyTextField.DIGITS_ONLY);
      arrayFields[15]= new MyTextField("Phone #",8,MyTextField.PHONE_ONLY);
      arrayFields[16]= new MyTextField("C",1,MyTextField.CUSTOM_KEY,"HWFCP");
      arrayFields[17]= new MyTextField("Area Code",3,MyTextField.DIGITS_ONLY);
      arrayFields[18]= new MyTextField("Phone #",8,MyTextField.PHONE_ONLY);
      arrayFields[19]= new MyTextField("E-Mail",31);
      arrayFields[20]= new MyTextField("Notes",31);
      
      // use class method SetTabFields to set tab order _after_ adding instances
      MyTextField.SetTabFields(arrayFields);
      
      // adjust tabbing for choice boxes
      
      arrayFields[6].SetNextField(arrayFields[8]);
      arrayFields[8].SetPrevField(arrayFields[6]);
      arrayFields[9].SetNextField(arrayFields[11]);
      arrayFields[11].SetPrevField(arrayFields[9]);
      arrayFields[12].SetNextField(arrayFields[14]);
      arrayFields[14].SetPrevField(arrayFields[12]); 
      arrayFields[15].SetNextField(arrayFields[17]);
      arrayFields[17].SetPrevField(arrayFields[15]);
   }

   // implement the DialogInterface
   // MyDialog calls ButtonOne, ButtonTwo, ButtonThree and returns 
   // a string for use if the calling class generates multiple dialogs
   
   public void ButtonOne(String label)          // "OK", "Quit and Save" "Delete"    
   {                                            // " OK "
      if (label == null) 
      {
         if (IS_DEBUG) System.out.println("Null parameter in ButtonOne.");
         return;
      }
      if (label.equals("Quit and Save"))
      {
         if (IS_DEBUG) System.out.println("Saving Changes to File.");
         WriteToFile(Address.THE_FILE, vectorRecords);
         Quit();
      }                         
      if (label.equals("OK")) Quit();           // Quit Dialog OK
      if (label.equals(" OK ")) this.toFront(); // About Box OK      
      if (label.equals("Delete")) 
      {
         DeleteRecord();
         this.toFront();                        // buggy
      } 
   } 
     
   public void ButtonTwo(String label)    // "Cancel" "Cancel Quit"    
   {
      if (IS_DEBUG) System.out.println(label);
      this.toFront();                           // buggy
   } 
     
   public void ButtonThree(String label)  // "Quit, Don't Save"  
   {Quit();}
   
   private void EnableDisableArrows()
   {
      if (recPointer > 0)
         {if (! buttonPrevious.isEnabled()) buttonPrevious.enable();}
      else
         {if (buttonPrevious.isEnabled()) buttonPrevious.disable();}
      if (recPointer < vectorRecords.size() -1)
         {if (! buttonNext.isEnabled()) buttonNext.enable();}
      else
         {if (buttonNext.isEnabled()) buttonNext.disable();}
   }
   
   private void DoPrevious()
   {
      if (recPointer>0)
      {
         recPointer -= 1;
         ReadRecord(vectorRecords, recPointer);     // read one record to arrayFields
         Update();
      }
      else {if (IS_DEBUG) System.out.println("Beep");}
      EnableDisableArrows();
   }
   
   private void DoNext()
   {
      if (recPointer< maxRecords-1)
      {
         recPointer += 1;
         ReadRecord(vectorRecords, recPointer);     // read one record to arrayFields
         Update();
      }
      else {if (IS_DEBUG) System.out.println("Beep");}
      EnableDisableArrows();
   }
   
   private void DoNew()
   {
      isDirty= true;
      if (! itemSave.isEnabled()) itemSave.enable();
      isSorted= false;
      if (! buttonSort.isEnabled()) buttonSort.enable();
      recPointer= vectorRecords.size();
      maxRecords= vectorRecords.size() +1; // redundant for clarity
      vectorRecords.addElement(Address.DEFAULT_RECORD);
      ReadRecord(vectorRecords, recPointer);
      Update();
      EnableDisableArrows();
      DoModify();
   }
   
   private void DoDelete()
   {
     if (md != null)   // work around "Modal" lock up
      { 
         if (md.isShowing()) md.hide();
         md.dispose();
         md= null;
      }
      md= new MyDialog(this, "Delete Dialog", "Really?",
         "Delete this record?", MyDialog.BUTTON_TWO, "Delete", "Cancel");
   }
   
   private void DeleteRecord()
   {
      if (vectorRecords.size()==0)
      {
         if (IS_DEBUG) System.out.println("Index Error.");
         return;
      }
      isDirty= true;
      if (! itemSave.isEnabled()) itemSave.enable();
      if (IS_DEBUG) System.out.println("Deleting Record.");
      vectorRecords.removeElementAt(recPointer);
      if (vectorRecords.size()==0) DoNew();  // Avoid empty database
      else
      {
        if (recPointer>0) recPointer -= 1;
        //else recPointer= 0;
        maxRecords= vectorRecords.size();
        ReadRecord(vectorRecords, recPointer);
        Update();
      }
      EnableDisableArrows();
   }
   
   private void DoSort()
   {
       // sort may not be called!
      if ((vectorRecords.size()<2) || (isSorted)) 
      {
         if (buttonSort.isEnabled()) buttonSort.disable();
         return;
      }
      isSorted= true;
      isDirty= true;
      if (! itemSave.isEnabled()) itemSave.enable();
      Sort(vectorRecords); // warning we are sorting _tab_ delimited strings
      recPointer= 0;
      ReadRecord(vectorRecords, recPointer);
      Update();
      EnableDisableArrows();  
   }
   
   // ShellSort adapted from "Core Java" Cornell & Horstman Sunsoft Press
   // See "Algotithms" R. Sedgewick, Addison Wesley
   
   private void Sort(Vector vectorRecords)
   {
      int n= vectorRecords.size();
      isSorted= true;  // called by constructor
      if (n<2) return; // check for empty vector or single record
      if (IS_DEBUG) System.out.println("Sorting.");
      int incr= n/2;
      while (incr >=1 )
      {
         for (int i= incr; i<n; i++)
         {
            String temp= (String)vectorRecords.elementAt(i);
            int j= i;
            while ((j >= incr)&&
               (Compare(temp, (String)vectorRecords.elementAt(j-incr))))
            {
               vectorRecords.setElementAt(vectorRecords.elementAt(j-incr),j);
               j -= incr;   
            }
            vectorRecords.setElementAt(temp,j);
         }
         incr /= 2;
      }
      if (buttonSort.isEnabled()) buttonSort.disable();
   }
   
   private static boolean Compare(String str1, String str2)
   {
      char ch1, ch2;
      int l1= str1.length();
      int l2= str2.length();
      int maxIterations;
      
      if (l1>l2) maxIterations= l2;
      else maxIterations= l1;
      for (int i=0; i<maxIterations; i++)       // abort if str.length() == 0
      {
         ch1= str1.charAt(i);
         ch2= str2.charAt(i);
         if (Character.isLowerCase(ch1))        // improve the algorithm?
            {ch1= Character.toUpperCase(ch1);}  // case insensitive sort
         if (Character.isLowerCase(ch2))
            {ch2= Character.toUpperCase(ch2);}
         if (ch1<ch2) return true;
         if (ch1>ch2) return false;      
      }
      // equal substrings
      if (l1<l2) return true;
      else return false;
   }
   
   private void DoFind()
   {
       if (find != null)  // workaround
      { 
         if (find.isShowing()) find.hide();
         find.dispose();
         find= null;
      }
      find= new Find(this, "Find");
   }
   
   public void Find(String key)
   {
      if (! isSorted) Sort(vectorRecords);
      if ((key.length()<1) || (vectorRecords.size()<2)) recPointer= 0;
      else {recPointer= BinarySearch(key, vectorRecords, 0, 
            vectorRecords.size()-1, 0);}
      ReadRecord(vectorRecords, recPointer);
      Update();
      EnableDisableArrows();
   }
   
   // non-recursive version
   // vector must be sorted, case insensitive
   
   private int BinarySearch(String str,Vector v,int boundsLeft,int boundsRight,int index)
   {
      if (v == null)
      {
         if (IS_DEBUG) System.out.println("Index error in BinarySearch.");
         return 0;
      }
      int vectorSize= v.size(); 
      if ((boundsLeft <0) || (boundsRight> vectorSize-1))
      {
         if (IS_DEBUG) System.out.println("Index error in BinarySearch.");
         return 0;
      }
      if ((str == null) || (str.length()<1))
      {
         if (IS_DEBUG) System.out.println("Key error in BinarySearch.");
         return 0;
      }
      if ((index<0) || (index>str.length()-1))
      {
         if (IS_DEBUG) System.out.println("String index error in BinarySearch.");
         return 0;
      }
      while((boundsLeft>-1) && (boundsRight< vectorSize) && (boundsLeft<=boundsRight))
      { 
         if (boundsLeft == boundsRight) return boundsLeft;
         char key= str.charAt(index);;
         int i,left,right;
         if (Character.isLowerCase(key)) key= Character.toUpperCase(key);    
         left= boundsLeft;
         right= boundsRight;
         i= (left+right)/2;
         if (key< Convert(i,v, index)) right= i-1;
            else left= i+1;
         while ((Convert(i,v, index)!= key) && (left<=right))
         {
            i= (left+right)/2;
            if (key< Convert(i,v, index)) right= i-1;
            else left= i+1;
         }                                         
         if (key != Convert(i,v, index)) return boundsLeft; // no exact match 
      
         // got a match by BinarySearch now find first instance
         for (int x=i-1; x>=0; x--)                         // default input boundsLeft
         {
            if (key != Convert(x,v, index))
            {
               if ((x+1) > boundsLeft) boundsLeft= x+1;
               break;
            }  
         }
         // find last instance
         for (int x=i+1; x<v.size(); x++)                   // default input boundsRight
         {
            if (key != Convert(x,v, index)) 
            {
               if ((x-1) < boundsRight) boundsRight= x-1;
               break;
            }  
         }
         index++;
         if (IS_DEBUG)
         {System.out.println(boundsLeft+" "+boundsRight+" "+index+" "+str );}
         if (index>str .length()-1) return boundsLeft;      // end of key
         //return BinarySearch(str,v,boundsLeft,boundsRight,index); // recursive version 
      }
      return 0;   //error
   }
   
   private char Convert(int i, Vector v, int index)
   {
      char ch;
      String str;
      
      if (i<0 || i>v.size()-1) return ' ';
      str= (String)v.elementAt(i);
      if ((str.length()>0) && (index<str.length()))
      {
         ch= str.charAt(index);
         if (ch == '\t') ch= ' ';
      }
      else ch=' ';
      if (Character.isLowerCase(ch)) ch= Character.toUpperCase(ch);
      return ch;
   }
                                 
   private void DoQuit()     
   {
      if (isDirty) QuitQuerySave();
      else TryToQuit();
   }
    
   private void DoModify()
   {
      if (modify != null)  // workaround
      { 
         if (modify.isShowing()) modify.hide();
         modify.dispose();
         modify= null;
      }
      modify= new Modify(this, "Modify", arrayFields);
   } 
   
   public boolean handleEvent(Event event)
   {
      if (event.id == Event.WINDOW_DESTROY)
      {
         if (isDirty) QuitQuerySave();
         else TryToQuit();
         return true;
      }
     return super.handleEvent(event);
   }
   
   public boolean action(Event event, Object obj)
   {
      if (event.target instanceof Button)
      {
         if ((Button)event.target == buttonPrevious)  {DoPrevious(); return true;}
         if ((Button)event.target == buttonNext)      {DoNext(); return true;}
         if ((Button)event.target == buttonModify)    {DoModify(); return true;}
         if ((Button)event.target == buttonNew)       {DoNew(); return true;}
         if ((Button)event.target == buttonDelete)    {DoDelete(); return true;}
         if ((Button)event.target == buttonSort)      {DoSort(); return true;}
         if ((Button)event.target == buttonFind)      {DoFind(); return true;}
         if ((Button)event.target == buttonQuit)      {DoQuit(); return true;}
         if ((Button)event.target == buttonAdd)       {DoNew(); return true;}
      }
      
      if (event.target instanceof MenuItem)
      {
         String str= (String)obj;
         if (str.equals("About Java Address...")){DoAbout();return true;}
         if (str.equals("Quit")){DoQuit();return true;}   
         if (str.equals("Save")){DoSave();return true;}  
         if (str.equals("Modify")){DoModify();return true;}
         if (str.equals("Add")){DoNew();return true;}
         if (str.equals("Delete")){DoDelete();return true;}
         if (str.equals("Find")){DoFind();return true;}
      }
      return super.action(event, obj);
   }
   
   private void DoAbout()
   {
      if (md != null)   // work around "Modal" lock up
      { 
         if (md.isShowing()) md.hide();
         md.dispose();
         md= null;
      }
      if (! isMac) md= new MyDialog(this, "About Box", " Java Address v1.04 Win ",
         "jlouie 9.96",MyDialog.BUTTON_ONE," OK ");  // NOT "OK"
      else md= new MyDialog(this, "About Box", " Java Address v1.04 Mac ",
         "jlouie 9.96",MyDialog.BUTTON_ONE," OK ");  // NOT "OK"
   }
   
   public void TryToQuit()
   { 
      if (md != null)   // work around "Modal" lock up
      { 
         if (md.isShowing()) md.hide();
         md.dispose();
         md= null;
      }
      md= new MyDialog(this, "Quit Dialog", "Really?",
         "Quit Application?", MyDialog.BUTTON_ONE, "OK", "Cancel");
   }
   
   private void DoSave()
   {
      if (isDirty) isDirty= false;
      else return;
      if (IS_DEBUG) System.out.println("Saving Changes to File.");
      WriteToFile(Address.THE_FILE, vectorRecords);
      if (itemSave.isEnabled()) itemSave.disable();
   }
   
   private void QuitQuerySave()
   {
      if (md != null)
      { 
         if (md.isShowing()) md.hide();
         md.dispose();
         md = null;
      }
      md= new MyDialog(this, "Quit & Save Dialog", "Quiting Application",
             "Save Any Changes?", MyDialog.BUTTON_ONE, "Quit and Save",
              "Cancel Quit", "Quit, Don't Save"); 
   }
   
   public void Quit()
   {
      this.hide();
      this.dispose();
      System.exit(0);
   }
 
   private Vector ReadFile(String file)
   {
      DataInputStream is= null;
      File theFile= new File(file);
      String line= "Error";
      Vector v= new Vector();
      
      try
      {
         is= new DataInputStream(new FileInputStream(theFile));
         while ((line=is.readLine()) != null)
         {v.addElement(line);}
      }
      catch (IOException e) 
      {System.err.println("Exception reading file: " + e);}
      finally
      {
         try{is.close();} catch(Exception ignored) {;}
         if (v.size() == 0) v.addElement(Address.DEFAULT_RECORD); // no file found
         maxRecords= v.size();
         return v;
      }
   }
   
   // String tokenizer does NOT read empty fields! \t\t equals \t
   // so remember to pad empty fields with <space> when writing to the file
   
   private void ReadRecord(Vector v, int recNumber)
   {
      if (v == null)
      {
         if (IS_DEBUG) System.out.println("Null parameter in ReadRecord.");
         return;
      }
      if ((recNumber > v.size()-1) || (recNumber<0))
      {
         if (IS_DEBUG) System.out.println("Invalid record number.");
         return;
      }
      StringTokenizer t= new 
         StringTokenizer((String)v.elementAt(recNumber), "\t");
      for (int i=0; i<arrayFields.length; i++)
      {
         if (t.hasMoreTokens()) arrayFields[i].setText(t.nextToken());
         else  arrayFields[i].setText(" ");  // eg.naked return in database!
      }
   }
   
   // use a StringBuffer
   
   private String ArrayToString(MyTextField[] arrayFields)
   {
      String data= "Error\n";
      
      if (arrayFields == null)
      {
         if (IS_DEBUG) System.out.println("Null parameter in ArrayToString.");
         return data;
      }
      if (arrayFields.length < 21)
      {
          if (IS_DEBUG) System.out.println("Error in arrayFields.");
          return data;
      }
      
      StringBuffer buffer= new StringBuffer();
      buffer.append(arrayFields[0].getText()+ ", " + arrayFields[1].getText()+ "\n");
      if (! (arrayFields[2].getText().equals(" ") ||  arrayFields[2].getText().equals("")))
          buffer.append(arrayFields[2].getText()+ "\n");
      buffer.append(arrayFields[3].getText()+ "\n");
      buffer.append(arrayFields[4].getText()+ ", " + arrayFields[5].getText()+ " " 
         + arrayFields[6].getText()+ "\n\n");
      buffer.append(arrayFields[7].getText()+ " (" + arrayFields[8].getText() + ") "
          + arrayFields[9].getText() + "\n");
      buffer.append(arrayFields[10].getText()+ " (" + arrayFields[11].getText()+ ") "
          + arrayFields[12].getText()+ "\n");
      buffer.append(arrayFields[13].getText()+ " (" + arrayFields[14].getText() + ") "
          + arrayFields[15].getText()+ "\n");
      buffer.append(arrayFields[16].getText() + " (" + arrayFields[17].getText()+ ") "
          + arrayFields[18].getText()+ "\n");
      buffer.append(arrayFields[19].getText()+ "\n");
      buffer.append(arrayFields[20].getText());
      data= buffer.toString();
      return data;
   }
   
   public void UpdateChoice()
   {
      for (int i=0; i<4; i++)
      {SetChoice(arrayChoice[i], arrayFields[7+(3*i)].getText());}
   }
   
   private void SetChoice(Choice c, String str)
   { 
      if ((c != null) && (str != null) && (str.length()>0))
      {
         char ch= str.charAt(0);
         switch (ch)
         {
            case 'H': c.select("Home"); break;
            case 'W': c.select("Work"); break;
            case 'F': c.select("Fax"); break;
            case 'C': c.select("Cellular"); break;
            case 'P': c.select("Pager"); break;
         }  
      }
      else if (IS_DEBUG) System.out.println("Parameter error in SetChoice.");
   }
   
   public void Update()
   {
      String data= ArrayToString(arrayFields);
      mc.Draw(data);
      if ((modify != null) && (modify.isShowing())) UpdateChoice();
      currentRecord.setText("Current Record: "+Integer.toString(recPointer+1));
      totalRecords.setText("Total Records: " + Integer.toString(maxRecords));
   }
   
   public void SaveChanges()
   {
      String temp="", data="";
      if ((recPointer<0) || (recPointer>vectorRecords.size()-1))
      {
         if (IS_DEBUG) System.out.println("Invalid record pointer.");
         return;
      }
      isDirty= true;
      if (! itemSave.isEnabled()) itemSave.enable();
      isSorted= false;
      if (! buttonSort.isEnabled()) buttonSort.enable();
      for (int i=0; i<arrayFields.length; i++)
      {
         temp= arrayFields[i].getText();
         if (temp.equals("")) temp= " ";        // workaround StringTokenizer bug
         data += temp + "\t";
      }
      vectorRecords.setElementAt(data, recPointer);
   }
   
   private void WriteToFile(String file, Vector v)
   {
      PrintStream os= null;
      if (v == null)
      {
         if (IS_DEBUG) System.out.println("Null parameter in WriteToFile.");
         return;
      }
      File theFile= new File(file);
      Enumeration e= v.elements();
      
      try
      {
         os= new PrintStream(new FileOutputStream(theFile));
         while(e.hasMoreElements())
         {os.println((String)e.nextElement() + "\r");}
      }
      catch (IOException err) 
      {System.err.println("Exception Writing to File: " + err);}
      finally
      {
         try{os.close();}
         catch(Exception ignored) {;}
      }
    }
}

class Find extends Frame
{
   TextField tf;
   Button OKButton, CancelButton;
   Address address;
   String key= " ";
   
   Find(Address address, String title)
   {
       super(title);
       this.address= address;
       this.setLayout(new BorderLayout());
       Panel pl= new Panel();
       pl.setLayout(new FlowLayout(FlowLayout.CENTER));
       pl.add(new Label("Find the first record that..."));
       this.add("North", pl);
       pl= new Panel();
       pl.setLayout(new FlowLayout(FlowLayout.CENTER));
       pl.add(new Label("Begins with:", Label.RIGHT));
       this.add("West",pl);
       pl= new Panel();
       pl.setLayout(new FlowLayout(FlowLayout.CENTER));
       pl.add(tf= new TextField("",20));
       this.add("Center",pl);
       pl=new Panel();
       pl.setLayout(new GridLayout(1,2));
       pl.add(OKButton= new Button("OK"));
       pl.add(CancelButton= new Button("Cancel"));
       this.add("South",pl);
       this.resize(200,200);
       this.setResizable(false);
       this.pack();
       this.show();
       tf.requestFocus(); 
       tf.selectAll();  // buggy 
   }
   
   public boolean handleEvent(Event event)
   {
      if (event.id == Event.WINDOW_DESTROY)
      {
         this.hide();
         address.toFront();
         return true;
      }
      return super.handleEvent(event);
   }
   
   public boolean action(Event event, Object obj)
   {
      if (event.target == OKButton)
      {
         this.hide();
         key= tf.getText();                     // workaround blank field 
         if (key.length()<1) key= " ";          // empty key entered!
         address.Find(key);
         address.toFront();
         return true;
      }
      if (event.target == CancelButton)
      {
         this.hide();
         address.toFront();
         return true;
      }
        if (event.target instanceof TextField)   // trap return in textfield
      {
         this.hide();
         key= tf.getText();
         if (key.length()<1) key=" ";
         address.Find(key);
         address.toFront();
         return true;
      }
      return super.action(event, obj);
   }
}


// adapted from "Java in a Nutshell" D. Flanagan, O'Reilly

class MyCanvas extends Canvas
{
   private int columns, rows;
   private String data="";
   private String[] arrayStrings= null;
   private int lineHeight, lineAscent, numLines, frameWidth, frameHeight;
   private FontMetrics fm= null;
   
   public static final int INSET= 2;
   public static final int MARGIN_WIDTH= 10;
   public static final int MARGIN_HEIGHT= 10;

   
   MyCanvas(String data, int rows, int columns)
   {
      super();
      if ((data.length()<1) || (columns <1) || (rows<1))
      {
         if (Address.IS_DEBUG) System.out.println("Parameter error in MyCanvas.");
         return;
      }
      this.data= data;
      this.columns= columns;
      this.rows= rows;
      StringToArray(this.data);
   }
   
   private void StringToArray(String data)
   {
      StringTokenizer t= new StringTokenizer(data, "\n");
      numLines= t.countTokens();
      arrayStrings= new String[numLines];
      for (int i=0; i<numLines; i++)
      {arrayStrings[i]=t.nextToken();}
   }
   
   public void addNotify()
   {
      super.addNotify();   // wait until peer is created 
      Measure();
   }
   
   public void Measure()
   {
      fm= this.getFontMetrics(this.getFont());
      if (fm == null) return;
      lineHeight= fm.getHeight();
      lineAscent= fm.getAscent();
      frameHeight= lineHeight*rows+(INSET*2)+(2*MARGIN_HEIGHT);
      frameWidth= (columns*fm.charWidth('A'))+2*INSET+(2*MARGIN_WIDTH);
   }
   
   public void Draw(String data)
   {
      StringToArray(data);
      Measure();
      repaint(); 
   }
   
   public Dimension preferredSize()
   {
      return new Dimension(frameWidth,frameHeight);
   }
   
   public Dimension minimumSize()
   {
      return new Dimension(frameWidth,frameHeight);
   }
   
   public void paint(Graphics g)
   {
      int x,y, wWidth, dWidth, init;
      Dimension d= this.size();
      dWidth= d.width-(2*INSET)-(2*MARGIN_WIDTH);
      y= lineAscent + MARGIN_HEIGHT + INSET;
      x= MARGIN_WIDTH+INSET;
      String temp="";   // stringBuffer not helpful due to call fm.stringWidth

      g.setColor(Color.blue);
      g.drawRoundRect(INSET,INSET,d.width-(2*INSET),d.height-(2*INSET),20,20);
      g.setColor(Color.black);
      for (int i=0; i<numLines; i++, y+= lineHeight)
      {
         if ((fm != null) && 
            (fm.stringWidth(arrayStrings[i]) > dWidth))
         {
            wWidth= fm.charWidth('W');
            init= (dWidth/wWidth)-1;
            try {temp=arrayStrings[i].substring(0,init);}  // does _not_ include init!
            catch(Exception e) {temp="Error";}  
            for (int si= init; si<arrayStrings[i].length(); si++) // index bug fix 9.96
            {
               temp += arrayStrings[i].charAt(si);
               if ((fm.stringWidth(temp)+wWidth) > dWidth) 
               {
                  g.drawString(temp,x,y);
                  break;
               }
            }
         }
         else g.drawString(arrayStrings[i], x, y);    
      }
   }
}

// the modification window
// v1.04

class Modify extends Frame implements DialogInterface
{
   final static boolean IS_DEBUG= false;
   final static Point p= new Point(30,30);
   
   MyTextField[] arrayFields= null;
   Choice[] arrayChoice= null;
   Address address= null;
   MyDialog md= null;
   Button sb, cb= null;
   
   public void ButtonOne(String label)    // "Yes"
   {
      Close();
      DoSave();
   }
   
   public void ButtonTwo(String label)    // "Cancel" 
   {this.toFront();}
   
   public void ButtonThree(String label)  // "No"
   {Close();} 
     
   Modify(Address address, String title, MyTextField[] arrayFields)
   {
      super(title);
      if (arrayFields == null) 
      {
         if (IS_DEBUG) System.out.println("Null parameter in Modify.");
         return;
      }
      this.address= address;
      this.arrayFields= arrayFields;
      this.arrayChoice= address.arrayChoice; 
      this.setLayout(new BorderLayout());
      this.setBackground(Color.lightGray);
      Panel pl= new Panel();
      pl.setLayout(new GridLayout(10,1));  
      pl.add(new Label("Last, First Name", Label.RIGHT));
      pl.add(new Label("Company", Label.RIGHT));
      pl.add(new Label("Street Address", Label.RIGHT));
      pl.add(new Label("City, State, ZIP", Label.RIGHT));
      pl.add(new Label("Type, Area, Phone", Label.RIGHT));
      pl.add(new Label("Type, Area, Phone", Label.RIGHT)); 
      pl.add(new Label("Type, Area, Phone", Label.RIGHT));
      pl.add(new Label("Type, Area, Phone", Label.RIGHT));
      pl.add(new Label("E-Mail", Label.RIGHT));
      pl.add(new Label("Notes", Label.RIGHT));
      this.add("West",pl);
      pl= new Panel();
      pl.setLayout(new GridLayout(10,1));
      Panel subPanel= new Panel();
      subPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
      subPanel.add(arrayFields[0]);
      subPanel.add(arrayFields[1]);
      pl.add(subPanel);
      subPanel= new Panel();
      subPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
      subPanel.add(arrayFields[2]);
      pl.add(subPanel);
      subPanel= new Panel();
      subPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
      subPanel.add(arrayFields[3]);
      pl.add(subPanel);
      subPanel= new Panel();
      subPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
      subPanel.add(arrayFields[4]);
      subPanel.add(arrayFields[5]);
      subPanel.add(arrayFields[6]);
      pl.add(subPanel);
      for (int i=0; i<4; i++)
      {
         subPanel= new Panel();
         subPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
         subPanel.add(arrayChoice[i]);       // add choice box instead of textfield
         subPanel.add(arrayFields[8+(i*3)]);
         subPanel.add(arrayFields[9+(i*3)]);
         pl.add(subPanel);
      }
      address.UpdateChoice();                // set choice box using Type textfield
      subPanel= new Panel();
      subPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
      subPanel.add(arrayFields[19]);
      pl.add(subPanel);
      subPanel= new Panel();
      subPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
      subPanel.add(arrayFields[20]);
      pl.add(subPanel);
      this.add("Center",pl);
      pl= new Panel();
      pl.setLayout(new FlowLayout(FlowLayout.CENTER));
      pl.add(sb= new Button("Save Changes <Enter>"));
      pl.add(cb= new Button("Cancel"));
      this.add("South",pl);
      this.resize(200,800);
      this.setResizable(false);
      this.pack();
      Point l= this.location();
      if ((l.x<30)||(l.y<30)) this.move(p.x,p.y);
      this.show();
      arrayFields[0].requestFocus();
      arrayFields[0].selectAll();
   }
   
   public boolean handleEvent(Event event)
   {
      if (event.id == Event.WINDOW_DESTROY)
      {
         CloseQuerySave();
         return true;
      }
      return super.handleEvent(event);
   }
   
   public boolean action(Event event, Object obj)
   {
      String str= "W";
      char ch= 'W';
      
      if (event.target == sb)
      {
         Close();
         DoSave();
         return true;
      }
      if (event.target == cb)
      {
         Close();
         return true;
      }
      if (event.target instanceof MyTextField) 
      { 
         Close();
         DoSave();
         return true; 
      } 
      if (event.target instanceof Choice)
      {
         if (obj != null) ch= ((String)obj).charAt(0);
         str=String.valueOf(ch);
         for (int i=0; i<4; i++)
         {
            if (event.target == arrayChoice[i])
            {
               arrayFields[7+(3*i)].setText(str);     // update Type TextField
               arrayFields[8+(3*i)].requestFocus();   // "tab" to next field
               if (arrayFields[8+(3*i)].isEditable()) arrayFields[8+(3*i)].selectAll();
               break;
            }
         }  
         return true;
      }    
      return super.action(event, obj);
   }
   
   protected void CloseQuerySave()
   {
      if (md != null)
      { 
         if (md.isShowing()) md.hide();
         md.dispose();
         md = null;
      }
      md= new MyDialog(this, "Close & Save Dialog", "Closing Window.",
             "Save Any Changes?", MyDialog.BUTTON_ONE, "Yes",
              "Cancel", "No"); 
   }
   
   protected void Close()
   {
      if (this.isShowing()) this.hide();
      address.toFront();  // buggy
      if (address.isMac) address.Refresh();
   }
   
   protected void DoSave()
   {
      if (IS_DEBUG) System.out.println("Saving Changes.");
      address.SaveChanges();
      address.Update();
   }
}
   

