VERSION 4.00
Begin VB.Form FormMain 
   Caption         =   "VPE Demo"
   ClientHeight    =   3495
   ClientLeft      =   990
   ClientTop       =   1755
   ClientWidth     =   4860
   Height          =   3900
   Left            =   930
   LinkTopic       =   "Form1"
   ScaleHeight     =   3495
   ScaleWidth      =   4860
   Top             =   1410
   Width           =   4980
   Begin VB.CommandButton PageRight 
      Caption         =   ">>"
      Height          =   255
      Left            =   2520
      TabIndex        =   10
      Top             =   840
      Width           =   495
   End
   Begin VB.CommandButton PageLeft 
      Caption         =   "<<"
      Height          =   255
      Left            =   1800
      TabIndex        =   9
      Top             =   840
      Width           =   495
   End
   Begin VB.CommandButton DelReport 
      Caption         =   "Delete Report"
      Height          =   255
      Left            =   120
      TabIndex        =   8
      Top             =   1560
      Width           =   1215
   End
   Begin VB.CommandButton GenReport 
      Caption         =   "Generate Report"
      Height          =   255
      Left            =   120
      TabIndex        =   7
      Top             =   1200
      Width           =   1215
   End
   Begin VB.CommandButton SpeedClose 
      Caption         =   "Close"
      Height          =   375
      Left            =   3720
      TabIndex        =   6
      Top             =   1200
      Width           =   975
   End
   Begin VB.CommandButton PrecisionClose 
      Caption         =   "Close"
      Height          =   375
      Left            =   3720
      TabIndex        =   5
      Top             =   240
      Width           =   975
   End
   Begin VB.TextBox MsgText 
      BackColor       =   &H00C0C0C0&
      Enabled         =   0   'False
      Height          =   615
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   4
      Top             =   2760
      Width           =   4695
   End
   Begin VB.CommandButton Background 
      Caption         =   "Background"
      Height          =   375
      Left            =   120
      TabIndex        =   3
      Top             =   240
      Width           =   1095
   End
   Begin VB.CommandButton Exit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   1800
      TabIndex        =   2
      Top             =   2040
      Width           =   1095
   End
   Begin VB.CommandButton Speed 
      Caption         =   "Speed + Tables"
      Height          =   495
      Left            =   1440
      TabIndex        =   1
      Top             =   1200
      Width           =   1935
   End
   Begin VB.CommandButton Precision 
      Caption         =   "Capabilities + Precision"
      Height          =   495
      Left            =   1440
      TabIndex        =   0
      Top             =   240
      Width           =   1935
   End
End
Attribute VB_Name = "FormMain"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Rem ordinal for storing a setting
Const HEADLINE = 1

Dim hPrecision As Long
Dim hSpeed As Long
Dim rc As Rect
   
Dim sum_amount, sum_prorated, sum_tax As Double

Private Sub DelReport_Click()
   If Dir("journal.rpt") = "" Then
      Exit Sub
   End If
   
   Kill "journal.rpt"
End Sub

Private Sub Exit_Click()
   Call ClosePrecision
   Call CloseSpeed
   
   If hPrecision = 0 And hSpeed = 0 Then
      End
   End If
End Sub

Private Sub Form_Load()
   Call InitVPE
   hPrecision = 0
   hSpeed = 0
End Sub


Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
   Call ClosePrecision
   Call CloseSpeed
   
   If hPrecision <> 0 Or hSpeed <> 0 Then
      Cancel = 1
   End If
End Sub


Private Sub GenReport_Click()
   MsgText = "Generating pseudo report-file..."
   MsgText.Refresh
   Dim i, stepper, min, z As Integer
   Dim count, table As Long

   count = 0
   table = 1
   Randomize
   Open "journal.rpt" For Output As 1
   Print #1, "Test-Document"
   Print #1, "1996" + vbCrLf
   z = 0
   
   While count < 20000
      If z < Rnd * 5 + 10 Then
         stepper = 4
         min = 3
      Else
         stepper = 21
         min = 20
         z = -1
      End If
      
      z = z + 1
      Print #1, "@Table " + Str(table)
      table = table + 1
      For i = Rnd * stepper + min To 0 Step -1
         Print #1, count
         Print #1, Format(Rnd * 28 + 1, "##00"); "."; Format(Rnd Mod 12 + 1, "##00"); ".96"
         Print #1, Format(Rnd * 99999, "##,###.00")
         Print #1, Format(Rnd * 99999, "##,###.00")
         Print #1, Format(Rnd * 99999, "##,###.00")
         Print #1, vbCrLf
         count = count + 7
      Next
   Wend

   Close #1
   MsgText = "Report generation finished."
End Sub

Private Sub Pageleft_Click()
   If hPrecision Then
      Call VpeSetUpdate(hPrecision, True)
      Call VpeGotoPage(hPrecision, VpeGetCurrentPage(hPrecision) - 1)
      Call VpeSetUpdate(hPrecision, False)
   End If
End Sub

Private Sub PageRight_Click()
   If hPrecision Then
      Call VpeSetUpdate(hPrecision, True)
      Call VpeGotoPage(hPrecision, VpeGetCurrentPage(hPrecision) + 1)
      Call VpeSetUpdate(hPrecision, False)
   End If
End Sub


Private Sub Precision_Click()
   If hPrecision Then
      Exit Sub
   End If
   
   MsgText = "This window shows the capabilities of VPE, the Virtual Print Engine"
   MsgText.Refresh
   Call PrecisionProc(0)
End Sub


Private Sub PrecisionClose_Click()
   Call ClosePrecision
End Sub



Private Sub Page1(ByVal hDoc As Long)
   Dim DemoText As String
   Dim y As Long

   DemoText = "The moment of impact bursts through the silence and in a roar of sound, the final second is prolonged in a world of echoes as if concrete and clay of Broadway itself was reliving its memories."
   DemoText = DemoText + Chr$(10) + "The last great march past. Newsman stands limp as a whimper as audience and eventare locked as one. Bing Crosby coos'You don't have to feel pain to sing the blues, you don't have to holla - you don't feel a thing in your dollar collar.' Martin Luther cries 'Everybody Sing!' and rings the grand old liberty bell. Leary, weary of his prison cell, walks on heaven, talks on hell."
   DemoText = DemoText + Chr$(10) + "Who needs Medicare and the 35c flat rate fare, when Fred Astaire and Ginger Rogers are dancing through the air? From Broadway Melody stereotypes the band returns to 'Stars and Stripes' bringing a tear to the moonshiner, who's been pouring out his spirit from the illegal still. The pawn broker clears the noisy till and clutches his lucky dollar bill."
   DemoText = DemoText + Chr$(10) + "Then the blackout." + Chr$(10) + Chr$(10) + "(Genesis, 'The Lamb lies down on Broadway')"
   
   y = VpeWriteBox(hDoc, 575, 200, 1625, -1, "[Center PenSize 3]This demo shows the capabilities and precision of VPE." + Chr$(10) + "Print this page and compare not only the positions of the frames," + Chr$(10) + "but the positions of each letter that can be seen." + Chr$(10) + "(Switch the grid on.)" + Chr$(10) + "This is true WYSIWYG !!!" + Chr$(10) + "('What you see is what you get')" + Chr$(10) + "Note, that the nearest result can be seen at a scaling of 1:1." + Chr$(10) + "With every other scaling you get 'best results' in comparison to execution speed.")
   y = VpeWriteBox(hDoc, 100, y + 75, 2000, -1, "['Arial' FontSize 14 Left Bold Italic Underline PenSize 0]RIGHT ALIGNED, 0.25 cm blue frame, light-blue backgr., red bold text, Arial 9pt")
   Call VpeStoreSet(hDoc, HEADLINE)
   
   Call VpeSelectFont(hDoc, "Arial", 9)
   Call VpeSetPen(hDoc, 25, PS_SOLID, COLOR_BLUE)
   Call VpeSetTextColor(hDoc, COLOR_LTRED)
   Call VpeSetFontAttr(hDoc, ALIGN_RIGHT, 1, 0, 0)
   Call VpeSetTransparentMode(hDoc, 0)
   Call VpeSetBkgColor(hDoc, COLOR_CYAN)
   Rem y+30 because frame = 0.25cm --> frame drawn around center of coordinates
   Rem we also want a little gap between the headline and the frame
   y = VpeWriteBox(hDoc, 150, y + 30, 1850, -1, DemoText)
   Call VpeSetTransparentMode(hDoc, 1)

   Call VpeUseSet(hDoc, HEADLINE)
   y = VpeWrite(hDoc, 250, y + 75, 2000, -1, "JUSTIFIED, no frame, Times New Roman 11pt")
   
   Call VpeSelectFont(hDoc, "Times New Roman", 11)
   Call VpeSetFontAttr(hDoc, ALIGN_JUSTIFIED, 0, 0, 0)
   y = VpeWriteBox(hDoc, 250, y + 20, 1550, -1, DemoText)

   Call VpeUseSet(hDoc, HEADLINE)
   y = VpeWriteBox(hDoc, 250, y + 75, 2000, -1, "CENTERED, thin yellow frame, Times New Roman 11pt")
   
   Call VpeSelectFont(hDoc, "Times New Roman", 11)
   Call VpeSetFontAttr(hDoc, ALIGN_CENTER, 0, 0, 0)
   Call VpeSetPen(hDoc, 5, PS_SOLID, COLOR_LTYELLOW)
   y = VpeWriteBox(hDoc, 150, y + 20, 1850, -1, DemoText)
End Sub

Public Sub PrecisionProc(ByVal mode As Integer)
   Dim hDoc As Long
   
   If mode = 0 Then
      hDoc = VpeOpenDoc(hWnd, "Capabilities + Precision", -1, -1, VPE_NO_USER_CLOSE + VPE_GRID_POSSIBLE)
      hPrecision = hDoc
   Else
      hDoc = VpeOpenDoc(hWnd, "Precision + Capabilities", -1, -1, 0)
   End If
   
   Call VpeSetAutoBreak(hDoc, AUTO_BREAK_NO_LIMITS)
   Call VpeSetFontAttr(hDoc, ALIGN_LEFT, 0, 1, 1)
   Call VpeSetPen(hDoc, 0, PS_SOLID, 0)
   Call VpeDefineHeader(hDoc, 100, 100, 1000, 150, "Precision + Capabilities   /  IDEAL Software")
   Call VpeSetUnderlined(hDoc, 0)
   Call VpeDefineFooter(hDoc, 1900, 2800, 2100, 2900, "Page @PAGE")

   Page1 (hDoc)
   Page2 (hDoc)
   Page3_4 (hDoc)
   Page5 (hDoc)
   Page6 (hDoc)

   Call VpeRemoveSet(hDoc, HEADLINE)
   Call VpeGotoPage(hDoc, 1)

   If mode = 0 Then
      rc.Right = -1
      Call VpePreviewDoc(hPrecision, rc, VPE_SHOW_NORMAL)
   Else
      Call VpePrintDoc(hDoc, False)
      Call VpeCloseDoc(hDoc)
   End If
End Sub
Private Sub Page2(ByVal hDoc As Long)
   Dim y, index, skip, first, xx, oldy, segments As Integer
   Dim p As Long
   Dim xr, xstep, yr, x As Double
   Dim s As String
   
   Call VpePageBreak(hDoc)
   Call VpeUseSet(hDoc, HEADLINE)
   y = VpeWriteBox(hDoc, 200, 200, 2000, -1, "An example of drawing (better to turn the grid off here):")
   Call VpeSetPen(hDoc, 8, PS_SOLID, COLOR_BLACK)
   Call VpeBox(hDoc, 200, 300, 1700, 1800)
        
   xr = 6
   xstep = xr / 750
   yr = 18
   segments = 1

   Rem The following graphs are created with VpeAddPolyPoint()
   x = -xr
   skip = 0
   Call VpeSetPen(hDoc, 2, PS_SOLID, COLOR_BLUE)
   p = VpePolyLine(hDoc, 0, 1500)
   
   For xx = 200 To 1699
      y = 1050 - (x ^ 3 - 2 * x ^ 2 - 8 * x) / (yr / 750)
      x = x + xstep
      
      If y < 300 Then
         y = 300
         skip = 1
      ElseIf y > 1800 Then
         y = 1800
         skip = 1
      ElseIf skip = 1 Then
         Call VpeAddPolyPoint(hDoc, p, -1, -1)
         oldy = y
         skip = 2
      Else
         If skip = 2 Then
            Call VpeAddPolyPoint(hDoc, p, xx - 1, oldy)
            skip = 0
         End If
         Call VpeAddPolyPoint(hDoc, p, xx, y)
         segments = segments + 1
      End If
   Next


   x = -xr
   skip = 0
   Call VpeSetPen(hDoc, 2, PS_SOLID, COLOR_LTRED)
   p = VpePolyLine(hDoc, 0, 1500)
   
   For xx = 200 To 1699
      y = 1050 - (3 * x ^ 2 - 4 * x - 8) / (yr / 750)
      x = x + xstep
      
      If y < 300 Then
         y = 300
         skip = 1
      ElseIf y > 1800 Then
         y = 1800
         skip = 1
      ElseIf skip = 1 Then
         Call VpeAddPolyPoint(hDoc, p, -1, -1)
         oldy = y
         skip = 2
      Else
         If skip = 2 Then
            Call VpeAddPolyPoint(hDoc, p, xx - 1, oldy)
            skip = 0
         End If
         Call VpeAddPolyPoint(hDoc, p, xx, y)
         segments = segments + 1
      End If
   Next
   
   
   x = -xr
   skip = 0
   Call VpeSetPen(hDoc, 2, PS_SOLID, COLOR_GREEN)
   p = VpePolyLine(hDoc, 0, 1500)
   
   For xx = 200 To 1699
      y = 1050 - (3 * x - 4) / (yr / 750)
      x = x + xstep
      
      If y < 300 Then
         y = 300
         skip = 1
      ElseIf y > 1800 Then
         y = 1800
         skip = 1
      ElseIf skip = 1 Then
         Call VpeAddPolyPoint(hDoc, p, -1, -1)
         oldy = y
         skip = 2
      Else
         If skip = 2 Then
            Call VpeAddPolyPoint(hDoc, p, xx - 1, oldy)
            skip = 0
         End If
         Call VpeAddPolyPoint(hDoc, p, xx, y)
         segments = segments + 1
      End If
   Next


   Call VpeSetPen(hDoc, 3, PS_SOLID, COLOR_BLACK)
   Call VpeLine(hDoc, 200, 1050, 1700, 1050)
   Call VpeLine(hDoc, 950, 300, 950, 1800)

   Call VpeSelectFont(hDoc, "Arial", 10)
   Call VpeSetFontAttr(hDoc, ALIGN_LEFT, 0, 0, 0)
   Call VpeSetPen(hDoc, 1, PS_DOT, COLOR_BLACK)
   
   xx = 1
   Do While xx < xr
      Call VpeLine(hDoc, 950 + xx * 750 / 6, 300, 950 + xx * 750 / 6, 1800)
      Call VpePrint(hDoc, 960 + xx * 750 / 6, 1050, Str(xx))
      Call VpeLine(hDoc, 950 - xx * 750 / 6, 300, 950 - xx * 750 / 6, 1800)
      Call VpePrint(hDoc, 960 - xx * 750 / 6, 1050, Str(-xx))
      xx = xx + 1
   Loop

   y = 2
   Do While y < yr
      Call VpeLine(hDoc, 200, 1050 + y * 750 / yr, 1700, 1050 + y * 750 / yr)
      Call VpePrint(hDoc, 960, 1050 - y * 750 / yr, Str(y))
      Call VpeLine(hDoc, 200, 1050 - y * 750 / yr, 1700, 1050 - y * 750 / yr)
      Call VpePrint(hDoc, 960, 1050 + y * 750 / yr, Str(-y))
      y = y + 2
   Loop

   y = 1850
   Call VpeWrite(hDoc, 200, y, 2000, -1, "[S 14]The three graphs together consist of " + Str(segments) + " (number determined during runtime) single lines!" + Chr$(10) + Chr$(10) + "VPE manages this data bulk for you FAST!")
End Sub
Private Sub Page3_4(ByVal hDoc As Long)
   Call VpePageBreak(hDoc)

   Call VpeNoPen(hDoc)
   Call VpeSetFontAttr(hDoc, ALIGN_CENTER, 0, 1, 0)
   Call VpeSelectFont(hDoc, "Arial", 18)
   Call VpeWrite(hDoc, 0, 150, 2100, 300, "The supported barcode-types:")
   Call VpeSelectFont(hDoc, "Arial", 10)
   Call VpeSetBold(hDoc, 1)
   
   Call VpeWrite(hDoc, 200, 300, 550, 400, "2 of 5:")
   Call VpeBarcode(hDoc, 200, 360, 550, 560, BCT_2OF5, "123789", vbNullString)

   Call VpeWrite(hDoc, 700, 300, 1200, 400, "Interleaved 2 of 5:")
   Call VpeBarcode(hDoc, 700, 360, 1200, 560, BCT_INTERLEAVED2OF5, "123895783482", vbNullString)

   Call VpeWrite(hDoc, 1350, 300, 1750, 400, "Code 39 (text on top):")
   Call VpeSetBarcodeParms(hDoc, 1, 0)
   Call VpeBarcode(hDoc, 1350, 360, 1750, 560, BCT_CODE39, "ABC123", vbNullString)

   Call VpeWrite(hDoc, 200, 700, 550, 800, "Code 93 (rotated):")
   Call VpeSetRotation(hDoc, 900)
   Call VpeBarcode(hDoc, 275, 760, -300, -200, BCT_CODE93, "DEF987", vbNullString)

   Call VpeWrite(hDoc, 700, 700, 1200, 800, "[Rot 0]Codabar (rotated):")
   Call VpeSetRotation(hDoc, 1800)
   Call VpeBarcode(hDoc, 700, 760, -500, -200, BCT_CODABAR, "123456", vbNullString)

   Call VpeWrite(hDoc, 1400, 700, 1700, 800, "[Rot 0]EAN-8 (rotated):")
   Call VpeSetRotation(hDoc, 2700)
   Call VpeBarcode(hDoc, 1450, 760, -300, -200, BCT_EAN8, "40167794", vbNullString)

   Call VpeWrite(hDoc, 200, 1200, 500, 1400, "[Rot 0]EAN-8 + 2:")
   Call VpeSetBarcodeParms(hDoc, 0, 1)
   Call VpeBarcode(hDoc, 200, 1260, 500, 1460, BCT_EAN8_2, "12345670", "12")

   Call VpeWrite(hDoc, 700, 1200, 1200, 1400, "EAN-8 + 5:")
   Call VpeSetBarcodeParms(hDoc, 0, 0)
   Call VpeBarcode(hDoc, 700, 1260, 1200, 1460, BCT_EAN8_5, "98765430", "12345")

   Call VpeWrite(hDoc, 1350, 1200, 1750, 1400, "EAN-13:")
   Call VpeBarcode(hDoc, 1350, 1260, 1750, 1460, BCT_EAN13, "9781556153952", vbNullString)

   Call VpeWrite(hDoc, 200, 1600, 600, 1800, "EAN-13 + 2:")
   Call VpeBarcode(hDoc, 200, 1660, 600, 1860, BCT_EAN13_2, "4501645096787", "12")

   Call VpeWrite(hDoc, 700, 1600, 1200, 1800, "EAN-13 + 5:")
   Call VpeSetBarcodeParms(hDoc, 0, 1)
   Call VpeBarcode(hDoc, 700, 1660, 1200, 1860, BCT_EAN13_5, "9781556153952", "12345")

   Call VpeWrite(hDoc, 1350, 1600, 1750, 1800, "EAN-128 A:")
   Call VpeSetBarcodeParms(hDoc, 0, 0)
   Call VpeBarcode(hDoc, 1350, 1660, 1750, 1860, BCT_EAN128A, "EAN-128 A", vbNullString)

   Call VpeWrite(hDoc, 200, 2000, 600, 2200, "EAN-128 B:")
   Call VpeBarcode(hDoc, 200, 2060, 600, 2260, BCT_EAN128B, "ean-128 b", vbNullString)

   Call VpeWrite(hDoc, 700, 2000, 1200, 2200, "EAN-128 C:")
   Call VpeBarcode(hDoc, 700, 2060, 1200, 2260, BCT_EAN128C, "128902", vbNullString)

   Call VpeWrite(hDoc, 1350, 2000, 1850, 2200, "POSTNET (1.20) 5 or 9 digits:")
   Call VpeBarcode(hDoc, 1350, 2060, 1628, 2120, BCT_POSTNET, "12345", vbNullString)
   Call VpeBarcode(hDoc, 1350, 2150, 1850, 2210, BCT_POSTNET, "414649623", vbNullString)

   Call VpePageBreak(hDoc)

   Call VpeSetFontAttr(hDoc, ALIGN_CENTER, 0, 1, 0)
   Call VpeSelectFont(hDoc, "Arial", 18)
   Call VpeWrite(hDoc, 0, 150, 2100, 300, "The supported barcode-types (continued):")
   Call VpeSelectFont(hDoc, "Arial", 10)
   Call VpeSetBold(hDoc, 1)

   Call VpeWrite(hDoc, 200, 300, 550, 400, "UPC-A:")
   Call VpeBarcode(hDoc, 200, 360, 550, 560, BCT_UPCA, "07447079382", vbNullString)

   Call VpeWrite(hDoc, 700, 300, 1100, 400, "UPC-A + 2:")
   Call VpeBarcode(hDoc, 700, 360, 1100, 560, BCT_UPCA_2, "07447079382", "01")

   Call VpeWrite(hDoc, 1350, 300, 1800, 400, "UPC-A + 5:")
   Call VpeBarcode(hDoc, 1350, 360, 1800, 560, BCT_UPCA_5, "03126764825", "94687")

   Call VpeWrite(hDoc, 200, 700, 550, 900, "UPC-E:")
   Call VpeBarcode(hDoc, 200, 760, 550, 960, BCT_UPCE, "0378492", vbNullString)

   Call VpeWrite(hDoc, 700, 700, 1100, 900, "UPC-E + 2:")
   Call VpeBarcode(hDoc, 700, 760, 1100, 960, BCT_UPCE_2, "0378492", "14")

   Call VpeWrite(hDoc, 1350, 700, 1800, 900, "UPC-E + 5:")
   Call VpeBarcode(hDoc, 1350, 760, 1800, 960, BCT_UPCE_5, "0364825", "79462")

   Call VpeSetFontAttr(hDoc, ALIGN_LEFT, 0, 0, 0)
   y = VpeWrite(hDoc, 200, 1100, 1800, VFREE, "VPE supports 21 barcode types. Barcodes can be rotated in 90 degree steps, the text can be drawn on bottom or top of the barcode, and also independently the add-on text. Any of these features can be combined.")

   y = VpePrint(hDoc, 500, y + 100, "[S 24 U C LtYellow]Text and images")
   Call VpePrint(hDoc, VRIGHT, VBOTTOM, "[Rot 900 C Blue] can be freely ")
   Call VpeWriteBox(hDoc, 500, VBOTTOM, VLEFT, VFREE, "[Rot 1800 C Red CE]rotated in 90")

   Rem The WIDTH (after rotation it's the height) is the top of the last inserted text
   Rem minus the bottom of the first inserted object.
   Call VpeWriteBox(hDoc, 400, y, -(VpeGet(hDoc, VTOP) - y), VFREE, "[Rot 2700 C Green]degree steps")
End Sub

Private Sub Page5(ByVal hDoc As Long)
   Dim y, y2, x As Integer
   Dim p As Long
   
   Call VpePageBreak(hDoc)
   Call VpeUseSet(hDoc, HEADLINE)
   y = VpeWriteBox(hDoc, 100, 200, 2000, -1, "VPE is also able to manage bitmaps for you!" + Chr$(10) + "Place your logo wherever you want.")
   y = VpeWriteBox(hDoc, 100, y, 1400, -1, "[S 10 L BO IO UO](Note: These are 256-color bitmaps, in 16-color mode it doesn't look very good)")

   y = VpeWriteBox(hDoc, 100, y + 50, 1400, -1, "[N B U]VPE supports the following graphics file formats:")
   Call VpeWriteBox(hDoc, 100, y, 1400, -1, "-Windows and OS/2 Bitmaps (2 / 16 / 256 / True Color)" + Chr$(10) + "-Windows WMF (Metafile)" + Chr$(10) + "-AutoCAD DXF" + Chr$(10) + "-GIF (2 / 16 / 256 Colors)" + Chr$(10) + "-PCX (2 / 16 / 256 Colors)" + Chr$(10) + "-JPG (256 / True Color)" + Chr$(10) + "-TIFF 5.0 (2 / 16 / 256 / True Color, LZW / PackBits / Fax G3 & G4 / Tiled Images)" + Chr$(10) + "-Microsoft filters (feature, some restrictions and only 16-bit version)")
   Call VpeSetPen(hDoc, 5, PS_SOLID, COLOR_BLACK)
   Call VpePicture(hDoc, 1400, 150, -1, -1, "logo.bmp", VPE_PIC_KEEPIMAGE + VPE_PIC_KEEP_DIB_PAGE)
   y = VpeGet(hDoc, VBOTTOM)
   x = VpeGet(hDoc, VRIGHT)
   Call VpeWriteBox(hDoc, 1400, y, x, -1, "[N S 14 CE C White BC Red TO Italic Bold]IDEAL Software")
   Call VpeDefaultBitmapDPI(hDoc, 96, 96)
   Call VpePicture(hDoc, 1400, VpeGet(hDoc, VBOTTOM) + 100, -1, -1, "fruits.bmp", VPE_PIC_KEEPIMAGE + VPE_PIC_KEEP_DIB_PAGE)

   y = VpeWriteBox(hDoc, 150, y + 400, 1500, -1, "[S 14 CE PS 0]Scale your bitmaps as you like:")
   y = y + 20
   Call VpeSetPen(hDoc, 3, PS_SOLID, COLOR_BLACK)
   Call VpePicture(hDoc, 150, y, 200, -1, "logo.bmp", VPE_PIC_KEEPIMAGE + VPE_PIC_KEEP_DIB_PAGE)
   Call VpePicture(hDoc, VpeGet(hDoc, VRIGHT) + 100, y, VpeGet(hDoc, VRIGHT) + 250, -1, "logo.bmp", VPE_PIC_KEEPIMAGE + VPE_PIC_KEEP_DIB_PAGE)
   Call VpePicture(hDoc, VpeGet(hDoc, VRIGHT) + 100, y, VpeGet(hDoc, VRIGHT) + 750, -1, "logo.bmp", VPE_PIC_KEEPIMAGE + VPE_PIC_KEEP_DIB_PAGE)

   y = VpeGet(hDoc, VBOTTOM) + 300
   y = VpePrint(hDoc, 150, y, "[N U]Draw! Set the Pen, Background Color and Hatch Style:")
   y = y + 50
   Call VpeSetTransparentMode(hDoc, 0)
   Call VpeSetBkgColor(hDoc, COLOR_BLUE)
   Call VpeBox(hDoc, 150, y, -300, -300)

   Call VpeSetHatchStyle(hDoc, HS_BDIAGONAL)
   Call VpeSetHatchColor(hDoc, COLOR_BLUE)
   Call VpeSetBkgColor(hDoc, COLOR_LTYELLOW)
   Call VpeNoPen(hDoc)
   p = VpePolygon(hDoc, 0, 4)
   Call VpeAddPolygonPoint(hDoc, p, 250, y + 400)
   Call VpeAddPolygonPoint(hDoc, p, 500, y + 600)
   Call VpeAddPolygonPoint(hDoc, p, 300, y + 700)
   Call VpeAddPolygonPoint(hDoc, p, 150, y + 1000)

   Call VpeSetPen(hDoc, 6, PS_SOLID, COLOR_BLACK)
   p = VpePolygon(hDoc, 0, 4)
   Call VpeAddPolygonPoint(hDoc, p, 650, y)
   Call VpeAddPolygonPoint(hDoc, p, 1000, y + 200)
   Call VpeAddPolygonPoint(hDoc, p, 700, y + 300)
   Call VpeAddPolygonPoint(hDoc, p, 550, y + 600)

   Call VpeNoPen(hDoc)
   Call VpeSetHatchStyle(hDoc, HS_DIAGCROSS)
   Call VpeSetHatchColor(hDoc, COLOR_RED)
   Call VpeSetBkgColor(hDoc, COLOR_CYAN)
   Call VpeEllipse(hDoc, 750, 2150, -500, -300)

   Call VpeSetHatchStyle(hDoc, HS_FDIAGONAL)
   Call VpeSetPen(hDoc, 10, PS_SOLID, COLOR_GREEN)
   Call VpeSetTransparentMode(hDoc, 1)
   y2 = VpeWrite(hDoc, 1200, y + 200, -500, -1, "[S 12 B CE]Write text beyond,")
   Call VpeEllipse(hDoc, 1200, y, -500, -500)
   Call VpeWrite(hDoc, 1200, y2, -500, -1, "or above the hatching.")

   Call VpeSetTransparentMode(hDoc, 0)
   Call VpeWriteBox(hDoc, 770, 2280, -460, -1, "[PS 3 PC Black HSN BC Cyan S 10 NB]Or blank the hatching out.")

   Call VpeSetTransparentMode(hDoc, 1)
End Sub

Private Sub Page6(ByVal hDoc As Long)
   Call VpePageBreak(hDoc)

   Call VpeNoPen(hDoc)
   Call VpePicture(hDoc, 0, 0, -1, -1, "gew.tif", VPE_PIC_KEEPIMAGE + VPE_PIC_KEEP_DIB_PAGE)
 
   Call VpeWrite(hDoc, 250, 110, 1200, -1, "[S 24 C LtRed L PS 0]Stadt Xhausen")
   Call VpeWrite(hDoc, 250, 500, 1000, -1, "[S 14 C Blue]Mustermann & Co." + Chr$(10) + "Feinkost Im- und Export")
   Call VpeWrite(hDoc, 1200, 460, 1700, -1, "[S 11 B]Dsseldorf")
   Call VpeWrite(hDoc, 250, 670, 750, -1, "Schmidt")
   Call VpeWrite(hDoc, 250, 840, 750, -1, "24.7. 1947")
   Call VpeWrite(hDoc, 500, 835, 1000, -1, "Oberammergau")
   Call VpeWrite(hDoc, 250, 1010, 750, -1, "Zunderstr. 93")
   Call VpeWrite(hDoc, 1000, 1000, 1750, -1, "0 27 84 / 16 45 98")
   Call VpeWrite(hDoc, 250, 1255, 1750, -1, "Willi-Graf-Str. 17")
   Call VpeWrite(hDoc, 1000, 1255, 1750, -1, "0 27 84 / 23 54 90")
   Call VpeWrite(hDoc, 1220, 660, 1750, -1, "Heinz - Willi")
   Call VpeWrite(hDoc, 1100, 1500, 1950, -1, "[S 10 J I]It is very important to mention here, that the bitmap form has a resolution of 96 DPI only. The print will not be very nice. Just try a 300 DPI bitmap on your own!")
End Sub

Rem ========================================================================
Rem                              PrintJournal
Rem
Rem Structure of input-file
Rem =======================
Rem User-Name
Rem Year
Rem Start Month (or blank)
Rem End Month (or blank)
Rem <@>Table-Name --> start a new table!!!
Rem No.
Rem Date
Rem Amount
Rem Prorated Amount
Rem Tax
Rem Remark
Rem Remark
Rem
Rem NOTE: In this demo Y2 has a constant value for much faster processing
Rem
Rem ========================================================================

Private Sub Speed_Click()
   Dim hDoc As Long
   Dim s, name, year, period, table As String
   Dim footer_ok, page As Integer
   
   footer_ok = False
   page = 1
 
   If Dir("journal.rpt") = "" Then
      MsgText = "ERROR: Report-File not found - generate it."
      Exit Sub
   End If
   
   Open "journal.rpt" For Input As 1
 
   hDoc = VpeOpenDoc(hWnd, "Speed + Tables", -1, -1, VPE_NO_USER_CLOSE)
   hSpeed = hDoc
   Call VpeSetAutoBreak(hDoc, AUTO_BREAK_NO_LIMITS)
   Call VpeSetTransparentMode(hDoc, False)


   Rem Read constant data block:
   Rem =========================
   Line Input #1, name
   Line Input #1, year
   Line Input #1, s
      
   Rem do not evaluate period
   period = ""
   
   Call VpeSetPen(hDoc, 0, 0, COLOR_BLACK)
   Call VpeSetFontAttr(hDoc, ALIGN_CENTER, 0, 1, 0)
   Call VpeSelectFont(hDoc, "Arial", 16)
   Call VpeWriteBox(hDoc, VLEFTMARGIN, VTOPMARGIN, VRIGHTMARGIN, VFREE, "Journal " + year)

   Call VpeSetPen(hDoc, 3, PS_SOLID, COLOR_BLACK)
   Call VpeSetFontAttr(hDoc, ALIGN_LEFT, 0, 0, 0)
   Call VpeSelectFont(hDoc, "Arial", 11)

   Rem process variable data:
   Rem ======================
   While Not EOF(1)
      Line Input #1, s
      If Left$(s, 1) = "@" Then
         Rem Beginning of a new table:
         Rem =========================
         If footer_ok Then
            PrintFooter (hDoc)
         End If
         sum_amount = sum_prorated = sum_tax = 0

         Rem Is the room to the page-bottom big enough for a new table ?
         If VpeGet(hDoc, VBOTTOMMARGIN) - VpeGet(hDoc, VBOTTOM) < 400 Then
            Rem No, add a new page:
            Call PrintPageFooter(hDoc, name, page)
            Call PageBreak(hDoc, page)
            page = page + 1
         Else
            Rem Beginning of new table is 1cm below previous table:
            Call VpeSet(hDoc, VBOTTOM, VpeGet(hDoc, VBOTTOM) + 100)
         End If
         table = Right$(s, Len(s) - 1)
         Call PrintHeader(hDoc, table)
         footer_ok = False
      Else
         Rem list part:
         Rem ==========
         footer_ok = True
         Call VpeSetTransparentMode(hDoc, 1)
         Call VpeSetAlign(hDoc, ALIGN_RIGHT)
         Call VpeWriteBox(hDoc, VLEFTMARGIN, VBOTTOM, -200, -50, s)

         Line Input #1, s
         Call VpeWriteBox(hDoc, VRIGHT, VTOP, -200, VBOTTOM, s)

         Line Input #1, s
         sum_amount = sum_amount + CDbl(s)
         Call VpeWriteBox(hDoc, VRIGHT, VTOP, -250, VBOTTOM, s)

         Line Input #1, s
         sum_prorated = sum_prorated + CDbl(s)
         Call VpeWriteBox(hDoc, VRIGHT, VTOP, -250, VBOTTOM, s)

         Line Input #1, s
         sum_tax = sum_tax + CDbl(s)
         Call VpeWriteBox(hDoc, VRIGHT, VTOP, -250, VBOTTOM, s)

         Line Input #1, s
         Line Input #1, s2
         s = s + " " + s2
         Call VpeSetAlign(hDoc, ALIGN_LEFT)
         Call VpeSelectFont(hDoc, "Arial", 6)
         Call VpeWriteBox(hDoc, VRIGHT, VTOP, VRIGHTMARGIN, VBOTTOM, s)
         Call VpeSelectFont(hDoc, "Arial", 11)
         Call VpeSetTransparentMode(hDoc, 0)
         
         If VpeGet(hDoc, VBOTTOM) + 150 > VpeGet(hDoc, VBOTTOMMARGIN) Then
            Rem Bottom of page reached:
            Rem =======================
            Call PrintFooter(hDoc)
            Call PrintPageFooter(hDoc, name, page)
            Call PageBreak(hDoc, page)
            page = page + 1
            Call PrintHeader(hDoc, table)
         End If
      End If
   Wend
 
   Close #1
   PrintFooter (hDoc)
   Call PrintPageFooter(hDoc, name, page)
   Call VpeGotoPage(hDoc, 1)
   Call VpeWriteBox(hDoc, 100, 100, 1000, 150, "Generated " + Str(VpeGetPageCount(hDoc)) + " pages out of textfile!")
   MsgText = ""
   rc.Right = -1
   Call VpePreviewDoc(hDoc, rc, VPE_SHOW_MAXIMIZED)
End Sub

Private Sub PrintHeader(hDoc As Long, ByVal table As String)
   Call VpeSetAlign(hDoc, ALIGN_CENTER)
   Call VpeSelectFont(hDoc, "Arial", 14)
   Call VpeSetBkgColor(hDoc, COLOR_LTGRAY)
   Call VpeWriteBox(hDoc, VLEFTMARGIN, VBOTTOM, VRIGHTMARGIN, -60, table)

   Call VpeSetFontAttr(hDoc, ALIGN_CENTER, 1, 0, 0)
   Call VpeSelectFont(hDoc, "Arial", 11)
   Call VpeWriteBox(hDoc, VLEFTMARGIN, VBOTTOM, -200, -50, "No.")
   Call VpeWriteBox(hDoc, VRIGHT, VTOP, -200, VBOTTOM, "Date")
   Call VpeWriteBox(hDoc, VRIGHT, VTOP, -250, VBOTTOM, "Amount")
   Call VpeWriteBox(hDoc, VRIGHT, VTOP, -250, VBOTTOM, "Prorated Amount")
   Call VpeWriteBox(hDoc, VRIGHT, VTOP, -250, VBOTTOM, "Tax")
   Call VpeWriteBox(hDoc, VRIGHT, VTOP, VRIGHTMARGIN, VBOTTOM, "Remark")
   Call VpeSetFontAttr(hDoc, ALIGN_LEFT, 0, 0, 0)
   Call VpeSetBkgColor(hDoc, RGB(255, 255, 255))
End Sub

Private Sub PrintFooter(hDoc As Long)
   Call VpeSetFontAttr(hDoc, ALIGN_CENTER, 1, 0, 0)
   Call VpeSetBkgColor(hDoc, COLOR_LTGRAY)
   Call VpeWriteBox(hDoc, VLEFTMARGIN, VBOTTOM, -400, -50, "Sum")
   Call VpeSetFontAttr(hDoc, ALIGN_RIGHT, 1, 0, 0)
   Call VpeWriteBox(hDoc, VRIGHT, VTOP, -250, VBOTTOM, Format(sum_amount, "###,###,###.00"))
   Call VpeWriteBox(hDoc, VRIGHT, VTOP, -250, VBOTTOM, Format(sum_prorated, "###,###,###.00"))
   Call VpeWriteBox(hDoc, VRIGHT, VTOP, -250, VBOTTOM, Format(sum_tax, "###,###,###.00"))
   Call VpeWriteBox(hDoc, VRIGHT, VTOP, VRIGHTMARGIN, VBOTTOM, "")
   Call VpeSetFontAttr(hDoc, ALIGN_LEFT, 0, 0, 0)
   Call VpeSetBkgColor(hDoc, RGB(255, 255, 255))
End Sub

Private Sub PrintPageFooter(hDoc As Long, ByVal name As String, page As Integer)
   Call VpeStorePos(hDoc)
   Call VpeNoPen(hDoc)
   Call VpeWriteBox(hDoc, VLEFTMARGIN, VBOTTOMMARGIN, VpeGet(hDoc, VRIGHTMARGIN) - 400, -50, name)
   Call VpeSetAlign(hDoc, ALIGN_RIGHT)
   Call VpeWriteBox(hDoc, VRIGHT, VBOTTOMMARGIN, VRIGHTMARGIN, -50, Str(page))
   Call VpeSetPen(hDoc, 3, PS_SOLID, COLOR_BLACK)
   Call VpeRestorePos(hDoc)
End Sub

Private Sub PageBreak(hDoc As Long, page As Integer)
   Call VpePageBreak(hDoc)
   
   If page Mod 10 = 0 Then
      MsgText = "now reading inputfile and generating page " + Str(page)
      MsgText.Refresh
   End If
End Sub

Private Sub SpeedClose_Click()
   Call CloseSpeed
End Sub



Public Sub ClosePrecision()
   If hPrecision Then
      If VpeCloseDoc(hPrecision) Then
         hPrecision = 0
      Else
         MsgText = "Can't close, job 'Precision' is printing!"
      End If
   End If
End Sub

Public Sub CloseSpeed()
   If hSpeed Then
      If VpeCloseDoc(hSpeed) Then
         hSpeed = 0
      Else
         MsgText = "Can't close, job 'Speed' is printing!"
      End If
   End If
End Sub
