


#include "windows.h"
#include "vpiface.h"
#include "vpecomon.h"
#include <colors.h>



char *DemoText =
"[PS 3 S 12 C Black J BO]The moment of impact bursts through the silence and in a roar of sound, the "
"final second is prolonged in a world of echoes as if concrete and clay of "
"Broadway itself was reliving its memories.\n"
"The last great march past. Newsman stands limp as a whimper as audience and "
"eventare locked as one. Bing Crosby coos 'You don't have to feel pain "
"to sing the blues, you don't have to holla - you don't feel a thing in your "
"dollar collar.' Martin Luther cries 'Everybody Sing!' and rings the grand old "
"liberty bell. Leary, weary of his prison cell, walks on heaven, talks on hell.\n"
"Who needs Medicare and the 35c flat rate fare, when Fred Astaire and "
"Ginger Rogers are dancing through the air? From Broadway Melody stereotypes "
"the band returns to 'Stars and Stripes' bringing a tear to the moonshiner, "
"who's been pouring out his spirit from the illegal still. The pawn broker "
"clears the noisy till and clutches his lucky dollar bill.\n"
"Then the blackout.\n\n"
"(Genesis, 'The Lamb lies down on Broadway')";


// ========================================================================
//                              MiniDemo
// ========================================================================
void MiniDemo(HWND hwnd)
{
   long hdoc;

   hdoc = VpeOpenDoc(hwnd, "Mini Demo", -1, -1, 0);
   
   VpeWrite(hdoc, 100, 100, 500, 200, "[B C LtRed]Hello");
   VpePrint(hdoc, 100, 250, "['Times New Roman' S 30 C Blue]World!");
   VpeWriteBox(hdoc, 100, 450, 1900, VFREE, DemoText);

   VpePreviewDoc(hdoc, NULL, VPE_SHOW_NORMAL);
}




// ========================================================================
//                              WndProc
// ========================================================================
long FAR PASCAL _export WndProc(HWND hwnd, UINT message, UINT wParam, LONG lParam)
{
   switch (message)
   {
    case WM_CREATE :
       MiniDemo(hwnd);
       return 0 ;

    case VPE_DESTROYWINDOW:
    case WM_DESTROY:
       PostQuitMessage(0);
       return 0;
   }

   return DefWindowProc (hwnd, message, wParam, lParam) ;
}







// ========================================================================
//                              WinMain
//
// Create a hidden Main Window
// ========================================================================
int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance, LPSTR , int )
{
   static char szAppName [] = "Mini Demo";
   MSG         msg ;
   HWND        hwnd ;
   WNDCLASS    wndclass ;


   if (!hPrevInstance)
   {
      wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
      wndclass.lpfnWndProc   = WndProc ;
      wndclass.cbClsExtra    = 0 ;
      wndclass.cbWndExtra    = 0 ;
      wndclass.hInstance     = hInstance ;
      wndclass.hIcon         = LoadIcon (hInstance, "APP_ICON");
      wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
      wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
      wndclass.lpszMenuName  = szAppName ;
      wndclass.lpszClassName = szAppName ;
      RegisterClass (&wndclass) ;
   }

   hwnd = CreateWindow (szAppName, szAppName,
                        WS_OVERLAPPEDWINDOW,
                        CW_USEDEFAULT, CW_USEDEFAULT,
                        CW_USEDEFAULT, CW_USEDEFAULT,
                        NULL, NULL, hInstance, NULL) ;

   while (GetMessage (&msg, NULL, 0, 0))
   {
      TranslateMessage (&msg) ;
      DispatchMessage (&msg) ;
   }

   return msg.wParam ;
}

