      **********************************************************
      * This COBOL example uses a standard WINAPI message loop,*
      * so that the preview-window stays active and execution  *
      * of the main program is stopped until the preview is    *
      * closed.                                                *
      * Until the preview is closed, there will only standard  *
      * Windows messages be processed.                         *
      * The window handle of the preview is used with the      *
      * API-function 'GetWindowTask' and the task handle is    *
      * tested within the message loop until it is NULL.       *
      *                                                        *
      * N.Rtz, ORGA-RATIO GmbH, Nordhorn                      *
      **********************************************************

      *** Schleifenvariablen aus der WORKING-STORAGE SECTION ***
       01  fLoop	          pic x value 'C'.
	   88 fLoopEnd		  value 'E'.  
       01  bResult		  pic 9(4) comp-5.
	   88  bTRUE		  value 1.
           88  bFALSE             value 0. 	   
      ********************************************************** 
      
       PREVIEW-DOC SECTION.	   
      *--------------------* 
           set lpUser to entry "USER"  
           set lpKernel to entry "KERNEL" 
           set lpGDI to entry "GDI" 
           move 0 to nXPos
           move 0 to nYPos
           move zero to fDocAttr                      
           move 0 to rcLeft
           move 0 to rcTop  
           move 4000 to rcRight
           move 4000 to rcBot  
           if L-DRUFORM not = "A4HOCH"                                   
               add VPE-LANDSCAPE to fDocAttr  
           end-if.
           add VPE-GRID-TOOLBARBUTTON to fDocAttr  
           add VPE-GRID-INFOREGROUND to fDocAttr 
           call PASCAL "VPEOPENDOCFILE" 
                       using by value 0 size 2 
                             by reference szTmpDocFile  
                             by reference szDocFile
                             by value 4000 size 2
                             by value 4000 size 2
                             by value fDocAttr 
                       returning hDoc  
           call PASCAL "VPESETDEFAULTOUTPUTRECT" 
                       using by value hDoc
                             by reference rcOutput
           call PASCAL "VPEPREVIEWDOC"
                       using by value hDoc   
                             by value 0 size 4
                             by value VPE-SHOW-NORMAL size 2  
           call PASCAL "VPEWINDOWHANDLE" 
                       using by value hDoc  
                       returning hWndPreview  
      ***  WARTEN, BIS PREVIEW GESCHLOSSEN WURDE  *** 
           move 'C' to fLoop. 
	   perform until fLoopEnd
               call WINAPI "GetMessage" using
			   by reference msg
			   by value 0 size 2
			   by value 0 size 2
			   by value 0 size 2
		  	   returning bResult
	       if bFALSE 
	           set fLoopEnd to true 
	       else
                   call WINAPI "TranslateMessage"
			       using by reference msg
                   call WINAPI "DispatchMessage"
			       using by reference msg
	       end-if  
	       move zero to hTask
               call WINAPI "GetWindowTask" 
                           using by value hWndPreview  
                           returning hTask
               if hTask = zero
                   set fLoopEnd to true
               end-if 		   
	   end-perform.
      ***	      
           call PASCAL "VPECLOSEDOC" 
                       using by value hDoc.          	                               
	                                         
       PREVIEW-DOC-EXIT. exit.    
