**
**              VPECOMON.H
**              ==========
**
** Common definitions for the "Virtual Print Engine"
**
** 01/95 by IDEAL Software, T. Radde
**
** For FoxPro and Visual FoxPro by Jrg Mckli 5.5.96


** VpeOpenDoc() Flag Parameters:
** =============================
#define VPE_GRID_INBACKGROUND  1        && Grid in Background
#define VPE_GRID_INFOREGROUND  2        && Grid in Foreground
#define VPE_GRID_TOOLBARBUTTON 4        && Grid Toolbar-Button visible
#define VPE_GRID_VISIBLE       8        && Actually Grid visible

#define VPE_NO_RULER           16       && Ruler NOT visible
#define VPE_NO_TOOLBAR         32       && Toolbar NOT visible
#define VPE_NO_USER_CLOSE      64       && User can't close VPE -
                                        && Stop-Button INVISIBLE and Sys-Menu
                                        && disabled (if not embedded)
                                        && VpeCloseDoc() works!
#define VPE_NO_USER_MOVE       128      && User can't leaf through the document
                                        && in future: then no Page-Seg in Statusbar
#define VPE_NO_MOUSE_SCALE     256      && User can't scale with the MOUSE (VpeSetScale() works!)
#define VPE_NO_USER_SCALE      (512 + VPE_NO_MOUSE_SCALE)     && User can't scale (VpeSetScale() works!)
                                        && in future: then no Scale-Seg in Statusbar
#define VPE_NO_STATBAR        1024      && Statusbar invisible
#define VPE_NO_PRINTBUTTON    2048      && Print-Button invisible
                                        && VpePrintDoc() works

#define VPE_EMBEDDED          4096      && Document Window is embedded within
                                        && a window of the calling application
#define VPE_LANDSCAPE         8192      && Document will be printed in Landscape-Format
#define VPE_NO_HELPBTN       32768      && Help-Button invisible
#define VPE_ROUTE_HELP       65536      && if Help-Button visible, pressing this or pushing the F1-key
                                        && will cause the message VPE_HELP to be send to the owner-window,
                                        && no matter if the VPE-window is embedded or not
#define VPE_NO_INFOBTN       131072     && Info-Button invisible


#define VPE_GRID_POSSIBLE      (VPE_GRID_INFOREGROUND + VPE_GRID_TOOLBARBUTTON)
#define VPE_GRID_ON            (VPE_GRID_INFOREGROUND + VPE_GRID_TOOLBARBUTTON + VPE_GRID_VISIBLE)
#define VPE_GRID_BKGON         (VPE_GRID_INBACKGROUND + VPE_GRID_TOOLBARBUTTON + VPE_GRID_VISIBLE)
#define VPE_GRID_OFF           0



** VpePreviewDoc() Flag Parameters:
** ===============================
#define VPE_SHOW_NORMAL     1
#define VPE_SHOW_MAXIMIZED  2
#define VPE_SHOW_HIDE       3


** Hatch-Styles:
** ============
#define  HS_NONE            -1
*All other HS_xxx Styles are defined in windows.h:
#define  HS_HORIZONTAL      0
#define  HS_VERTICAL        1
#define  HS_FDIAGONAL       2
#define  HS_BDIAGONAL       3
#define  HS_CROSS           4
#define  HS_DIAGCROSS       5


** Text-Formatting Attributes:
** ===========================
#define  ALIGN_LEFT             0
#define  ALIGN_RIGHT		1
#define  ALIGN_CENTER		2
#define  ALIGN_JUSTIFIED	3


** AUTOBREAK-OPTIONS:
** =================
#define AUTO_BREAK_ON        0
#define AUTO_BREAK_OFF       1
#define AUTO_BREAK_NO_LIMITS 2


** Picture Attributes:
** ===================
#define PIC_MERGE             1  && merge background with bitmap (SRCAND instead of SRCCOPY)
#define PIC_KEEPIMAGE         2  && always hold the image-data in memory
#define PIC_DISCARD_DIB_DRAW  4  && always discard the DIB from memory (immediately after drawing)
#define PIC_KEEP_DIB_PAGE     8  && always hold the DIB in memory
#define PIC_BESTFIT          16  && scale best fitting into given rectangle
#define PIC_IN_FILE          32  && store image directly in file (not the pathname-link)


** Printer- / Setup-Flags:
** ======================
#define PRINTDLG_NEVER  0       && never show setup-dialog (if file_name is NULL, last setting 
                                && or the setting of the default-printer will be taken)
#define PRINTDLG_ONFAIL 1       && show setup-dialog only, if file-read fails
#define PRINTDLG_ALWAYS 2       && show setup-dialog always

#define PRINT_ALL       0       && print all pages
#define PRINT_EVEN      1       && print only even pages
#define PRINT_ODD       2       && print only odd pages


** ========================================================================
**                        Notification Messages:
** ========================================================================
#define VPE_DESTROYWINDOW (WM_USER+2306)  && VPE was destroyed
#define VPE_PRINT         (WM_USER+2307)  && printing: wParam = 1: started
                                          &&                  = 0: ended
                                          && lParam = Doc-Handle
#define VPE_PRINTCANCEL   (WM_USER+2308)  && printing: Setup-Dialog aborted
                                          && lParam = Doc-Handle
#define VPE_HELP          (WM_USER+2309)  && User requests help




** ========================================================================
**                         Barcode Types:
** ========================================================================
#define BCT_EAN13           1
#define BCT_EAN8            2
#define BCT_UPCA            3
#define BCT_CODABAR         5
#define BCT_CODE39          6
#define BCT_2OF5            7
#define BCT_INTERLEAVED2OF5 8  
#define BCT_UPCE            9
#define BCT_EAN13_2         10
#define BCT_EAN13_5         11
#define BCT_EAN8_2          12
#define BCT_EAN8_5          13
#define BCT_UPCA_2          14
#define BCT_UPCA_5          15
#define BCT_UPCE_2          16
#define BCT_UPCE_5          17
#define BCT_EAN128A         18
#define BCT_EAN128B         19
#define BCT_EAN128C         20
#define BCT_CODE93          21
#define BCT_POSTNET         22



** ========================================================================
**                          Positioning Codes:
** ========================================================================
#define VFREE           -1
#define VLEFT           -2
#define VRIGHT          -3
#define VLEFTMARGIN     -4
#define VRIGHTMARGIN    -5
#define VTOP            -6
#define VBOTTOM         -7
#define VTOPMARGIN      -8
#define VBOTTOMMARGIN   -9

** EOF vpecomon.h
