//
//              VPIFACE.H
//              =========
//
// The DLL-Interface for the "Virtual Print Engine".
//
// To be used by the calling applications.
//
// external Macro-Definitions:
// WINDOWS_DLL     generates Windows DLL-Code, else Windows static library
//
// 11/94 by IDEAL Software, T. Radde
//



#ifndef _MODULE_VPIFACE
#define _MODULE_VPIFACE


#ifdef WINDOWS_DLL
   #define EXPO    FAR PASCAL _export
#else
   #define EXPO
#endif   



extern "C"
{
   int  EXPO VpeGetVersion();
   long EXPO VpeOpenDoc(HWND hWndParent, char *title, int page_width, int page_height, long flags);
   long EXPO VpeOpenDocFile(HWND hWndParent, LPSTR file_name, char *title, int page_width, int page_height, long flags);
   int  EXPO VpeCloseDoc(long hDoc);
   HWND EXPO VpeWindowHandle(long hDoc);
   void EXPO VpeSetDefOutRect(long hDoc, RECT *r);
   void EXPO VpeSetDefOutRectSP(long hDoc, int x, int y, int x2, int y2);
   void EXPO VpeSetOutRect(long hDoc, RECT *r);
   void EXPO VpeGetOutRect(long hDoc, RECT *r);
   void EXPO VpeSetPosRect(long hDoc, RECT *r);
   void EXPO VpeGetPosRect(long hDoc, RECT *r);
   void EXPO VpeSet(long hDoc, int what, int value);
   int  EXPO VpeGet(long hDoc, int what);
   void EXPO VpeStorePos(long hDoc);
   void EXPO VpeRestorePos(long hDoc);
   void EXPO VpeSetScale(long hDoc, double scale);
   void EXPO VpeSetRulersMeasure(long hDoc, int rulers_measure);
   int  EXPO VpeSetupPrinter(long hDoc, LPSTR file_name, int dialog_control);
   void EXPO VpeSetPrintOptions(long hDoc, long flags);
   void EXPO VpePrintDoc(long hDoc, int with_setup);
   int  EXPO VpeIsPrinting(long hDoc);
   void EXPO VpePreviewDoc(long hDoc, RECT *rc, int show_hide);
   void EXPO VpePreviewDocSP(long hDoc, int x, int y, int x2, int y2, int show_hide);
   void EXPO VpeCenterPreview(long hDoc, int width, int height, HWND parent_window);
   void EXPO VpeSetUpdate(long hDoc, int yes_no);
   void EXPO VpeRefreshDoc(long hDoc);
   void EXPO VpeSetPen(long hDoc, int pen_size, int pen_style, COLORREF color);
   void EXPO VpeNoPen(long hDoc);
   void EXPO VpeLine(long hDoc, int x, int y, int x2, int y2);
   long EXPO VpePolyLine(long hDoc, POINT *p, unsigned int size);
   void EXPO VpeAddPolyPoint(long hDoc, long p,  int x, int y);
   long EXPO VpePolygon(long h, POINT *pt, unsigned int size);
   void EXPO VpeAddPolygonPoint(long h, long p, int x, int y);
   void EXPO VpeSetBkgColor(long hDoc, COLORREF color);
   void EXPO VpeSetTransparentMode(long hDoc, int on_off);
   void EXPO VpeSetHatchStyle(long hDoc, int style);
   void EXPO VpeSetHatchColor(long hDoc, COLORREF color);
   void EXPO VpeBox(long hDoc, int x, int y, int x2, int y2);
   void EXPO VpeEllipse(long hDoc, int x, int y, int x2, int y2);
   void EXPO VpePie(long hDoc, int x, int y, int x2, int y2, int begin_angle, int end_angle);
   void EXPO VpeSetBarcodeParms(long hDoc, int top_bottom, int add_top_bottom);
   void EXPO VpeBarcode(long hDoc, int x, int y, int x2, int y2, 
                        int code_type, LPSTR code, LPSTR add_code);
   void EXPO VpeKeepBitmapAspect(long hDoc, int on_off);
   void EXPO VpeDefaultBitmapDPI(long hDoc, int dpix, int dpiy);
   void EXPO VpeGetPictureTypes(int with_filters, LPSTR s, int size);
   void EXPO VpePicture(long hDoc, int x, int y, int x2, int y2, LPSTR file_name, int flags);
   void EXPO VpePictureDIB(long h, int x, int y, int x2, int y2, HGLOBAL hDIB, int flags);
   void EXPO VpePictureResID(long h, int x, int y, int x2, int y2, int hInstance, unsigned int res_id, int flags);
   void EXPO VpePictureResName(long h, int x, int y, int x2, int y2, int hInstance, LPSTR res_name, int flags);
   void EXPO VpeSelectFont(long hDoc, char *name, int size);
   void EXPO VpeSetFontAttr(long hDoc, int alignment, int bold, int underlined, int italic);
   void EXPO VpeSetAlign(long hDoc, int alignment);
   void EXPO VpeSetBold(long hDoc, int bold);
   void EXPO VpeSetUnderlined(long hDoc, int underlined);
   void EXPO VpeSetItalic(long hDoc, int italic);
   void EXPO VpeSetTextColor(long hDoc, COLORREF color);
   int  EXPO VpePrint(long hDoc, int x, int y, char *s);
   int  EXPO VpePrintBox(long hDoc, int x, int y, char *s);
   int  EXPO VpeWrite(long hDoc, int x, int y, int x2, int y2, char *s);
   int  EXPO VpeWriteBox(long hDoc, int x, int y, int x2, int y2, char *s);
   void EXPO VpeDefineHeader(long hDoc, int x, int y, int x2, int y2, char *s);
   void EXPO VpeDefineFooter(long hDoc, int x, int y, int x2, int y2, char *s);
   void EXPO VpePageBreak(long hDoc);
   int  EXPO VpeGetPageCount(long hDoc);
   int  EXPO VpeGetCurrentPage(long hDoc);
   void EXPO VpeGotoPage(long hDoc, int page);
   void EXPO VpeStoreSet(long hDoc, int id);
   void EXPO VpeUseSet(long hDoc, int id);
   void EXPO VpeRemoveSet(long hDoc, int id);
   void EXPO VpeSetAutoBreak(long hDoc, int mode);
   void EXPO VpeWriteDoc(long hDoc, LPSTR file_name);
   void EXPO VpeReadDoc(long hDoc, LPSTR file_name);
   void EXPO VpeSetRotation(long hDoc, int angle);
}


#endif          // _MODULE_VPIFACE

